/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import toni.immersivemessages.IMClient;
import toni.immersivemessages.ImmersiveFont;
import toni.immersivemessages.ImmersiveMessages;
import toni.immersivemessages.api.ObfuscateMode;
import toni.immersivemessages.api.SoundEffect;
import toni.immersivemessages.networking.TooltipPacket;
import toni.lib.animation.AnimationTimeline;
import toni.lib.animation.Binding;
import toni.lib.animation.easing.EasingType;
import toni.lib.networking.codecs.StreamCodec;
import toni.lib.utils.VersionUtils;

public class ImmersiveMessage {
    public class_2583 style = class_2583.field_24360;
    private class_5250 text;
    public AnimationTimeline animation;
    public ImmersiveMessage subtext;
    public boolean shadow = true;
    public boolean border;
    public float yLevel = 55.0f;
    public float xLevel = 0.0f;
    public float delay = 0.0f;
    private ObfuscateMode obfuscateMode = ObfuscateMode.NONE;
    private float obfuscateSpeed = 1.0f;
    public boolean typewriter = false;
    public boolean typewriterCenterAligned = false;
    public float typewriterSpeed = 1.0f;
    public class_5250 typewriterCurrent = class_2561.method_43470((String)"");
    public SoundEffect soundEffect = SoundEffect.NONE;
    private float typewriterTicks;
    private int typewriterTimes = 1;
    private float obfuscateTicks;
    private int obfuscateTimes = 1;
    public static final StreamCodec<ByteBuf, ImmersiveMessage> CODEC = new StreamCodec<ByteBuf, ImmersiveMessage>(){

        public ImmersiveMessage decode(ByteBuf byteBuf) {
            return ImmersiveMessage.decode(byteBuf);
        }

        public void encode(ByteBuf byteBuf, ImmersiveMessage tooltip) {
            tooltip.encode(byteBuf);
        }
    };

    private ImmersiveMessage() {
    }

    private void encode(ByteBuf buffer) {
        class_2540 buf = new class_2540(buffer);
        buf.method_49395(class_2583.field_39241, (Object)this.style);
        String str = class_2561.class_2562.method_10867((class_2561)this.text);
        buf.method_10814(str);
        this.animation.encode(buf);
        buf.writeBoolean(this.subtext != null);
        if (this.subtext != null) {
            this.subtext.encode((ByteBuf)buf);
        }
        buf.writeBoolean(this.shadow);
        buf.writeBoolean(this.border);
        buf.writeFloat(this.yLevel);
        buf.writeFloat(this.xLevel);
        buf.writeFloat(this.delay);
        buf.method_10817((Enum)this.obfuscateMode);
        buf.writeFloat(this.obfuscateSpeed);
        buf.method_10817((Enum)this.soundEffect);
        buf.writeBoolean(this.typewriter);
        buf.writeBoolean(this.typewriterCenterAligned);
        buf.writeFloat(this.typewriterSpeed);
    }

    private static ImmersiveMessage decode(ByteBuf buffer) {
        class_2540 buf = new class_2540(buffer);
        ImmersiveMessage ths = new ImmersiveMessage();
        ths.style = (class_2583)buf.method_49394(class_2583.field_39241);
        String str = buf.method_19772();
        ths.text = class_2561.class_2562.method_10877((String)str);
        ths.animation = AnimationTimeline.decode((class_2540)buf);
        boolean hasSubtext = buf.readBoolean();
        if (hasSubtext) {
            ths.subtext = ImmersiveMessage.decode((ByteBuf)buf);
        }
        ths.shadow = buf.readBoolean();
        ths.border = buf.readBoolean();
        ths.yLevel = buf.readFloat();
        ths.xLevel = buf.readFloat();
        ths.delay = buf.readFloat();
        ths.obfuscateMode = (ObfuscateMode)buf.method_10818(ObfuscateMode.class);
        ths.obfuscateSpeed = buf.readFloat();
        ths.soundEffect = (SoundEffect)buf.method_10818(SoundEffect.class);
        ths.typewriter = buf.readBoolean();
        ths.typewriterCenterAligned = buf.readBoolean();
        ths.typewriterSpeed = buf.readFloat();
        return ths;
    }

    public static ImmersiveMessage builder(float duration, String text) {
        ImmersiveMessage tooltip = new ImmersiveMessage();
        tooltip.text = class_2561.method_43470((String)text);
        tooltip.style = class_2583.field_24360;
        tooltip.animation = AnimationTimeline.builder((float)duration);
        tooltip.animation.withYPosition(tooltip.yLevel);
        return tooltip;
    }

    public static ImmersiveMessage builder(float duration, class_5250 text) {
        ImmersiveMessage tooltip = new ImmersiveMessage();
        tooltip.text = text;
        tooltip.style = class_2583.field_24360;
        tooltip.animation = AnimationTimeline.builder((float)duration);
        tooltip.animation.withYPosition(tooltip.yLevel);
        return tooltip;
    }

    public class_5250 getText() {
        if (this.typewriter) {
            return this.typewriterCurrent.method_27696(this.style);
        }
        return this.text.method_27696(this.style);
    }

    public class_5250 getRawText() {
        return this.text.method_27696(this.style);
    }

    public ImmersiveMessage typewriter(float speed, boolean centerAligned) {
        this.typewriterSpeed = speed;
        this.typewriterCurrent = class_2561.method_43470((String)"");
        this.typewriterCenterAligned = centerAligned;
        this.typewriter = true;
        return this;
    }

    public ImmersiveMessage sound(SoundEffect effect) {
        this.soundEffect = effect;
        return this;
    }

    public ImmersiveMessage apply(Consumer<ImmersiveMessage> consumer) {
        consumer.accept(this);
        return this;
    }

    public ImmersiveMessage subtext(float delay, String subtext, Consumer<ImmersiveMessage> builder) {
        return this.subtext(delay, subtext, 10.0f, builder);
    }

    public ImmersiveMessage subtext(float delay, String subtext, float offset, Consumer<ImmersiveMessage> builder) {
        this.subtext = ImmersiveMessage.builder(this.animation.duration, subtext);
        this.subtext.delay = delay;
        this.subtext.y(this.yLevel + offset);
        this.subtext.size(0.75f);
        builder.accept(this.subtext);
        return this;
    }

    public ImmersiveMessage y(float ylevel) {
        this.yLevel = ylevel;
        this.animation.withYPosition(ylevel);
        return this;
    }

    public ImmersiveMessage x(float xlevel) {
        this.xLevel = xlevel;
        this.animation.withXPosition(xlevel);
        return this;
    }

    public ImmersiveMessage bold() {
        return this.style((class_2583 style) -> style.method_10982(Boolean.valueOf(true)));
    }

    public ImmersiveMessage italic() {
        return this.style((class_2583 style) -> style.method_10978(Boolean.valueOf(true)));
    }

    public ImmersiveMessage size(float size) {
        this.animation.withSize(size);
        return this;
    }

    public ImmersiveMessage fadeIn() {
        return this.fadeIn(1.0f);
    }

    public ImmersiveMessage fadeIn(float duration) {
        this.animation.transition(Binding.Alpha, this.delay, this.delay + duration, 0.0f, 1.0f, EasingType.EaseOutSine);
        return this;
    }

    public ImmersiveMessage fadeOut() {
        return this.fadeOut(1.0f);
    }

    public ImmersiveMessage fadeOut(float duration) {
        this.animation.fadeout(duration);
        return this;
    }

    public ImmersiveMessage shake() {
        return this.shake(100.0f, 0.75f);
    }

    public ImmersiveMessage shake(float speed, float intensity) {
        this.animation.waveEffect(Binding.xPos, intensity, speed, 0.0f, this.animation.duration);
        this.animation.waveEffect(Binding.yPos, intensity, speed * 0.95f, 0.0f, this.animation.duration);
        return this;
    }

    public ImmersiveMessage wave() {
        return this.wave(5.0f, 2.5f);
    }

    public ImmersiveMessage wave(float speed, float intensity) {
        this.animation.waveEffect(Binding.zRot, intensity, speed, 0.0f, this.animation.duration);
        return this;
    }

    public ImmersiveMessage slideUp() {
        return this.slideUp(1.0f);
    }

    public ImmersiveMessage slideUp(float duration) {
        this.animation.transition(Binding.yPos, this.delay, this.delay + duration, this.yLevel + 50.0f, this.yLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideDown() {
        return this.slideDown(1.0f);
    }

    public ImmersiveMessage slideDown(float duration) {
        this.animation.transition(Binding.yPos, this.delay, this.delay + duration, this.yLevel - 50.0f, this.yLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideLeft() {
        return this.slideLeft(1.0f);
    }

    public ImmersiveMessage slideLeft(float duration) {
        this.animation.transition(Binding.xPos, this.delay, this.delay + duration, this.xLevel - 50.0f, this.xLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideRight() {
        return this.slideRight(1.0f);
    }

    public ImmersiveMessage slideRight(float duration) {
        this.animation.transition(Binding.xPos, this.delay, this.delay + duration, this.xLevel + 50.0f, this.xLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage font(String font) {
        this.style = this.style.method_27704(VersionUtils.resource((String)font));
        return this;
    }

    public ImmersiveMessage font(ImmersiveFont font) {
        this.style = this.style.method_27704(font.getLocation());
        return this;
    }

    public ImmersiveMessage style(class_2583 style) {
        this.style = style;
        return this;
    }

    public ImmersiveMessage style(Function<class_2583, class_2583> function) {
        this.style = function.apply(this.style);
        return this;
    }

    public ImmersiveMessage shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public ImmersiveMessage animation(Consumer<AnimationTimeline> animationBuilder) {
        animationBuilder.accept(this.animation);
        return this;
    }

    public void sendLocal(class_746 player) {
        ImmersiveMessages.showToPlayer(player, this);
    }

    public void sendServer(class_3222 player) {
        new TooltipPacket(this).send(player);
    }

    public void sendServer(Collection<class_3222> players) {
        players.forEach(this::sendServer);
    }

    public void sendServerToAll(MinecraftServer server) {
        new TooltipPacket(this).sendToAll(server);
    }

    public ImmersiveMessage obfuscate() {
        return this.obfuscate(ObfuscateMode.RANDOM, 1.0f);
    }

    public ImmersiveMessage obfuscate(float speed) {
        return this.obfuscate(ObfuscateMode.RANDOM, speed);
    }

    public ImmersiveMessage obfuscate(ObfuscateMode mode) {
        return this.obfuscate(mode, 1.0f);
    }

    public ImmersiveMessage obfuscate(ObfuscateMode mode, float speed) {
        this.obfuscateMode = mode;
        this.obfuscateSpeed = speed;
        StringBuilder sb = new StringBuilder();
        String str = this.text.getString();
        for (char chr : str.toCharArray()) {
            sb.append("\u00a7k");
            sb.append(chr);
            sb.append("\u00a7r");
        }
        this.text = class_2561.method_43470((String)sb.toString());
        return this;
    }

    public ImmersiveMessage color(@Nullable class_5251 color) {
        return this.style((class_2583 style) -> style.method_27703(color));
    }

    public ImmersiveMessage color(@Nullable class_124 formatting) {
        return this.style((class_2583 style) -> style.method_10977(formatting));
    }

    public ImmersiveMessage color(int rgb) {
        return this.style((class_2583 style) -> style.method_36139(rgb));
    }

    public void tick(float delta) {
        this.tickObfuscation(delta);
        this.tickTypewriter(delta);
    }

    private void tickTypewriter(float delta) {
        String str = this.text.getString();
        if (this.typewriterTimes > str.length()) {
            return;
        }
        this.typewriterTicks += delta;
        if (!(this.typewriterTicks > (float)this.typewriterTimes * (1.0f / this.typewriterSpeed))) {
            return;
        }
        ++this.typewriterTimes;
        String current = str.substring(0, Math.min(str.length(), this.typewriterTimes));
        this.typewriterCurrent = class_2561.method_43470((String)current);
        char lastChar = current.charAt(current.length() - 1);
        if (lastChar == ',') {
            this.typewriterTicks -= 3.0f / this.typewriterSpeed;
            return;
        }
        if (lastChar == '.') {
            this.typewriterTicks -= 5.0f * (1.0f / this.typewriterSpeed);
            return;
        }
        if (lastChar == '\u00a7') {
            this.typewriterTicks -= 5.0f * (1.0f / this.typewriterSpeed);
            return;
        }
        if (lastChar == ' ') {
            this.typewriterTicks += 1.0f / this.typewriterSpeed;
            ++this.typewriterTimes;
            this.typewriterCurrent = class_2561.method_43470((String)str.substring(0, Math.min(str.length(), this.typewriterTimes)));
        }
        if (this.soundEffect != SoundEffect.NONE) {
            IMClient.playSoundEffect(this);
        }
    }

    private void tickObfuscation(float delta) {
        this.obfuscateTicks += delta;
        if (!(this.obfuscateTicks > (float)this.obfuscateTimes * (1.0f / this.obfuscateSpeed))) {
            return;
        }
        String str = this.text.getString();
        ++this.obfuscateTimes;
        switch (this.obfuscateMode) {
            case LEFT: {
                this.text = class_2561.method_43470((String)str.replaceFirst("\u00a7k", ""));
                break;
            }
            case RIGHT: {
                int index = str.lastIndexOf("\u00a7k");
                if (index == -1) break;
                this.text = class_2561.method_43470((String)(str.substring(0, index) + str.substring(index + 2)));
                break;
            }
            case CENTER: {
                int index = this.getClosestIndexToCenter(str, "\u00a7k");
                if (index == -1) break;
                this.text = class_2561.method_43470((String)(str.substring(0, index) + str.substring(index + 2)));
                break;
            }
            case RANDOM: {
                ArrayList<Integer> occurrences = new ArrayList<Integer>();
                for (int i = 0; i <= str.length() - 2; ++i) {
                    if (!str.startsWith("\u00a7k", i)) continue;
                    occurrences.add(i);
                }
                if (occurrences.isEmpty()) break;
                Random rand = new Random();
                int index = (Integer)occurrences.get(rand.nextInt(occurrences.size()));
                this.text = class_2561.method_43470((String)(str.substring(0, index) + str.substring(index + 2)));
            }
        }
    }

    private int getClosestIndexToCenter(String str, String target) {
        int centerIndex = str.length() / 2;
        int closestIndex = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i <= str.length() - target.length(); ++i) {
            int distanceFromCenter;
            if (!str.substring(i, i + target.length()).equals(target) || (distanceFromCenter = Math.abs(i - centerIndex)) >= minDistance) continue;
            closestIndex = i;
            minDistance = distanceFromCenter;
        }
        return closestIndex;
    }
}

