/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.api.chesttype;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.codecs.EnumCodec;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_2073;
import tech.thatgravyboat.ironchests.api.chesttype.ChestBlockType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestRegistries;
import tech.thatgravyboat.ironchests.api.chesttype.ChestUpgradeType;
import tech.thatgravyboat.ironchests.api.property.Properties;
import tech.thatgravyboat.ironchests.api.property.base.BlockProperty;
import tech.thatgravyboat.ironchests.api.shape.ShapeTypes;
import tech.thatgravyboat.ironchests.api.shape.base.Shape;

public record ChestType(String name, ChestBlockType blockType, Shape<?> shape, int length, int rows, int size, int inventoryOffset, int menuOffset, int width, int height, BlockProperty properties, ChestRegistries registries, boolean transparent, String texture, class_2073 predicate, boolean renderItems, boolean fireResistant, String oxidizedChest) {
    public ChestType(String name, ChestBlockType renderType, Shape<?> shape, int length, int rows, int inventoryOffset, int menuOffset, int width, int height, BlockProperty properties, boolean transparent, Optional<String> texture, class_2073 slotPredicate, boolean renderItems, boolean fireResistant, Optional<String> oxidizedChest) {
        this(name, renderType, shape, length, rows, length * rows, inventoryOffset, menuOffset, width, height, properties, new ChestRegistries(), transparent, texture.orElse(null), slotPredicate, renderItems, fireResistant, oxidizedChest.orElse(null));
    }

    public ChestType {
        if (size < 18 && renderItems) {
            throw new IllegalArgumentException("Chest Type requires the chest size to be at least 18 total for render items be shown as it looks the best with 18 items.");
        }
    }

    public static Codec<ChestType> codec(String name) {
        return RecordCodecBuilder.create(instance -> instance.group((App)MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(() -> name)).forGetter(ChestType::name), (App)EnumCodec.of(ChestBlockType.class).fieldOf("block_type").orElse((Object)ChestBlockType.CHEST).forGetter(ChestType::blockType), (App)ShapeTypes.CODEC.fieldOf("shape").orElse(ShapeTypes.DEFAULT).forGetter(ChestType::shape), (App)Codec.INT.fieldOf("length").forGetter(ChestType::length), (App)Codec.INT.fieldOf("rows").forGetter(ChestType::rows), (App)Codec.INT.fieldOf("inventoryOffset").forGetter(ChestType::inventoryOffset), (App)Codec.INT.fieldOf("menuOffset").forGetter(ChestType::menuOffset), (App)Codec.INT.fieldOf("width").forGetter(ChestType::width), (App)Codec.INT.fieldOf("height").forGetter(ChestType::height), (App)Properties.CODEC.fieldOf("properties").forGetter(ChestType::properties), (App)Codec.BOOL.fieldOf("transparent").orElse((Object)false).forGetter(ChestType::transparent), (App)Codec.STRING.optionalFieldOf("texture").forGetter(CodecExtras.optionalFor(ChestType::texture)), (App)CodecExtras.passthrough(class_2073::method_8971, class_2073::method_8969).fieldOf("predicate").orElse((Object)class_2073.field_9640).forGetter(ChestType::predicate), (App)Codec.BOOL.fieldOf("renderItems").orElse((Object)false).forGetter(ChestType::renderItems), (App)Codec.BOOL.fieldOf("fireResistant").orElse((Object)false).forGetter(ChestType::fireResistant), (App)Codec.STRING.optionalFieldOf("oxidizedChest").forGetter(CodecExtras.optionalFor(ChestType::oxidizedChest))).apply((Applicative)instance, ChestType::new));
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT) + "_" + this.blockType().id();
    }

    public ChestType getOxidizedChest() {
        if (this.oxidizedChest == null) {
            return null;
        }
        return ChestUpgradeType.get(this.oxidizedChest());
    }
}

