/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class DamageFilterItem
extends StringValueFilterItem {
    @Override
    public StringValueData<?> createData(class_1799 stack) {
        return new DamageData(stack);
    }

    @Override
    public boolean filter(class_1799 filter, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        DamageData data = (DamageData)this.getStringValueData(filter);
        if (data.getValue() == null) {
            return false;
        }
        int d1 = stack.method_7919();
        int d2 = ((DamageCheck)data.getValue()).percent ? (int)((double)(stack.method_7936() * ((DamageCheck)data.getValue()).damage) / 100.0) : ((DamageCheck)data.getValue()).damage;
        return switch (((DamageCheck)data.getValue()).mode) {
            case 1 -> {
                if (d1 >= d2) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (d1 <= d2) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (d1 > d2) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (d1 < d2) {
                    yield true;
                }
                yield false;
            }
            default -> d1 == d2;
        };
    }

    @Override
    public String getHelpKey() {
        return "itemfilters.help_text.damage";
    }

    public static class DamageData
    extends StringValueData<DamageCheck> {
        public DamageData(class_1799 is) {
            super(is);
        }

        @Override
        @Nullable
        protected DamageCheck fromString(String s) {
            s = s.replaceAll("\\s", "");
            try {
                DamageCheck check = new DamageCheck();
                if (s.endsWith("%")) {
                    check.percent = true;
                    s = s.substring(0, s.length() - 1);
                }
                if (s.startsWith(">=")) {
                    check.mode = 1;
                    s = s.substring(2);
                } else if (s.startsWith("<=")) {
                    check.mode = 2;
                    s = s.substring(2);
                } else if (s.startsWith(">")) {
                    check.mode = 3;
                    s = s.substring(1);
                } else if (s.startsWith("<")) {
                    check.mode = 4;
                    s = s.substring(1);
                }
                check.damage = Integer.parseInt(s);
                return check;
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        protected String toString(DamageCheck value) {
            if (value == null) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            switch (value.mode) {
                case 1: {
                    builder.append(">=");
                    break;
                }
                case 2: {
                    builder.append("<=");
                    break;
                }
                case 3: {
                    builder.append(">");
                    break;
                }
                case 4: {
                    builder.append("<");
                }
            }
            builder.append(value.damage);
            if (value.percent) {
                builder.append('%');
            }
            return builder.toString();
        }
    }

    public static class DamageCheck {
        public int mode;
        public int damage;
        public boolean percent;
    }
}

