/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.registry;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistryData;
import net.minecraft.class_2248;
import org.jetbrains.annotations.Nullable;

public class SlabRegistry {
    private static final List<SlabRegistryData> slabRegistry = new ArrayList<SlabRegistryData>();
    private static final Map<class_2248, SlabConverter> slabMap = new HashMap<class_2248, SlabConverter>();

    public static void registerSlabConverter(class_2248 doubleSlab, SlabConverter converter) {
        slabMap.put(doubleSlab, converter);
    }

    public static void registerSlab(SlabRegistryData data) {
        try {
            Constructor<? extends SlabConverter> constructor = data.getConverterClass().getConstructor(class_2248.class);
            SlabConverter converter = constructor.newInstance(data.getSingleSlab());
            SlabRegistry.registerSlabConverter(data.getDoubleSlab(), converter);
            slabRegistry.add(data);
        }
        catch (NoSuchMethodException e) {
            KleeSlabs.logger.error("Slab converter class does not have a constructor that takes a Block argument: {}", data.getConverterClass());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            KleeSlabs.logger.error("Slab converter class constructor invocation failed: {}", data.getConverterClass(), (Object)e);
        }
    }

    public static List<SlabRegistryData> getSlabEntries() {
        return slabRegistry;
    }

    @Nullable
    public static SlabConverter getSlabConverter(class_2248 block) {
        return slabMap.get(block);
    }

    public static void clearRegistry() {
        slabRegistry.clear();
        slabMap.clear();
    }
}

