/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson;

import com.github.leawind.thirdperson.ThirdPersonEvents;
import com.github.leawind.thirdperson.ThirdPersonKeys;
import com.github.leawind.thirdperson.ThirdPersonResources;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.config.ConfigManager;
import com.github.leawind.thirdperson.core.CameraAgent;
import com.github.leawind.thirdperson.core.EntityAgent;
import com.github.leawind.thirdperson.util.FiniteChecker;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import dev.architectury.platform.Platform;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThirdPerson {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Leawind's Third Person");
    public static final FiniteChecker FINITE_CHECKER = new FiniteChecker(err -> LOGGER.error(err.toString()));
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    public static EntityAgent ENTITY_AGENT;
    public static CameraAgent CAMERA_AGENT;

    public static void init() {
        class_310 minecraft = class_310.method_1551();
        LOGGER.debug("Initializing mod {}", (Object)"Leawind's Third Person");
        MixinExtrasBootstrap.init();
        ENTITY_AGENT = new EntityAgent(minecraft);
        CAMERA_AGENT = new CameraAgent(minecraft);
        CONFIG_MANAGER.tryLoad();
        ThirdPersonResources.register();
        ThirdPersonKeys.register();
        ThirdPersonEvents.register();
        Platform.getMod((String)"leawind_third_person").registerConfigurationScreen(CONFIG_MANAGER::getConfigScreen);
    }

    public static boolean isAvailable() {
        class_310 minecraft = class_310.method_1551();
        return minecraft.field_1724 != null && minecraft.field_1719 != null && ThirdPerson.getConfig().is_mod_enabled && minecraft.field_1773.method_19418().method_19332();
    }

    @NotNull
    public static Config getConfig() {
        return CONFIG_MANAGER.getConfig();
    }

    public static void resetFiniteCheckers() {
        FINITE_CHECKER.reset();
        ThirdPerson.ENTITY_AGENT.FINITE_CHECKER.reset();
        ThirdPerson.CAMERA_AGENT.FINITE_CHECKER.reset();
    }
}

