/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.config;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonConstants;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.screen.ConfigScreenBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigManager {
    private final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().disableHtmlEscaping().create();
    private final Timer lazySaveTimer = new Timer();
    @NotNull
    private Config config = new Config();
    private boolean isLazySaveScheduled = false;

    public void tryLoad() {
        ThirdPerson.LOGGER.debug("Trying loading config from {}", (Object)ThirdPersonConstants.CONFIG_FILE);
        try {
            ThirdPersonConstants.CONFIG_FILE.getParentFile().mkdirs();
            if (ThirdPersonConstants.CONFIG_FILE.exists()) {
                this.load();
                ThirdPerson.LOGGER.info("Config is loaded from {}", (Object)ThirdPersonConstants.CONFIG_FILE);
            } else {
                ThirdPerson.LOGGER.info("Config not found, creating one.");
                this.trySave();
            }
        }
        catch (IOException e) {
            ThirdPerson.LOGGER.error("Failed to load config.", (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            ThirdPerson.LOGGER.error("Config file is broken.", (Throwable)e);
        }
        this.config.update();
    }

    public void lazySave() {
        if (!this.isLazySaveScheduled) {
            this.isLazySaveScheduled = true;
            this.lazySaveTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ConfigManager.this.trySave();
                    ConfigManager.this.isLazySaveScheduled = false;
                }
            }, 60000L);
        }
    }

    public void trySave() {
        ThirdPerson.LOGGER.debug("Trying saving config to {}", (Object)ThirdPersonConstants.CONFIG_FILE);
        try {
            this.save();
            ThirdPerson.LOGGER.info("Config is saved.");
        }
        catch (IOException e) {
            ThirdPerson.LOGGER.error("Failed to save config.", (Throwable)e);
        }
        this.config.update();
    }

    public void load() throws IOException {
        this.config = (Config)this.GSON.fromJson(Files.readString(ThirdPersonConstants.CONFIG_FILE.toPath(), StandardCharsets.UTF_8), Config.class);
    }

    public void save() throws IOException {
        FileUtils.writeStringToFile((File)ThirdPersonConstants.CONFIG_FILE, (String)this.GSON.toJson((Object)this.config), (Charset)StandardCharsets.UTF_8);
    }

    @Nullable
    public class_437 getConfigScreen(@Nullable class_437 parent) {
        ConfigScreenBuilder builder = ConfigScreenBuilder.getBuilder();
        if (builder == null) {
            ThirdPerson.LOGGER.warn("No config screen builder available.");
            return null;
        }
        ThirdPerson.LOGGER.debug("Building config screen");
        return builder.build(this.config, parent);
    }

    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static class_2561 getText(@NotNull String name) {
        return class_2561.method_43471((String)("leawind_third_person." + name));
    }
}

