/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.core;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonConstants;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.api.client.event.ThirdPersonCameraSetupEvent;
import com.github.leawind.thirdperson.config.AbstractConfig;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.core.AimingTargetComparator;
import com.github.leawind.thirdperson.core.cameraoffset.AbstractCameraOffsetMode;
import com.github.leawind.thirdperson.mixin.CameraInvoker;
import com.github.leawind.thirdperson.mixin.ClientLevelInvoker;
import com.github.leawind.thirdperson.mixin.GameRendererInvoker;
import com.github.leawind.thirdperson.util.FiniteChecker;
import com.github.leawind.thirdperson.util.math.LMath;
import com.github.leawind.thirdperson.util.math.Zone;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothDouble;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothVector2d;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothVector3d;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_5577;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class CameraAgent {
    public final FiniteChecker FINITE_CHECKER = new FiniteChecker(err -> ThirdPerson.LOGGER.error(err.toString()));
    @NotNull
    private final class_310 minecraft;
    @NotNull
    private final ExpSmoothVector3d smoothRotateCenter;
    @NotNull
    private final class_4184 tempCamera = new class_4184();
    @NotNull
    private final Vector2d relativeRotation = new Vector2d(0.0);
    @NotNull
    private final ExpSmoothVector2d smoothOffsetRatio;
    @NotNull
    private final ExpSmoothDouble smoothDistance;
    @NotNull
    private final ExpSmoothDouble smoothFovDivisor;
    @NotNull
    private class_239 hitResult = class_3965.method_17778((class_243)class_243.field_1353, (class_2350)class_2350.field_11034, (class_2338)class_2338.field_10980);

    public CameraAgent(@NotNull class_310 minecraft) {
        this.minecraft = minecraft;
        this.smoothRotateCenter = new ExpSmoothVector3d();
        this.smoothOffsetRatio = new ExpSmoothVector2d();
        this.smoothDistance = new ExpSmoothDouble();
        this.smoothFovDivisor = new ExpSmoothDouble();
        this.smoothFovDivisor.set(1.0);
    }

    public void reset() {
        ThirdPerson.LOGGER.debug("Reset CameraAgent");
        this.smoothOffsetRatio.setValue(0.0, 0.0);
        this.smoothDistance.set(0.0);
        this.smoothFovDivisor.set(1.0);
        if (ThirdPerson.ENTITY_AGENT.isCameraEntityExist()) {
            this.smoothRotateCenter.set(this.getRotateCenterTarget(1.0f));
            class_1297 entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
            this.relativeRotation.set((double)(-entity.method_36455()), (double)(entity.method_36454() - 180.0f));
        }
    }

    public void checkGameStatus() {
        if (this.minecraft.field_1690.method_31044() == class_5498.field_26664) {
            ThirdPersonStatus.isPerspectiveInverted = (Double)this.smoothDistance.get() > 0.05;
        }
    }

    public void onRenderTickStart(double now, double period, float partialTick) {
        if (!this.minecraft.method_1493() && ThirdPersonStatus.isRenderingInThirdPerson()) {
            this.hitResult = this.pick(this.getPickRange());
            this.updateSmoothVirtualDistance(period);
            this.updateSmoothOffsetRatio(period);
            this.updateSmoothFovMultiplier(period);
            if (ThirdPersonStatus.shouldCameraTurnWithEntity()) {
                Vector2d rot = ThirdPerson.ENTITY_AGENT.getRawRotation(partialTick);
                this.FINITE_CHECKER.checkOnce(rot.x, rot.y);
                this.relativeRotation.set(-rot.x, rot.y - 180.0);
            }
        }
    }

    public double getSmoothFovDivisor() {
        return (Double)this.smoothFovDivisor.get();
    }

    public void onCameraSetup(@NotNull ThirdPersonCameraSetupEvent event) {
        this.updateTempCameraRotationPosition(event.partialTick);
        event.setPosition(this.tempCamera.method_19326());
        float yRot = this.tempCamera.method_19330();
        float xRot = this.tempCamera.method_19329();
        this.FINITE_CHECKER.checkOnce(Float.valueOf(xRot), Float.valueOf(yRot));
        event.setRotation(xRot, yRot);
    }

    public Vector3d getRotateCenterTarget(float partialTick) {
        Config config = ThirdPerson.getConfig();
        class_1297 entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        class_243 eyePosition = entity.method_5836(partialTick);
        return LMath.toVector3d(eyePosition.method_38499(class_2350.class_2351.field_11052, eyePosition.field_1351 + config.rotate_center_height_offset));
    }

    public boolean limitRotateCenter(Vector3d rotateCenter, float partialTick) {
        class_1297 entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        class_243 smoothEyePosition = LMath.toVec3(this.smoothRotateCenter.get(partialTick));
        class_243 eyePosition = new class_243(smoothEyePosition.field_1352, entity.method_5836((float)partialTick).field_1351, smoothEyePosition.field_1350);
        Zone limit = Zone.ofAuto(eyePosition.field_1351, rotateCenter.y).expendRadius(0.5);
        class_243 pickEnd = new class_243(eyePosition.field_1352, limit.max, eyePosition.field_1350);
        class_3965 hitResult = entity.method_37908().method_17742(new class_3959(eyePosition, pickEnd, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, class_3959.class_242.field_1348, entity));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            limit = limit.withMax(hitResult.method_17784().field_1351);
        }
        pickEnd = new class_243(eyePosition.field_1352, limit.min, eyePosition.field_1350);
        hitResult = entity.method_37908().method_17742(new class_3959(eyePosition, pickEnd, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, class_3959.class_242.field_1348, entity));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            limit = limit.withMin(hitResult.method_17784().field_1351);
        }
        for (int i = 0; i < 4; ++i) {
            double offsetX = 0.3 * (double)((i & 1) * 2 - 1);
            double offsetZ = 0.3 * (double)((i >> 1 & 1) * 2 - 1);
            pickEnd = new class_243(eyePosition.field_1352 + offsetX, limit.max, eyePosition.field_1350 + offsetZ);
            hitResult = entity.method_37908().method_17742(new class_3959(eyePosition, pickEnd, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, class_3959.class_242.field_1348, entity));
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                limit = limit.withMax(hitResult.method_17784().field_1351);
            }
            pickEnd = new class_243(eyePosition.field_1352 + offsetX, limit.min, eyePosition.field_1350 + offsetZ);
            hitResult = entity.method_37908().method_17742(new class_3959(eyePosition, pickEnd, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, class_3959.class_242.field_1348, entity));
            if (hitResult.method_17783() != class_239.class_240.field_1332) continue;
            limit = limit.withMin(hitResult.method_17784().field_1351);
        }
        double newY = (limit = limit.squeezeSafely(0.5)).nearest(rotateCenter.y);
        boolean result = newY != rotateCenter.y;
        rotateCenter.y = newY;
        return result;
    }

    @NotNull
    public Vector3d getRotateCenterFinally(float partialTick) {
        boolean isVerticalZero;
        Vector3d rotateCenter = this.smoothRotateCenter.get(partialTick);
        Vector3d smoothFactor = (Vector3d)this.smoothRotateCenter.smoothFactor;
        boolean isHorizontalZero = smoothFactor.x * smoothFactor.z == 0.0;
        boolean bl = isVerticalZero = smoothFactor.y == 0.0;
        if (isHorizontalZero || isVerticalZero) {
            Vector3d rotateCenterTarget = this.getRotateCenterTarget(partialTick);
            rotateCenter = new Vector3d(isHorizontalZero ? rotateCenterTarget.x : rotateCenter.x, isVerticalZero ? rotateCenterTarget.y : rotateCenter.y, isHorizontalZero ? rotateCenterTarget.z : rotateCenter.z);
        }
        if (this.limitRotateCenter(rotateCenter, partialTick)) {
            ((Vector3d)this.smoothRotateCenter.target).y = rotateCenter.y;
        }
        return rotateCenter;
    }

    public void onClientTickStart() {
        Config config = ThirdPerson.getConfig();
        Vector3d halflife = this.minecraft.field_1690.method_31044() == class_5498.field_26664 ? new Vector3d(0.0) : (ThirdPerson.ENTITY_AGENT.isFallFlying() ? new Vector3d(config.flying_smooth_halflife) : config.getCameraOffsetScheme().getMode().getEyeSmoothHalflife());
        double dist = this.getRotateCenterFinally(1.0f).distance((Vector3dc)ThirdPerson.CAMERA_AGENT.getRawCameraPosition());
        halflife.mul(Math.pow(dist, 0.5) * 0.1);
        this.smoothRotateCenter.setHalflife(halflife);
        this.smoothRotateCenter.setTarget(this.getRotateCenterTarget(1.0f));
        this.smoothRotateCenter.update(0.05);
    }

    @NotNull
    public class_4184 getRawCamera() {
        return Objects.requireNonNull(class_310.method_1551().field_1773.method_19418());
    }

    @NotNull
    public Vector3d getRawCameraPosition() {
        return LMath.toVector3d(this.getRawCamera().method_19326());
    }

    @NotNull
    public Vector2d getRotation() {
        return new Vector2d(-this.relativeRotation.x, this.relativeRotation.y % 360.0 - 180.0);
    }

    public void setRotation(Vector2d rot) {
        this.relativeRotation.x = -rot.x;
        this.relativeRotation.y = rot.y % 360.0 - 180.0;
    }

    public Vector2d getRawRotation() {
        class_4184 camera = ThirdPerson.CAMERA_AGENT.getRawCamera();
        return new Vector2d((double)camera.method_19329(), (double)camera.method_19330());
    }

    public void turnCamera(double dYRot, double dXRot) {
        this.FINITE_CHECKER.checkOnce(dYRot, dXRot);
        Config config = ThirdPerson.getConfig();
        if (config.is_mod_enabled && !ThirdPersonStatus.isAdjustingCameraOffset() && (dYRot != 0.0 || dXRot != 0.0)) {
            double xRot;
            double yRot = this.getRelativeRotation().y + dYRot;
            yRot %= 360.0;
            if (config.lock_camera_pitch_angle) {
                xRot = this.getRelativeRotation().x;
            } else {
                xRot = this.getRelativeRotation().x - dXRot;
                xRot = LMath.clamp(xRot, -89.8, 89.8);
            }
            this.relativeRotation.set(xRot, yRot);
        }
    }

    @NotNull
    public Vector2d getRelativeRotation() {
        return this.relativeRotation;
    }

    @NotNull
    public class_239 getHitResult() {
        return this.hitResult;
    }

    public double getPickRange() {
        return ThirdPerson.ENTITY_AGENT.getBodyRadius() + (Double)this.smoothDistance.get() + ThirdPerson.getConfig().camera_ray_trace_length;
    }

    @NotNull
    public class_239 pick(double pickRange) {
        double entityDistance;
        class_3965 blockHitResult;
        class_243 cameraPos = this.getRawCamera().method_19326();
        double blockDistance = cameraPos.method_1022((blockHitResult = this.pickBlock(pickRange)).method_17784());
        class_3966 entityHitResult = this.pickEntity(pickRange = Math.min(pickRange, blockDistance + 1.0));
        if (entityHitResult != null && (entityDistance = cameraPos.method_1022(entityHitResult.method_17784())) < blockDistance) {
            return entityHitResult;
        }
        return blockHitResult;
    }

    @Nullable
    public class_3966 pickEntity(double pickRange) {
        if (!ThirdPerson.ENTITY_AGENT.isCameraEntityExist()) {
            return null;
        }
        class_1297 cameraEntity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        class_4184 camera = this.getRawCamera();
        class_243 viewVector = new class_243(camera.method_19335());
        class_243 pickFrom = camera.method_19326();
        class_243 pickTo = viewVector.method_1021(pickRange).method_1019(pickFrom);
        class_238 aabb = new class_238(pickFrom, pickTo);
        return class_1675.method_18075((class_1297)cameraEntity, (class_243)pickFrom, (class_243)pickTo, (class_238)aabb, target -> !target.method_7325() && target.method_5863(), (double)pickRange);
    }

    @NotNull
    public class_3965 pickBlock(double pickRange, @NotNull class_3959.class_3960 blockShape, @NotNull class_3959.class_242 fluidShape) {
        class_4184 camera = this.getRawCamera();
        class_243 pickFrom = camera.method_19326();
        class_243 viewVector = new class_243(camera.method_19335());
        class_243 pickTo = pickFrom.method_1019(viewVector.method_1021(pickRange));
        class_1297 cameraEntity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        return cameraEntity.method_37908().method_17742(new class_3959(pickFrom, pickTo, blockShape, fluidShape, cameraEntity));
    }

    @NotNull
    public class_3965 pickBlock(double pickRange) {
        return this.pickBlock(pickRange, ThirdPerson.ENTITY_AGENT.wasAiming() ? class_3959.class_3960.field_17558 : class_3959.class_3960.field_17559, class_3959.class_242.field_1348);
    }

    public boolean isLookingAt(@NotNull class_1297 entity) {
        class_243 from = this.getRawCamera().method_19326();
        class_243 to = from.method_1019(new class_243(this.getRawCamera().method_19335()).method_1021(this.getPickRange()));
        class_238 aabb = entity.method_5829();
        return aabb.method_1006(from) || aabb.method_992(from, to).isPresent();
    }

    @Nullable
    public class_1297 predictTargetEntity(float partialTick) {
        if (this.hitResult.method_17783() == class_239.class_240.field_1332) {
            return null;
        }
        Config config = ThirdPerson.getConfig();
        ArrayList candidateTargets = Lists.newArrayList();
        class_243 cameraPos = this.getRawCamera().method_19326();
        Vector2d cameraRot = this.getRotation();
        Vector3d cameraViewVector = LMath.directionFromRotationDegree(cameraRot).normalize();
        if (ThirdPerson.ENTITY_AGENT.isControlled()) {
            class_746 playerEntity = ThirdPerson.ENTITY_AGENT.getRawPlayerEntity();
            class_638 clientLevel = (class_638)playerEntity.method_37908();
            class_5577<class_1297> entityGetter = ((ClientLevelInvoker)clientLevel).invokeGetEntityGetter();
            for (class_1297 target : entityGetter.method_31803()) {
                double distance;
                if (!(target instanceof class_1309) || (distance = (double)target.method_5739((class_1297)playerEntity)) < 2.0 || distance > config.camera_ray_trace_length || target.method_5779((class_1297)playerEntity)) continue;
                class_243 targetPos = target.method_30950(partialTick);
                Vector3d bottomY = LMath.toVector3d(targetPos.method_38499(class_2350.class_2351.field_11052, target.method_5829().field_1322));
                Vector3d vectorToBottom = new Vector3d((Vector3dc)bottomY).sub((Vector3dc)ThirdPerson.ENTITY_AGENT.getRawEyePosition(partialTick));
                if (LMath.rotationDegreeFromDirection((Vector3d)vectorToBottom).x < cameraRot.x) continue;
                Vector3d vectorToTarget = LMath.toVector3d(targetPos.method_1020(cameraPos)).normalize();
                FiniteChecker.assertFinite(vectorToTarget.x, vectorToTarget.y, vectorToTarget.z);
                double angrad = Math.acos(cameraViewVector.dot((Vector3dc)vectorToTarget));
                if (!(Math.toDegrees(angrad) < 30.0)) continue;
                candidateTargets.add(target);
            }
        }
        if (!candidateTargets.isEmpty()) {
            candidateTargets.sort(new AimingTargetComparator(cameraPos, cameraViewVector));
            return (class_1297)candidateTargets.get(0);
        }
        return null;
    }

    private void updateTempCameraRotationPosition(float partialTick) {
        ((CameraInvoker)this.tempCamera).invokeSetRotation((float)(this.relativeRotation.y + 180.0), (float)(-this.relativeRotation.x));
        class_310 minecraft = class_310.method_1551();
        AbstractConfig.CameraDistanceMode cameraDistanceMode = ThirdPerson.getConfig().camera_distance_mode;
        double aspectRatio = (double)minecraft.method_22683().method_4489() / (double)minecraft.method_22683().method_4506();
        double fov = ((GameRendererInvoker)minecraft.field_1773).invokeGetFov(this.getRawCamera(), partialTick, true);
        double verticalRadianHalf = Math.toRadians(fov) / 2.0;
        double heightHalf = Math.tan(verticalRadianHalf) * 0.05;
        double widthHalf = aspectRatio * heightHalf;
        Vector3d forward = LMath.toVector3d(this.tempCamera.method_19335());
        Vector3d left = LMath.toVector3d(this.tempCamera.method_35689());
        Vector3d up = LMath.toVector3d(this.tempCamera.method_19336());
        double verticalFovHalf = Math.toRadians(fov);
        double horizontalFovHalf = 2.0 * Math.atan(widthHalf / 0.05);
        Vector2d offsetRatio = this.smoothOffsetRatio.get(partialTick);
        double absPitchDegree = Math.abs(this.relativeRotation.x);
        double multiplier = absPitchDegree > 80.0 ? (90.0 - absPitchDegree) / 10.0 : 1.0;
        offsetRatio.mul(multiplier);
        double offsetX = offsetRatio.x;
        double offsetY = offsetRatio.y;
        Vector3d direction = forward.sub((Vector3dc)up.mul(offsetY * Math.tan(verticalFovHalf / 2.0)).add((Vector3dc)left.mul(offsetX * Math.tan(horizontalFovHalf / 2.0))));
        if (cameraDistanceMode == AbstractConfig.CameraDistanceMode.STRAIGHT) {
            direction.normalize();
            FiniteChecker.assertFinite(direction.x, direction.y, direction.z);
        }
        Vector3d rotateCenterVector3d = this.getRotateCenterFinally(partialTick);
        double bodyRadius = ThirdPerson.ENTITY_AGENT.getBodyRadius();
        class_243 cameraPosition = LMath.toVec3(rotateCenterVector3d.sub((Vector3dc)direction.mul(bodyRadius + (Double)this.smoothDistance.get())));
        ((CameraInvoker)this.tempCamera).invokeSetPosition(cameraPosition);
        class_243 rotateCenter = LMath.toVec3(this.getRotateCenterFinally(partialTick));
        class_1297 entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        if (entity.method_7325() && ThirdPerson.ENTITY_AGENT.isEyeInWall((class_3959.class_3961)class_3959.class_3960.field_23142)) {
            return;
        }
        class_243 rotateCenterToCamera = rotateCenter.method_1035(cameraPosition);
        double initDistance = rotateCenterToCamera.method_1033();
        if (initDistance < 1.0E-5) {
            return;
        }
        double limit = initDistance;
        for (int i = 0; i < 8; ++i) {
            double offsetX2 = 0.18 * (double)((i & 1) * 2 - 1);
            double offsetY2 = 0.18 * (double)((i >> 1 & 1) * 2 - 1);
            double offsetZ = 0.18 * (double)((i >> 2 & 1) * 2 - 1);
            class_243 pickFrom = rotateCenter.method_1031(offsetX2, offsetY2, offsetZ);
            class_243 pickTo = pickFrom.method_1019(rotateCenterToCamera);
            class_3965 hitResult = entity.method_37908().method_17742(new class_3959(pickFrom, pickTo, ThirdPersonConstants.CAMERA_OBSTACLE_BLOCK_SHAPE_GETTER, class_3959.class_242.field_1348, ThirdPerson.ENTITY_AGENT.getRawCameraEntity()));
            if (hitResult.method_17783() == class_239.class_240.field_1333) continue;
            limit = Math.min(limit, hitResult.method_17784().method_1022(pickFrom));
        }
        if (limit < initDistance) {
            switch (cameraDistanceMode) {
                case PLANE: {
                    this.smoothDistance.setValue(Math.max(0.0, (Double)this.smoothDistance.get() + limit - initDistance));
                    break;
                }
                case STRAIGHT: {
                    this.smoothDistance.setValue(Math.max(0.0, limit - bodyRadius));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid camera distance mode: " + String.valueOf((Object)cameraDistanceMode));
                }
            }
            class_243 limitedPosition = rotateCenter.method_1019(rotateCenterToCamera.method_1021(limit / initDistance));
            ((CameraInvoker)this.tempCamera).invokeSetPosition(limitedPosition);
        }
    }

    private void updateSmoothVirtualDistance(double period) {
        Config config = ThirdPerson.getConfig();
        AbstractCameraOffsetMode mode = config.getCameraOffsetScheme().getMode();
        boolean isAdjusting = ThirdPersonStatus.isAdjustingCameraDistance();
        double BODY_RADIUS = ThirdPerson.ENTITY_AGENT.getBodyRadius();
        if (this.minecraft.field_1690.method_31044() == class_5498.field_26664) {
            this.smoothDistance.setHalflife(config.t2f_transition_halflife);
            this.smoothDistance.setTarget(-BODY_RADIUS * 0.5);
        } else {
            this.smoothDistance.setHalflife(isAdjusting ? config.adjusting_distance_smooth_halflife : mode.getDistanceSmoothHalflife());
            this.smoothDistance.setTarget((mode.getDistanceLimit() * ThirdPerson.ENTITY_AGENT.vehicleTotalSizeCached + BODY_RADIUS) * this.getSmoothFovDivisor() - BODY_RADIUS);
        }
        this.smoothDistance.update(period);
        this.FINITE_CHECKER.checkOnce(this.smoothDistance.get());
    }

    private void updateSmoothOffsetRatio(double period) {
        Config config = ThirdPerson.getConfig();
        AbstractCameraOffsetMode mode = config.getCameraOffsetScheme().getMode();
        if (ThirdPersonStatus.isAdjustingCameraOffset()) {
            this.smoothOffsetRatio.setHalflife(config.adjusting_camera_offset_smooth_halflife);
        } else {
            this.smoothOffsetRatio.setHalflife(mode.getOffsetSmoothHalflife());
        }
        if (config.center_offset_when_flying && ThirdPerson.ENTITY_AGENT.isFallFlying()) {
            this.smoothOffsetRatio.setTarget(0.0, 0.0);
        } else {
            this.smoothOffsetRatio.setTarget(mode.getOffsetRatio());
        }
        this.smoothOffsetRatio.update(period);
    }

    private void updateSmoothFovMultiplier(double period) {
        Config config = ThirdPerson.getConfig();
        this.smoothFovDivisor.setHalflife(config.getCameraOffsetScheme().getMode().getDistanceSmoothHalflife());
        this.smoothFovDivisor.setTarget(ThirdPerson.ENTITY_AGENT.wasAiming() ? config.aiming_fov_divisor : 1.0);
        this.smoothFovDivisor.update(period);
    }
}

