/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.core;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonResources;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.core.rotation.RotateStrategy;
import com.github.leawind.thirdperson.core.rotation.RotateTargetEnum;
import com.github.leawind.thirdperson.core.rotation.SmoothTypeEnum;
import com.github.leawind.thirdperson.util.FiniteChecker;
import com.github.leawind.thirdperson.util.ItemPredicateUtil;
import com.github.leawind.thirdperson.util.math.LMath;
import com.github.leawind.thirdperson.util.math.decisionmap.DecisionMap;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothDouble;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothRotation;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_746;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class EntityAgent {
    public final FiniteChecker FINITE_CHECKER = new FiniteChecker(err -> ThirdPerson.LOGGER.error(err.toString()));
    private final class_310 minecraft;
    private final ExpSmoothRotation smoothRotation = ExpSmoothRotation.createWithHalflife(0.5);
    private final ExpSmoothDouble smoothOpacity;
    public double vehicleTotalSizeCached = 1.0;
    @NotNull
    private RotateTargetEnum rotateTarget = RotateTargetEnum.NONE;
    @NotNull
    private SmoothTypeEnum smoothRotationType = SmoothTypeEnum.EXP_LINEAR;
    private final DecisionMap<Double> rotateDecisionMap = RotateStrategy.build();
    private boolean wasAiming = false;

    public EntityAgent(@NotNull class_310 minecraft) {
        this.minecraft = minecraft;
        this.smoothOpacity = new ExpSmoothDouble();
        this.smoothOpacity.set(1.0);
        ThirdPerson.LOGGER.debug(this.rotateDecisionMap.toDescription());
    }

    public boolean isCameraEntityExist() {
        return this.minecraft.field_1719 != null;
    }

    public void reset() {
        ThirdPerson.LOGGER.debug("Reset EntityAgent");
        this.smoothOpacity.set(0.0);
        this.wasAiming = false;
    }

    @NotNull
    public RotateTargetEnum getRotateTarget() {
        return this.rotateTarget;
    }

    public void setRotateTarget(@NotNull RotateTargetEnum rotateTarget) {
        this.rotateTarget = rotateTarget;
    }

    @NotNull
    public SmoothTypeEnum getRotationSmoothType() {
        return this.smoothRotationType;
    }

    public void setRotationSmoothType(@NotNull SmoothTypeEnum smoothType) {
        this.smoothRotationType = smoothType;
    }

    public void setSmoothRotationHalflife(double halflife) {
        this.smoothRotation.setHalflife(halflife);
    }

    public float getSmoothOpacity(float partialTick) {
        return this.smoothOpacity.get(partialTick).floatValue();
    }

    public ExpSmoothRotation getSmoothRotation() {
        return this.smoothRotation;
    }

    @PerformanceSensitive
    public void onRenderTickStart(double now, double period, float partialTick) {
        if (ThirdPersonStatus.isRenderingInThirdPerson() && this.isControlled() && !ThirdPersonStatus.shouldCameraTurnWithEntity()) {
            Vector2d targetRotation = this.getRotateTarget().getRotation(partialTick);
            this.smoothRotation.setTarget(targetRotation);
            switch (this.smoothRotationType) {
                case HARD: {
                    this.setRawRotation(targetRotation);
                    break;
                }
                case LINEAR: 
                case EXP_LINEAR: {
                    this.setRawRotation(this.smoothRotation.get(partialTick));
                    break;
                }
                case EXP: {
                    this.smoothRotation.update(period);
                    this.setRawRotation(this.smoothRotation.get());
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid smooth rotation type: " + String.valueOf((Object)this.smoothRotationType));
                }
            }
        }
    }

    public void onClientTickStart() {
        if (ThirdPersonStatus.clientTicks % 2 == 0) {
            this.vehicleTotalSizeCached = this.getVehicleTotalSize();
        }
        ++ThirdPersonStatus.clientTicks;
        this.wasAiming = this.isAiming();
        ThirdPerson.getConfig().getCameraOffsetScheme().setAiming(this.wasAiming());
        this.updateRotateStrategy();
        this.updateBodyRotation();
        this.updateSmoothOpacity(0.05, 1.0f);
        switch (this.smoothRotationType) {
            case HARD: 
            case EXP: {
                break;
            }
            case LINEAR: 
            case EXP_LINEAR: {
                this.smoothRotation.setTarget(this.getRotateTarget().getRotation(1.0f));
                this.smoothRotation.update(0.05);
            }
        }
    }

    public void setRawRotation(@NotNull Vector2d rot) {
        this.FINITE_CHECKER.checkOnce(rot.x, rot.y);
        class_746 entity = this.getRawPlayerEntity();
        entity.field_5982 = (float)rot.y;
        entity.method_36456(entity.field_5982);
        entity.field_6004 = (float)rot.x;
        entity.method_36457(entity.field_6004);
    }

    public boolean isControlled() {
        return this.getRawPlayerEntity() == this.minecraft.field_1719;
    }

    @NotNull
    public class_1297 getRawCameraEntity() {
        return Objects.requireNonNull(this.minecraft.field_1719);
    }

    @NotNull
    public class_746 getRawPlayerEntity() {
        return Objects.requireNonNull(this.minecraft.field_1724);
    }

    @NotNull
    public Vector3d getRawEyePosition(float partialTick) {
        return LMath.toVector3d(this.getRawCameraEntity().method_5836(partialTick));
    }

    @NotNull
    public Vector2d getRawRotation(float partialTick) {
        class_1297 entity = this.getRawCameraEntity();
        return new Vector2d((double)entity.method_5695(partialTick), (double)entity.method_5705(partialTick));
    }

    public boolean isEyeInWall(@NotNull class_3959.class_3961 shapeGetter) {
        class_1297 cameraEntity = this.getRawCameraEntity();
        class_243 eyePos = cameraEntity.method_33571();
        class_2338 blockPos = class_2338.method_49637((double)eyePos.field_1352, (double)eyePos.field_1351, (double)eyePos.field_1350);
        class_2680 blockState = cameraEntity.method_37908().method_8320(blockPos);
        class_238 eyeAabb = class_238.method_30048((class_243)eyePos, (double)0.8, (double)1.0E-6, (double)0.8);
        return shapeGetter.get(blockState, (class_1922)cameraEntity.method_37908(), blockPos, class_3726.method_16194()).method_1090().stream().anyMatch(a -> a.method_996(blockPos).method_994(eyeAabb));
    }

    public boolean isInteracting() {
        if (!this.isControlled()) {
            class_1309 livingEntity;
            class_1297 class_12972 = this.getRawCameraEntity();
            return class_12972 instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6115();
        }
        class_315 options = this.minecraft.field_1690;
        return options.field_1904.method_1434() || options.field_1886.method_1434() || options.field_1871.method_1434();
    }

    public boolean isFallFlying() {
        class_1309 livingEntity;
        class_1297 class_12972 = this.getRawCameraEntity();
        return class_12972 instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6128();
    }

    public boolean isSprinting() {
        return this.getRawCameraEntity().method_5624();
    }

    public boolean isEating() {
        class_1297 class_12972 = this.getRawCameraEntity();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return livingEntity.method_6030().method_19267();
        }
        return false;
    }

    public boolean isAiming() {
        Config config = ThirdPerson.getConfig();
        if (ThirdPersonStatus.doesPlayerWantToAim()) {
            return true;
        }
        class_1297 class_12972 = this.getRawCameraEntity();
        if (class_12972 instanceof class_1309) {
            boolean shouldBeAiming;
            class_1839 anim;
            class_1309 livingEntity = (class_1309)class_12972;
            if (config.determine_aim_mode_by_animation && livingEntity.method_6115() && ((anim = livingEntity.method_6030().method_7976()) == class_1839.field_8953 || anim == class_1839.field_8951)) {
                return true;
            }
            boolean bl = shouldBeAiming = ItemPredicateUtil.anyMatches(livingEntity.method_6047(), config.getHoldToAimItemPredicates(), ThirdPersonResources.itemPredicateManager.holdToAimItemPredicates) || ItemPredicateUtil.anyMatches(livingEntity.method_6079(), config.getHoldToAimItemPredicates(), ThirdPersonResources.itemPredicateManager.holdToAimItemPredicates);
            if (livingEntity.method_6115()) {
                shouldBeAiming |= ItemPredicateUtil.anyMatches(livingEntity.method_6030(), config.getUseToAimItemPredicates(), ThirdPersonResources.itemPredicateManager.useToAimItemPredicates);
            }
            return shouldBeAiming;
        }
        return false;
    }

    public boolean wasAiming() {
        return this.wasAiming;
    }

    public class_238 getBoundingBox(float partialTick) {
        class_1297 entity = this.getRawCameraEntity();
        return entity.method_18377(entity.method_18376()).method_30757(entity.method_30950(partialTick));
    }

    public double boxDistanceTo(@NotNull Vector3d target, float partialTick) {
        class_238 aabb = this.getBoundingBox(partialTick);
        Vector3d c = new Vector3d(LMath.clamp(target.x, aabb.field_1323, aabb.field_1320), LMath.clamp(target.y, aabb.field_1322, aabb.field_1325), LMath.clamp(target.z, aabb.field_1321, aabb.field_1324));
        return c.distance((Vector3dc)target);
    }

    public double getBodyRadius() {
        return (double)this.getRawCameraEntity().method_17681() * 0.8660254037844386;
    }

    public double columnDistanceTo(@NotNull Vector3d target, float partialTick) {
        class_1297 entity = this.getRawCameraEntity();
        Vector3d c = LMath.toVector3d(entity.method_30950(partialTick));
        double maxY = c.y + (double)entity.method_5751();
        c.y = LMath.clamp(target.y, c.y, maxY);
        double dist = c.distance((Vector3dc)target);
        if (maxY > target.y && target.y > c.y) {
            dist = Math.max(0.0, dist - this.getBodyRadius());
        }
        return dist;
    }

    private void updateRotateStrategy() {
        this.setSmoothRotationHalflife(this.rotateDecisionMap.updateAll().make());
    }

    private void updateBodyRotation() {
        class_746 player;
        Config config = ThirdPerson.getConfig();
        if (config.auto_turn_body_drawing_a_bow && ThirdPerson.ENTITY_AGENT.isControlled() && (player = this.getRawPlayerEntity()).method_6115() && player.method_6030().method_31574(class_1802.field_8102)) {
            double k;
            double d = k = player.method_6058() == class_1268.field_5808 ? 1.0 : -1.0;
            if (this.minecraft.field_1690.method_42552().method_41753() == class_1306.field_6182) {
                k = -k;
            }
            player.field_6283 = (float)(k * 45.0 + (double)player.method_36454());
        }
    }

    private void updateSmoothOpacity(double period, float partialTick) {
        double targetOpacity = 1.0;
        Config config = ThirdPerson.getConfig();
        if (config.player_fade_out_enabled) {
            double C = 0.36;
            Vector3d cameraPosition = LMath.toVector3d(ThirdPerson.CAMERA_AGENT.getRawCamera().method_19326());
            double distance = this.getRawEyePosition(partialTick).distance((Vector3dc)cameraPosition);
            targetOpacity = (distance - 0.36) / 0.64;
            this.FINITE_CHECKER.checkOnce(targetOpacity);
            if (targetOpacity > config.gaze_opacity && !this.isFallFlying() && ThirdPerson.CAMERA_AGENT.isLookingAt(this.getRawCameraEntity())) {
                targetOpacity = config.gaze_opacity;
            }
        }
        this.smoothOpacity.setTarget(LMath.clamp(targetOpacity, 0.0, 1.0));
        this.smoothOpacity.setHalflife(0.0625 * (this.wasAiming() ? 0.25 : 1.0));
        this.smoothOpacity.update(period);
    }

    @Nullable
    public class_243 getInterestPoint() {
        if (LMath.subtractDegrees(this.getRawPlayerEntity().field_6283, ThirdPerson.CAMERA_AGENT.getRelativeRotation().y) > 90.0) {
            return ThirdPerson.CAMERA_AGENT.getHitResult().method_17784();
        }
        return LMath.toVec3(ThirdPerson.CAMERA_AGENT.getRawCameraPosition());
    }

    public double getVehicleTotalSize() {
        class_1297 root = this.getRawCameraEntity().method_5668();
        class_238 bb = root.method_31748().map(class_1297::method_5829).reduce(class_238::method_991).orElse(root.method_5829());
        return Math.hypot(Math.hypot(bb.method_17939(), bb.method_17940()), bb.method_17941());
    }
}

