/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.core.cameraoffset;

import com.github.leawind.thirdperson.config.Config;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector3d;

public abstract class AbstractCameraOffsetMode {
    @NotNull
    protected final Config config;

    public AbstractCameraOffsetMode(@NotNull Config config) {
        this.config = config;
    }

    public void setSide(boolean isCameraLeftOfPlayer) {
        if (isCameraLeftOfPlayer ^ this.isCameraLeftOfPlayer()) {
            this.toNextSide();
            this.setCentered(false);
        }
    }

    public void getOffsetRatio(@NotNull Vector2d v) {
        if (this.isCentered()) {
            v.set(0.0, this.getCenterOffsetRatio());
        } else {
            this.getSideOffsetRatio(v);
        }
    }

    public Vector2d getOffsetRatio() {
        Vector2d v = new Vector2d();
        this.getOffsetRatio(v);
        return v;
    }

    @NotNull
    public abstract Vector3d getEyeSmoothHalflife();

    public abstract double getDistanceSmoothHalflife();

    @NotNull
    public abstract Vector2d getOffsetSmoothHalflife();

    public abstract double getDistanceLimit();

    public abstract void setDistanceLimit(double var1);

    public abstract boolean isCentered();

    public abstract void setCentered(boolean var1);

    public abstract boolean isCameraLeftOfPlayer();

    public abstract void toNextSide();

    public abstract void setSideOffsetRatio(@NotNull Vector2d var1);

    public abstract double getCenterOffsetRatio();

    public abstract void setCenterOffsetRatio(double var1);

    @NotNull
    public abstract Vector2d getSideOffsetRatio(@NotNull Vector2d var1);
}

