/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util;

import java.util.function.Consumer;

public final class FiniteChecker {
    private final Consumer<InfiniteException> printer;
    private boolean failedOnce = false;

    public FiniteChecker(Consumer<InfiniteException> printer) {
        this.printer = printer;
    }

    public void reset() {
        this.failedOnce = false;
    }

    public boolean checkOnce(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (!FiniteChecker.notFinite(obj)) continue;
            if (!this.failedOnce) {
                InfiniteException err = new InfiniteException(obj, String.format("objects[%d] is not finite", i));
                this.printer.accept(err);
                this.failedOnce = true;
            }
            return true;
        }
        return false;
    }

    public boolean check(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (!FiniteChecker.notFinite(obj)) continue;
            InfiniteException err = new InfiniteException(obj, String.format("objects[%d] is not finite", i));
            this.printer.accept(err);
            this.failedOnce = true;
            return true;
        }
        return false;
    }

    public static void assertFinite(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            if (!FiniteChecker.notFinite(obj)) continue;
            throw new InfiniteException(obj, String.format("objects[%d] is not finite", i));
        }
    }

    private static boolean isFinite(Object obj) {
        return obj instanceof Float && Float.isFinite(((Float)obj).floatValue()) || obj instanceof Double && Double.isFinite((Double)obj);
    }

    private static boolean notFinite(Object obj) {
        return !FiniteChecker.isFinite(obj);
    }

    public static class InfiniteException
    extends RuntimeException {
        public final Object object;
        public final String message;

        public InfiniteException(Object object) {
            this(object, "Object is not finite");
        }

        public InfiniteException(Object object, String message) {
            this.object = object;
            this.message = message;
        }

        @Override
        public String toString() {
            StackTraceElement[] trace;
            StringBuilder s = new StringBuilder();
            s.append(String.format("InfiniteException: %s\n", this.message));
            s.append(String.format("Object: %s\n", this.object));
            s.append("Stacktrace:\n");
            for (StackTraceElement traceElement : trace = Thread.currentThread().getStackTrace()) {
                s.append("\tat ").append(traceElement).append("\n");
            }
            return s.toString();
        }
    }
}

