/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util;

import com.github.leawind.thirdperson.ThirdPerson;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemPredicateUtil {
    private static final Pattern RGX_NBT = Pattern.compile("^(\\{.*})$");
    private static final Pattern RGX_TAG_NBT = Pattern.compile("^#([a-z0-9.:_]+)(\\{.*})?$");
    private static final Pattern RGX_KEY_NBT = Pattern.compile("^([a-z0-9.:_]+)(\\{.*})?$");

    @NotNull
    public static Optional<class_2561> supplyError(String pattern) {
        try {
            ItemPredicateUtil.parse("minecraft", pattern);
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.of(class_2561.method_43470((String)e.getMessage()));
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    @SafeVarargs
    public static boolean anyMatches(@NotNull class_1799 itemStack, Iterable<class_2073> ... predicatesList) {
        if (itemStack.method_7960()) {
            return false;
        }
        for (Iterable<class_2073> predicates : predicatesList) {
            for (class_2073 predicate : predicates) {
                if (!predicate.method_8970(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static int addToSet(@NotNull String defaultNamespace, @NotNull Set<class_2073> predicates, @Nullable Iterable<String> patterns) {
        int count = 0;
        if (patterns != null) {
            for (String pattern : patterns) {
                try {
                    predicates.add(ItemPredicateUtil.parse(defaultNamespace, pattern));
                    ++count;
                }
                catch (IllegalArgumentException e) {
                    ThirdPerson.LOGGER.error("Skip invalid item pattern: {}, because {}", (Object)pattern, (Object)e.getMessage());
                }
                catch (IllegalStateException e) {
                    ThirdPerson.LOGGER.warn("Skip invalid item pattern: {}, because {}", (Object)pattern, (Object)e.getMessage());
                }
            }
        }
        return count;
    }

    public static class_2073 parse(String pattern) throws IllegalArgumentException, IllegalStateException {
        return ItemPredicateUtil.parse("minecraft", pattern);
    }

    public static class_2073 parse(String defaultNs, String pattern) throws IllegalArgumentException, IllegalStateException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Empty item pattern");
        }
        if (pattern.startsWith("{")) {
            return ItemPredicateUtil.parseNbtPredicate(defaultNs, pattern);
        }
        if (pattern.startsWith("#")) {
            return ItemPredicateUtil.parseTagPredicate(defaultNs, pattern);
        }
        return ItemPredicateUtil.parseKeyPredicate(defaultNs, pattern);
    }

    private static class_2073 parseNbtPredicate(String defaultNs, String pattern) throws IllegalArgumentException {
        if (!RGX_NBT.matcher(pattern).matches()) {
            throw new IllegalArgumentException(String.format("Invalid NBT: %s", pattern));
        }
        try {
            return ItemPredicateUtil.of(defaultNs, pattern, null, null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid NBT: %s, %s", pattern, e.getMessage()));
        }
    }

    private static class_2073 parseTagPredicate(String defaultNs, String pattern) throws IllegalArgumentException {
        Matcher m = RGX_TAG_NBT.matcher(pattern);
        if (m.matches()) {
            return ItemPredicateUtil.of(defaultNs, m.group(2), m.group(1), null);
        }
        throw new IllegalArgumentException(String.format("Invalid item tag: %s", pattern));
    }

    private static class_2073 parseKeyPredicate(String defaultNs, String pattern) throws IllegalArgumentException, IllegalStateException {
        Matcher m = RGX_KEY_NBT.matcher(pattern);
        if (m.matches()) {
            return ItemPredicateUtil.of(defaultNs, m.group(2), null, m.group(1));
        }
        throw new IllegalArgumentException(String.format("Invalid item pattern: %s", pattern));
    }

    private static class_2073 of(String defaultNs, @Nullable String nbtPattern, @Nullable String tagKeyPattern, @Nullable String itemKeyPattern) throws IllegalArgumentException, IllegalStateException {
        ImmutableSet items;
        class_2105 nbt;
        class_6862 tagKey = null;
        try {
            nbt = nbtPattern == null ? class_2105.field_9716 : new class_2105(class_2522.method_10718((String)nbtPattern));
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (tagKeyPattern != null) {
            tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)ItemPredicateUtil.parseResourceLocation(defaultNs, tagKeyPattern));
        }
        if (itemKeyPattern == null) {
            items = null;
        } else if (itemKeyPattern.isEmpty()) {
            items = ImmutableSet.of();
        } else {
            class_2960 resourceLocation = ItemPredicateUtil.parseResourceLocation(defaultNs, itemKeyPattern);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(resourceLocation);
            if (item == class_1802.field_8162) {
                throw new IllegalStateException(String.format("Item %s does not exist or it's minecraft:air", resourceLocation));
            }
            items = ImmutableSet.of((Object)item);
        }
        return new class_2073(tagKey, (Set)items, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, nbt);
    }

    private static class_2960 parseResourceLocation(String defaultNamespace, String pattern) throws IllegalArgumentException {
        try {
            return pattern.indexOf(58) < 0 ? new class_2960(defaultNamespace, pattern) : new class_2960(pattern);
        }
        catch (class_151 e) {
            throw new IllegalArgumentException(e);
        }
    }
}

