/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util.math.decisionmap;

import com.github.leawind.thirdperson.util.math.decisionmap.DecisionFactor;
import com.github.leawind.thirdperson.util.math.decisionmap.DecisionMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class DecisionMapBuilder<T> {
    private final String REVERSE_MARKER = "!~";
    private final Supplier<T> EMPTY_OPERATION = () -> null;
    private final List<@Nullable DecisionFactor> factors = new ArrayList<DecisionFactor>(32);
    private final List<@Nullable Rule<T>> rules = new LinkedList<Rule<T>>();
    private Supplier<T> defaultOperation = this.EMPTY_OPERATION;
    private int lastFactorIndex = -1;

    DecisionMapBuilder() {
    }

    public DecisionMapBuilder<T> clearRules() {
        this.rules.clear();
        this.defaultOperation = this.EMPTY_OPERATION;
        return this;
    }

    public DecisionFactor factor(String name) {
        for (DecisionFactor factor : this.factors) {
            if (factor == null || !factor.getName().equals(name)) continue;
            return factor;
        }
        throw new IllegalArgumentException("No such factor: " + name);
    }

    public DecisionMapBuilder<T> factor(String name, BooleanSupplier supplier) {
        return this.factor(this.lastFactorIndex + 1, name, supplier);
    }

    public DecisionMapBuilder<T> factor(int index, String name, BooleanSupplier supplier) {
        if (index < 0 || index >= 32) {
            throw new IndexOutOfBoundsException(String.format("Index %d out of bounds [%d, %d)", index, 0, 32));
        }
        if ("!~".indexOf(name.charAt(0)) != -1) {
            throw new IllegalArgumentException(String.format("Invalid factor name: %s", name));
        }
        for (DecisionFactor factor : this.factors) {
            if (factor == null) continue;
            if (factor.index == index) {
                throw new IllegalArgumentException("Duplicated factor index: " + index);
            }
            if (!factor.getName().equals(name)) continue;
            throw new IllegalArgumentException("Duplicated factor name: " + name);
        }
        while (this.factors.size() <= index) {
            this.factors.add(null);
        }
        DecisionFactor factor = new DecisionFactor(name, supplier);
        factor.index = index;
        this.factors.set(index, factor);
        this.lastFactorIndex = index;
        return this;
    }

    public DecisionMapBuilder<T> clearFactors() {
        this.factors.clear();
        return this;
    }

    public DecisionMapBuilder<T> whenDefault(@Nullable Supplier<T> operation) {
        this.defaultOperation = Objects.requireNonNullElse(operation, this.EMPTY_OPERATION);
        return this;
    }

    public DecisionMapBuilder<T> when(String name, Supplier<T> operation) {
        return this.when(name, true, operation);
    }

    public DecisionMapBuilder<T> when(String name, boolean value, Supplier<T> operation) {
        int index = this.factor((String)name).index;
        return this.when(1 << index, (value ? 1 : 0) << index, operation);
    }

    public DecisionMapBuilder<T> when(List<String> names, boolean value, Supplier<T> operation) {
        int mask = 0;
        for (String name : names) {
            mask |= this.factor(name).getMask();
        }
        int flags = value ? mask & 0xFFFFFFFF : 0;
        this.when(mask, flags, operation);
        return this;
    }

    public DecisionMapBuilder<T> when(List<String> expressions, Supplier<T> operation) {
        int mask = 0;
        int flags = 0;
        Iterator<String> iterator = expressions.iterator();
        while (iterator.hasNext()) {
            String expr;
            String name = expr = iterator.next();
            boolean value = true;
            if ("!~".indexOf(expr.charAt(0)) != -1) {
                name = expr.substring(1);
                value = false;
            }
            int factorMask = this.factor(name).getMask();
            mask |= factorMask;
            flags |= value ? factorMask : 0;
        }
        this.when(mask, flags, operation);
        return this;
    }

    public DecisionMapBuilder<T> when(int index, boolean value, Supplier<T> operation) {
        return this.when(1 << index, (value ? 1 : 0) << index, operation);
    }

    public DecisionMapBuilder<T> whenAll(int flags, Supplier<T> operation) {
        return this.when(-1, flags, operation);
    }

    public DecisionMapBuilder<T> when(int mask, int flags, Supplier<T> operation) {
        this.rules.add(new Rule<T>(mask, flags, operation));
        return this;
    }

    public DecisionMap<T> build() {
        for (int i = 0; i < this.factors.size(); ++i) {
            if (this.factors.get(i) != null) continue;
            throw new IllegalStateException(String.format("Factor[%d] has not been specified", i));
        }
        HashMap strategyMap = new HashMap();
        int filter = (int)((1L << this.factors.size()) - 1L);
        for (Rule<T> rule : this.rules) {
            if (rule == null) continue;
            rule.filter(filter);
            for (int flags = 0; flags <= filter; ++flags) {
                if ((rule.mask & flags) != rule.flags) continue;
                strategyMap.put(flags, rule.operation);
            }
        }
        return new DecisionMap(this.factors, strategyMap, this.defaultOperation);
    }

    private static class Rule<T> {
        final Supplier<T> operation;
        int mask;
        int flags;

        Rule(int mask, int flags, Supplier<T> operation) {
            this.mask = mask;
            this.flags = flags;
            this.operation = operation;
        }

        void filter(int filter) {
            this.mask &= filter;
            this.flags &= this.mask;
        }
    }
}

