/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util.modkeymapping;

import com.github.leawind.thirdperson.util.modkeymapping.ModKeyMapping;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import net.minecraft.class_304;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModKeyMappingImpl
extends class_304
implements ModKeyMapping {
    private long holdMs = 300L;
    private long pressMs = 300L;
    private long keyDownTime = 0L;
    @Nullable
    private Timer timer = null;
    @Nullable
    private Supplier<Boolean> onDown = null;
    @Nullable
    private Supplier<Boolean> onUp = null;
    @Nullable
    private Supplier<Boolean> onHold = null;
    @Nullable
    private Supplier<Boolean> onPress = null;

    public ModKeyMappingImpl(String id, int defaultValue, String categoryKey) {
        super(id, defaultValue, categoryKey);
        mappings.put(id, this);
    }

    @Override
    public boolean method_1434() {
        return super.method_1434();
    }

    public void method_23481(boolean down) {
        boolean wasDown = this.method_1434();
        super.method_23481(down);
        long now = System.currentTimeMillis();
        if (!wasDown && down) {
            if (ModKeyMappingImpl.runIfNonNull(this.onDown)) {
                return;
            }
            this.keyDownTime = now;
            if (this.onHold != null) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        ModKeyMappingImpl.runIfNonNull(ModKeyMappingImpl.this.onHold);
                        ModKeyMappingImpl.this.timer = null;
                    }
                }, this.holdMs);
            }
        } else if (wasDown && !down) {
            long sinceKeydown = now - this.keyDownTime;
            if (ModKeyMappingImpl.runIfNonNull(this.onUp)) {
                return;
            }
            if (sinceKeydown < this.pressMs) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                ModKeyMappingImpl.runIfNonNull(this.onPress);
            }
        }
    }

    @Override
    public ModKeyMappingImpl holdMs(long holdLength) {
        this.holdMs = holdLength;
        return this;
    }

    @Override
    public ModKeyMappingImpl pressMs(long pressLength) {
        this.pressMs = pressLength;
        return this;
    }

    @Override
    public ModKeyMappingImpl onDown(@NotNull Runnable handler) {
        return this.onDown(() -> {
            handler.run();
            return false;
        });
    }

    @Override
    public ModKeyMappingImpl onDown(@NotNull Supplier<Boolean> handler) {
        this.onDown = handler;
        return this;
    }

    @Override
    public ModKeyMappingImpl onUp(@NotNull Runnable handler) {
        return this.onUp(() -> {
            handler.run();
            return false;
        });
    }

    @Override
    public ModKeyMappingImpl onUp(@NotNull Supplier<Boolean> handler) {
        this.onUp = handler;
        return this;
    }

    @Override
    public ModKeyMappingImpl onPress(@NotNull Runnable handler) {
        return this.onPress(() -> {
            handler.run();
            return false;
        });
    }

    @Override
    public ModKeyMappingImpl onPress(@NotNull Supplier<Boolean> handler) {
        this.onPress = handler;
        return this;
    }

    @Override
    public ModKeyMappingImpl onHold(@NotNull Runnable handler) {
        return this.onHold(() -> {
            handler.run();
            return false;
        });
    }

    @Override
    public ModKeyMappingImpl onHold(@NotNull Supplier<Boolean> handler) {
        this.onHold = handler;
        return this;
    }

    private static boolean runIfNonNull(@Nullable Supplier<Boolean> handler) {
        return handler != null && handler.get() != false;
    }
}

