/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.satisfy.brewery.block.property.LineConnectingType;
import net.satisfy.brewery.entity.StorageBlockEntity;
import net.satisfy.brewery.registry.BlockStateRegistry;
import org.jetbrains.annotations.Nullable;

public class SideboardBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<LineConnectingType> TYPE = BlockStateRegistry.LINE_CONNECTING_TYPE;
    private final class_3414 openSound;
    private final class_3414 closeSound;
    public static final Map<class_2350, class_265> SHAPES = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_2350.field_11043, class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0));
        map.put(class_2350.field_11035, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0));
        map.put(class_2350.field_11039, class_2248.method_9541((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        map.put(class_2350.field_11034, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0));
    });

    public SideboardBlock(class_4970.class_2251 settings, class_3414 openSound, class_3414 closeSound) {
        super(settings);
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)LineConnectingType.NONE)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11654((class_2769)FACING));
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 facing = context.method_8042().method_10153();
        class_2680 blockState = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing);
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        LineConnectingType type = this.getType(blockState, world.method_8320(clickedPos.method_10093(facing.method_10170())), world.method_8320(clickedPos.method_10093(facing.method_10160())));
        return (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)type));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (!world.field_9236) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            LineConnectingType type = this.getType(state, world.method_8320(pos.method_10093(facing.method_10170())), world.method_8320(pos.method_10093(facing.method_10160())));
            if (state.method_11654(TYPE) != type) {
                world.method_8652(pos, (class_2680)state.method_11657(TYPE, (Comparable)((Object)type)), 3);
            }
        }
    }

    public LineConnectingType getType(class_2680 state, class_2680 oneSide, class_2680 otherSide) {
        boolean otherSideSame;
        boolean oneSideSame = oneSide.method_26204() == state.method_26204() && oneSide.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING);
        boolean bl = otherSideSame = otherSide.method_26204() == state.method_26204() && otherSide.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING);
        if (oneSideSame && otherSideSame) {
            return LineConnectingType.MIDDLE;
        }
        if (oneSideSame) {
            return LineConnectingType.LEFT;
        }
        if (otherSideSame) {
            return LineConnectingType.RIGHT;
        }
        return LineConnectingType.NONE;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity blockEntity1 = (StorageBlockEntity)blockEntity;
            player.method_17355((class_3908)blockEntity1);
        }
        return class_1269.field_21466;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((class_1263)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new StorageBlockEntity(pos, state, this.openSound, this.closeSound);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (itemStack.method_7938() && (blockEntity = world.method_8321(pos)) instanceof StorageBlockEntity) {
            StorageBlockEntity blockEntity1 = (StorageBlockEntity)blockEntity;
            blockEntity1.method_17488(itemStack.method_7964());
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, TYPE});
    }

    public void playSound(class_1937 world, class_2338 pos, boolean open) {
        world.method_8396(null, pos, open ? this.openSound : this.closeSound, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void method_9568(class_1799 itemStack, class_1922 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.brewery.expandable").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
    }
}

