/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.render;

import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import net.satisfy.brewery.client.model.RopeKnotEntityModel;
import net.satisfy.brewery.client.render.RopeRender;
import net.satisfy.brewery.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.registry.ModelRegistry;
import net.satisfy.brewery.util.BreweryIdentifier;
import net.satisfy.brewery.util.BreweryMath;
import net.satisfy.brewery.util.rope.RopeConnection;
import org.jetbrains.annotations.NotNull;

public class RopeKnotRenderer
extends class_897<RopeKnotEntity> {
    private static final class_2960 KNOT_TEXTURE = new BreweryIdentifier("textures/rope/rope_knot.png");
    private final RopeRender hopRopeRenderer = new RopeRender();
    private final RopeKnotEntityModel<RopeKnotEntity> model;

    public RopeKnotRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new RopeKnotEntityModel(context.method_32167(ModelRegistry.ROPE_KNOT));
    }

    public boolean shouldRender(RopeKnotEntity entity, class_4604 frustum, double d, double e, double f) {
        if (entity.field_5985) {
            return true;
        }
        for (RopeConnection connection : entity.getConnections()) {
            if (connection.from() != entity) continue;
            if (connection.to() instanceof class_1657) {
                return true;
            }
            if (!connection.to().method_5727(d, e, f)) continue;
            return true;
        }
        return super.method_3933((class_1297)entity, frustum, d, e, f);
    }

    public void render(RopeKnotEntity entity, float f, float tickDelta, class_4587 poseStack, class_4597 multiBufferSource, int light) {
        if (entity.shouldRenderKnot()) {
            poseStack.method_22903();
            poseStack.method_22905(-1.0f, -1.0f, 1.0f);
            this.model.method_2819(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            class_4588 vertexConsumer = multiBufferSource.getBuffer(this.model.method_23500(KNOT_TEXTURE));
            this.model.method_2828(poseStack, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
        }
        Set<RopeConnection> connections = entity.getConnections();
        for (RopeConnection connection : connections) {
            if (connection.from() != entity || connection.dead()) continue;
            this.renderRopeConnection(connection, tickDelta, poseStack, multiBufferSource);
        }
        super.method_3936((class_1297)entity, f, tickDelta, poseStack, multiBufferSource, light);
    }

    private void renderRopeConnection(RopeConnection connection, float tickDelta, class_4587 poseStack, class_4597 vertexConsumerProvider) {
        RopeKnotEntity fromKnot = connection.from();
        class_1297 toEntity = connection.to();
        class_243 ropeVec = connection.getConnectionVec(tickDelta);
        class_1921 entityCutout = class_1921.method_23578((class_2960)new BreweryIdentifier("textures/rope/rope.png"));
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(entityCutout);
        class_2338 blockPosOfStart = BreweryMath.ofFloored(fromKnot.method_5836(tickDelta));
        class_2338 blockPosOfEnd = BreweryMath.ofFloored(toEntity.method_5836(tickDelta));
        int blockLightLevelOfStart = fromKnot.method_37908().method_8314(class_1944.field_9282, blockPosOfStart);
        int blockLightLevelOfEnd = toEntity.method_37908().method_8314(class_1944.field_9282, blockPosOfEnd);
        int skylightLevelOfStart = fromKnot.method_37908().method_8314(class_1944.field_9284, blockPosOfStart);
        int skylightLevelOfEnd = toEntity.method_37908().method_8314(class_1944.field_9284, blockPosOfEnd);
        poseStack.method_22903();
        class_243 leashOffset = fromKnot.method_29919();
        poseStack.method_22904(leashOffset.field_1352, leashOffset.field_1351, leashOffset.field_1350);
        this.hopRopeRenderer.render(vertexConsumer, poseStack, ropeVec, fromKnot.method_5628(), blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        poseStack.method_22909();
    }

    @NotNull
    public class_2960 getTextureLocation(RopeKnotEntity entity) {
        return new class_2960("");
    }
}

