/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.util.rope;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.block.crops.HopsCropHeadBlock;
import net.satisfy.brewery.entity.rope.HangingRopeEntity;
import net.satisfy.brewery.entity.rope.RopeCollisionEntity;
import net.satisfy.brewery.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.util.BreweryMath;
import net.satisfy.brewery.util.rope.RopeHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RopeConnection {
    public static final double VISIBLE_RANGE = 2048.0;
    private final RopeKnotEntity from;
    private final class_1297 to;
    private boolean alive = true;
    public boolean removeSilently = false;
    private final List<Integer> collisions = new ArrayList<Integer>();
    private final List<Integer> hangingRopes = new ArrayList<Integer>();
    private int activeRopes;

    public RopeKnotEntity from() {
        return this.from;
    }

    public class_1297 to() {
        return this.to;
    }

    public boolean dead() {
        return !this.alive;
    }

    public int activeHangingRopes() {
        return this.activeRopes;
    }

    public class_1937 getLevel() {
        return this.from.method_37908();
    }

    public double getSquaredDistance() {
        return this.from.method_5858(this.to);
    }

    public class_243 getConnectionVec(float tickDelta) {
        class_243 fromPos = this.from.method_19538().method_1019(this.from.method_29919());
        class_243 toPos = this.to.method_30951(tickDelta);
        return toPos.method_1020(fromPos);
    }

    public void setActive(boolean active, int id) {
        int index = this.hangingRopes.indexOf(id);
        if (index >= 0) {
            this.activeRopes = active ? (this.activeRopes &= ~(1 << index)) : (this.activeRopes |= 1 << index);
        } else {
            Brewery.LOGGER.debug("Cant change hanging entity, storage doesnt contain reference to Entity {} .", (Object)id);
        }
    }

    private RopeConnection(RopeKnotEntity from, class_1297 to, int activeRopes) {
        this.from = from;
        this.to = to;
        this.activeRopes = activeRopes;
    }

    @Nullable
    public static RopeConnection create(@NotNull RopeKnotEntity fromKnot, @NotNull class_1297 to) {
        return RopeConnection.create(fromKnot, to, 0);
    }

    @Nullable
    public static RopeConnection create(@NotNull RopeKnotEntity fromKnot, @NotNull class_1297 to, int activeRopes) {
        class_1937 class_19372;
        RopeConnection connection = new RopeConnection(fromKnot, to, activeRopes);
        if (fromKnot.sameConnectionExist(connection)) {
            return null;
        }
        fromKnot.addConnection(connection);
        if (to instanceof RopeKnotEntity) {
            RopeKnotEntity toKnot = (RopeKnotEntity)to;
            toKnot.addConnection(connection);
            connection.createCollision();
            connection.createHangingRopes();
        }
        if ((class_19372 = fromKnot.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            connection.sendAttachRopePacket(serverLevel);
        }
        return connection;
    }

    private void sendAttachRopePacket(class_3218 serverLevel) {
        Set<class_3222> trackingPlayers = RopeConnection.getTrackingPlayers(serverLevel, this);
        for (class_3222 player : trackingPlayers) {
            class_2540 buf = BreweryNetworking.createPacketBuf();
            buf.writeInt(this.from.method_5628());
            buf.writeInt(this.to.method_5628());
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)BreweryNetworking.ATTACH_ROPE_S2C_ID, (class_2540)buf);
        }
    }

    private void createCollision() {
        if (!this.collisions.isEmpty()) {
            return;
        }
        if (this.from.method_37908().method_8608()) {
            return;
        }
        float distance = this.from.method_5739(this.to);
        float step = ((class_1299)EntityRegistry.ROPE_COLLISION.get()).method_17685() * 2.5f / distance;
        float centerHoldout = ((class_1299)EntityRegistry.ROPE_COLLISION.get()).method_17685() / distance;
        class_243 startPos = this.from.method_19538().method_1019(this.from.method_29919());
        class_243 endPos = this.to.method_19538().method_1019(this.to.method_45321(this.to.method_5751()));
        for (double v = (double)step; v < (double)(0.5f - centerHoldout); v += (double)step) {
            class_1297 toCollider;
            class_1297 fromCollider = this.spawnCollision(startPos, endPos, v);
            if (fromCollider != null) {
                this.collisions.add(fromCollider.method_5628());
            }
            if ((toCollider = this.spawnCollision(endPos, startPos, v)) == null) continue;
            this.collisions.add(toCollider.method_5628());
        }
        class_1297 centerCollider = this.spawnCollision(startPos, endPos, 0.5);
        if (centerCollider != null) {
            this.collisions.add(centerCollider.method_5628());
        }
    }

    @Nullable
    private class_1297 spawnCollision(class_243 startPos, class_243 endPos, double v) {
        assert (this.from.method_37908() instanceof class_3218);
        class_243 ropeVec = endPos.method_1020(startPos);
        class_243 currentVec = ropeVec.method_1021(v);
        class_243 currentPos = startPos.method_1019(currentVec);
        double y = RopeHelper.getYHanging(currentVec.method_1033(), endPos.method_1020(startPos));
        RopeCollisionEntity collisionEntity = RopeCollisionEntity.create(this.from.method_37908(), currentPos.method_10216(), currentPos.method_10214() + (y -= (double)(((class_1299)EntityRegistry.ROPE_COLLISION.get()).method_17686() / 2.0f)), currentPos.method_10215(), this);
        if (this.from.method_37908().method_8649((class_1297)collisionEntity)) {
            return collisionEntity;
        }
        Brewery.LOGGER.warn("FAILED to summon collision entity for a rope.");
        return null;
    }

    private void createHangingRopes() {
        if (this.from.method_37908().method_8608()) {
            return;
        }
        class_243 startPos = this.from.method_19538().method_1019(this.from.method_29919());
        class_243 endPos = this.to.method_19538().method_1019(this.to.method_45321(this.to.method_5751()));
        class_243 ropeVec = endPos.method_1020(startPos);
        int i = 0;
        Set<class_2338> blockPositions = BreweryMath.lineIntersection(this);
        for (class_2338 blockPos : blockPositions) {
            class_2338 currentPos = blockPos.method_10059((class_2382)this.from.method_6896());
            class_243 currentVec = new class_243((double)currentPos.method_10263(), (double)currentPos.method_10264(), (double)currentPos.method_10260());
            double y = RopeHelper.getYHanging(currentVec.method_1033(), ropeVec);
            boolean active = (this.activeRopes & 1 << i) == 0;
            HangingRopeEntity hangingRopeEntity = HangingRopeEntity.create(this.from.method_37908(), blockPos.method_10263(), startPos.method_1019((class_243)currentVec).field_1351 + (y -= (double)((class_1299)EntityRegistry.HANGING_ROPE.get()).method_17686()), blockPos.method_10260(), this, active);
            hangingRopeEntity.method_32317(0);
            boolean added = this.from.method_37908().method_8649((class_1297)hangingRopeEntity);
            if (added) {
                this.hangingRopes.add(hangingRopeEntity.method_5628());
            } else {
                Brewery.LOGGER.warn("FAILED to summon hanging rope entity.");
            }
            ++i;
        }
    }

    public boolean needsBeDestroyed() {
        return this.from.method_31481() || this.to.method_31481();
    }

    public void destroy(boolean mayDrop) {
        class_1657 player;
        if (!this.alive) {
            return;
        }
        this.alive = false;
        class_1937 level = this.from.method_37908();
        if (level.method_8608()) {
            return;
        }
        boolean drop = mayDrop;
        class_1297 class_12972 = this.to;
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_7337()) {
            drop = false;
        }
        if (!level.method_8450().method_8355(class_1928.field_19392)) {
            drop = false;
        }
        if (drop) {
            class_1799 stack = new class_1799((class_1935)ObjectRegistry.ROPE.get());
            class_1297 class_12973 = this.to;
            if (class_12973 instanceof class_1657) {
                class_1657 player2 = (class_1657)class_12973;
                player2.method_7270(stack);
            } else {
                class_243 middle = BreweryMath.middleOf(this.from.method_19538(), this.to.method_19538());
                class_1542 itemEntity = new class_1542(level, middle.field_1352, middle.field_1351, middle.field_1350, stack);
                itemEntity.method_6988();
                level.method_8649((class_1297)itemEntity);
            }
        }
        this.destroyCollision();
        this.destroyHangingRopes();
        class_12972 = this.from.method_37908();
        if (class_12972 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_12972;
            if (!this.from.method_31481() && !this.to.method_31481()) {
                this.sendDetachChainPacket(serverLevel);
            }
        }
    }

    private void sendDetachChainPacket(class_3218 serverLevel) {
        Set<class_3222> trackingPlayers = RopeConnection.getTrackingPlayers(serverLevel, this);
        for (class_3222 player : trackingPlayers) {
            class_2540 buf = BreweryNetworking.createPacketBuf();
            buf.writeInt(this.from.method_5628());
            buf.writeInt(this.to.method_5628());
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)BreweryNetworking.DETACH_ROPE_S2C_ID, (class_2540)buf);
        }
    }

    private void destroyCollision() {
        for (Integer entityId : this.collisions) {
            class_1297 e = this.from.method_37908().method_8469(entityId.intValue());
            if (e instanceof RopeCollisionEntity) {
                e.method_31472();
                continue;
            }
            Brewery.LOGGER.warn("Collision storage contained reference to {} (#{}) which is not a collision entity.", (Object)e, (Object)entityId);
        }
        this.collisions.clear();
    }

    private void destroyHangingRopes() {
        Integer entityId2;
        for (Integer entityId2 : this.hangingRopes) {
            class_1297 entity = this.from.method_37908().method_8469(entityId2.intValue());
            if (entity instanceof HangingRopeEntity) {
                entity.method_31472();
                continue;
            }
            Brewery.LOGGER.warn("Hanging storage contained reference to {} (#{}) which is not a hanging rope entity.", (Object)entity, (Object)entityId2);
        }
        entityId2 = this.from.method_37908();
        if (entityId2 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)entityId2;
            Set<class_2338> blockPositions = BreweryMath.lineIntersection(this);
            for (class_2338 blockPos : blockPositions) {
                HangingRopeEntity.notifyBlock(blockPos, serverLevel, HopsCropHeadBlock.getHeadBlock());
            }
        }
        this.collisions.clear();
    }

    private static Set<class_3222> getTrackingPlayers(class_3218 serverLevel, RopeConnection connection) {
        HashSet<class_3222> trackingPlayers = new HashSet<class_3222>();
        RopeKnotEntity from = connection.from();
        class_1297 to = connection.to();
        trackingPlayers.addAll(serverLevel.method_18456().stream().filter(player -> player.method_5649(from.method_19538().method_10216(), from.method_19538().method_10214(), from.method_19538().method_10215()) <= 2048.0).toList());
        trackingPlayers.addAll(serverLevel.method_18456().stream().filter(player -> player.method_5649(to.method_19538().method_10216(), to.method_19538().method_10214(), to.method_19538().method_10215()) <= 2048.0).toList());
        return trackingPlayers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RopeConnection)) {
            return false;
        }
        RopeConnection that = (RopeConnection)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) || Objects.equals(this.from, that.to) && Objects.equals(this.to, that.from);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

