/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import satisfyu.vinery.Vinery;
import satisfyu.vinery.VineryIdentifier;
import satisfyu.vinery.effect.ArmorEffect;
import satisfyu.vinery.effect.ClimbingEffect;
import satisfyu.vinery.effect.CreeperEffect;
import satisfyu.vinery.effect.ExperienceEffect;
import satisfyu.vinery.effect.FrostyArmorEffect;
import satisfyu.vinery.effect.ImprovedEffect;
import satisfyu.vinery.effect.ImprovedHealthEffect;
import satisfyu.vinery.effect.JellieEffect;
import satisfyu.vinery.effect.LavaWalkerEffect;
import satisfyu.vinery.effect.LuckEffect;
import satisfyu.vinery.effect.MagnetEffect;
import satisfyu.vinery.effect.PartyEffect;
import satisfyu.vinery.effect.ResistanceEffect;
import satisfyu.vinery.effect.StaggerEffect;
import satisfyu.vinery.effect.TeleportEffect;
import satisfyu.vinery.effect.TrippyEffect;
import satisfyu.vinery.effect.WaterWalkerEffect;

public class MobEffectRegistry {
    private static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"vinery", (class_5321)class_7924.field_41208);
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<class_1291> TRIPPY;
    public static final RegistrySupplier<class_1291> JELLIE;
    public static final RegistrySupplier<class_1291> MAGNET;
    public static final RegistrySupplier<class_1291> TELEPORT;
    public static final RegistrySupplier<class_1291> IMPROVED_JUMP_BOOST;
    public static final RegistrySupplier<class_1291> WATER_WALKER;
    public static final RegistrySupplier<class_1291> CREEPER_EFFECT;
    public static final RegistrySupplier<class_1291> EXPERIENCE_EFFECT;
    public static final RegistrySupplier<class_1291> LAVA_WALKER;
    public static final RegistrySupplier<class_1291> STAGGER_EFFECT;
    public static final RegistrySupplier<class_1291> FROSTY_ARMOR_EFFECT;
    public static final RegistrySupplier<class_1291> PARTY_EFFECT;
    public static final RegistrySupplier<class_1291> CLIMBING_EFFECT;
    public static final RegistrySupplier<class_1291> LUCK_EFFECT;
    public static final RegistrySupplier<class_1291> HEALTH_EFFECT;
    public static final RegistrySupplier<class_1291> RESISTANCE_EFFECT;
    public static final RegistrySupplier<class_1291> ARMOR_EFFECT;

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new VineryIdentifier(name), effect);
    }

    public static void init() {
        Vinery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        EXPERIENCE_EFFECT = MobEffectRegistry.registerEffect("experience_effect", ExperienceEffect::new);
        TRIPPY = MobEffectRegistry.registerEffect("trippy", TrippyEffect::new);
        LAVA_WALKER = MobEffectRegistry.registerEffect("lava_walker", LavaWalkerEffect::new);
        JELLIE = MobEffectRegistry.registerEffect("jellie", JellieEffect::new);
        MAGNET = MobEffectRegistry.registerEffect("magnet", MagnetEffect::new);
        TELEPORT = MobEffectRegistry.registerEffect("teleport", TeleportEffect::new);
        CREEPER_EFFECT = MobEffectRegistry.registerEffect("creeper_effect", CreeperEffect::new);
        IMPROVED_JUMP_BOOST = MobEffectRegistry.registerEffect("double_jump", () -> new ImprovedEffect(class_4081.field_18271, 9500817));
        WATER_WALKER = MobEffectRegistry.registerEffect("water_walker", WaterWalkerEffect::new);
        STAGGER_EFFECT = MobEffectRegistry.registerEffect("staggering", StaggerEffect::new);
        FROSTY_ARMOR_EFFECT = MobEffectRegistry.registerEffect("frosty_armor", FrostyArmorEffect::new);
        PARTY_EFFECT = MobEffectRegistry.registerEffect("party_effect", PartyEffect::new);
        CLIMBING_EFFECT = MobEffectRegistry.registerEffect("climbing_effect", ClimbingEffect::new);
        LUCK_EFFECT = MobEffectRegistry.registerEffect("luck_effect", LuckEffect::new);
        HEALTH_EFFECT = MobEffectRegistry.registerEffect("health_effect", ImprovedHealthEffect::new);
        RESISTANCE_EFFECT = MobEffectRegistry.registerEffect("resistance_effect", ResistanceEffect::new);
        ARMOR_EFFECT = MobEffectRegistry.registerEffect("armor_effect", ArmorEffect::new);
    }
}

