/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.block.entities;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3708;
import net.minecraft.class_52;
import net.minecraft.class_5251;
import net.minecraft.class_5561;
import net.minecraft.class_8567;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.client.ClientHooks;
import net.zestyblaze.lootr.config.ConfigManager;
import net.zestyblaze.lootr.data.SpecialChestInventory;
import net.zestyblaze.lootr.init.ModBlockEntities;
import org.jetbrains.annotations.Nullable;

public class LootrBarrelBlockEntity
extends class_2621
implements ILootBlockEntity,
RenderAttachmentBlockEntity {
    public Set<UUID> openers = new HashSet<UUID>();
    protected class_2960 savedLootTable = null;
    protected long seed = -1L;
    protected UUID tileId = null;
    protected boolean opened = false;
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 leve, class_2338 pos, class_2680 state) {
            LootrBarrelBlockEntity.this.playSound(state, class_3417.field_17604);
            LootrBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void method_31683(class_1937 level, class_2338 pos, class_2680 state) {
            LootrBarrelBlockEntity.this.playSound(state, class_3417.field_17603);
            LootrBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void method_31682(class_1937 level, class_2338 pos, class_2680 state, int p_155069_, int p_155070_) {
        }

        protected boolean method_31679(class_1657 player) {
            class_1263 class_12632;
            if (player.field_7512 instanceof class_1707 && (class_12632 = ((class_1707)player.field_7512).method_7629()) instanceof SpecialChestInventory) {
                SpecialChestInventory data = (SpecialChestInventory)class_12632;
                if (data.getTileId() == null) {
                    return data.getBlockEntity(LootrBarrelBlockEntity.this.method_10997()) == LootrBarrelBlockEntity.this;
                }
                return data.getTileId().equals(LootrBarrelBlockEntity.this.getTileId());
            }
            return false;
        }
    };
    private class_2371<class_1799> items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private boolean savingToItem = false;

    public LootrBarrelBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(ModBlockEntities.SPECIAL_LOOT_BARREL, pWorldPosition, pBlockState);
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public void method_11285(class_2960 lootTableIn, long seedIn) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
        super.method_11285(lootTableIn, seedIn);
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> pItems) {
    }

    public void method_11289(@Nullable class_1657 player) {
    }

    @Override
    public void unpackLootTable(class_1657 player, class_1263 inventory, @Nullable class_2960 overrideTable, long seed) {
        if (this.field_11863 != null && this.savedLootTable != null && this.field_11863.method_8503() != null) {
            class_52 loottable = this.field_11863.method_8503().method_3857().getLootTable(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == class_52.field_948) {
                LootrAPI.LOG.error("Unable to fill loot barrel in " + this.field_11863.method_27983() + " at " + this.field_11867 + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (ConfigManager.get().debug.report_invalid_tables) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.invalid_table", (Object[])new Object[]{(overrideTable != null ? overrideTable : this.savedLootTable).toString()}).method_10862(ConfigManager.get().notifications.disable_message_styles ? class_2583.field_24360 : class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1079)).method_10982(Boolean.valueOf(true))), false);
                }
            }
            if (player instanceof class_3222) {
                class_174.field_24479.method_27993((class_3222)player, overrideTable != null ? overrideTable : this.field_12037);
            }
            class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.field_11863).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867));
            if (player != null) {
                builder.method_51871(player.method_7292()).method_51874(class_181.field_1226, (Object)player);
            }
            loottable.method_329(inventory, builder.method_51875(class_173.field_1179), LootrAPI.getLootSeed(seed == Long.MIN_VALUE ? this.seed : seed));
        }
    }

    @Override
    public class_2960 getTable() {
        return this.savedLootTable;
    }

    @Override
    public class_2338 getPosition() {
        return this.method_11016();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void method_11014(class_2487 compound) {
        if (compound.method_10573("specialLootChest_table", 8)) {
            this.savedLootTable = new class_2960(compound.method_10558("specialLootChest_table"));
        }
        if (compound.method_10573("specialLootChest_seed", 4)) {
            this.seed = compound.method_10537("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.method_10573("LootTable", 8)) {
            this.savedLootTable = new class_2960(compound.method_10558("LootTable"));
            if (compound.method_10573("LootTableSeed", 4)) {
                this.seed = compound.method_10537("LootTableSeed");
            }
            this.method_11285(this.savedLootTable, this.seed);
        }
        if (compound.method_25928("tileId")) {
            this.tileId = compound.method_25926("tileId");
        }
        if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.method_10545("LootrOpeners")) {
            HashSet<UUID> newOpeners = new HashSet<UUID>();
            class_2499 openers = compound.method_10554("LootrOpeners", 11);
            for (class_2520 item : openers) {
                newOpeners.add(class_2512.method_25930((class_2520)item));
            }
            if (!Sets.symmetricDifference(this.openers, newOpeners).isEmpty()) {
                this.openers = newOpeners;
                if (this.method_10997() != null && this.method_10997().method_8608()) {
                    ClientHooks.clearCache(this.method_11016());
                }
            }
        }
        super.method_11014(compound);
    }

    public void method_38240(class_1799 itemstack) {
        this.savingToItem = true;
        super.method_38240(itemstack);
        this.savingToItem = false;
    }

    protected void method_11007(class_2487 compound) {
        super.method_11007(compound);
        if (this.savedLootTable != null) {
            compound.method_10582("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.method_10544("LootTableSeed", this.seed);
        }
        if (!LootrAPI.shouldDiscard() && !this.savingToItem) {
            compound.method_25927("tileId", this.getTileId());
            class_2499 list = new class_2499();
            for (UUID opener : this.openers) {
                list.add((Object)class_2512.method_25929((UUID)opener));
            }
            compound.method_10566("LootrOpeners", (class_2520)list);
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.barrel");
    }

    protected class_1703 method_5465(int pContainerId, class_1661 pInventory) {
        return null;
    }

    public int method_5439() {
        return 27;
    }

    public void method_5435(class_1657 pPlayer) {
        if (!this.field_11865 && !pPlayer.method_7325()) {
            this.openersCounter.method_31684(pPlayer, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 pPlayer) {
        if (!this.field_11865 && !pPlayer.method_7325()) {
            this.openersCounter.method_31685(pPlayer, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void recheckOpen() {
        if (!this.field_11865) {
            this.openersCounter.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    protected void updateBlockState(class_2680 pState, boolean pOpen) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)pState.method_11657((class_2769)class_3708.field_18006, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    protected void playSound(class_2680 pState, class_3414 pSound) {
        class_2382 vec3i = ((class_2350)pState.method_11654((class_2769)class_3708.field_16320)).method_10163();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, pSound, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    @Override
    public void updatePacketViaState() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            class_2680 state = this.field_11863.method_8320(this.method_11016());
            this.field_11863.method_8413(this.method_11016(), state, state, 8);
        }
    }

    @Override
    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public class_2487 method_16887() {
        class_2487 result = super.method_16887();
        this.method_11007(result);
        return result;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_39026((class_2586)this, class_2586::method_16887);
    }

    @Nullable
    public Object getRenderAttachmentData() {
        class_1657 player = ClientHooks.getPlayer();
        if (player == null) {
            return null;
        }
        return this.getOpeners().contains(player.method_5667());
    }
}

