/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_26;
import net.minecraft.class_2621;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.zestyblaze.lootr.api.LootFiller;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.data.AdvancementData;
import net.zestyblaze.lootr.data.ChestData;
import net.zestyblaze.lootr.data.SpecialChestInventory;
import net.zestyblaze.lootr.data.TickingData;
import net.zestyblaze.lootr.entity.LootrChestMinecartEntity;
import net.zestyblaze.lootr.util.ServerAccessImpl;
import org.jetbrains.annotations.Nullable;

public class DataStorage {
    public static final String ID_OLD = "Lootr-AdvancementData";
    public static final String SCORED_OLD = "Lootr-ScoreData";
    public static final String DECAY_OLD = "Lootr-DecayData";
    public static final String REFRESH_OLD = "Lootr-RefreshData";
    public static final String ID = "lootr/Lootr-AdvancementData";
    public static final String SCORED = "lootr/Lootr-ScoreData";
    public static final String DECAY = "lootr/Lootr-DecayData";
    public static final String REFRESH = "lootr/Lootr-RefreshData";

    @Nullable
    public static class_26 getDataStorage() {
        MinecraftServer server = ServerAccessImpl.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        class_3218 overworld = server.method_30002();
        if (overworld == null) {
            LootrAPI.LOG.error("The Overworld is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        return overworld.method_17983();
    }

    public static boolean isAwarded(UUID player, UUID tileId) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine if advancemend has been awarded.");
            return false;
        }
        AdvancementData data = (AdvancementData)manager.method_17924(AdvancementData::load, AdvancementData::new, ID);
        return data.contains(player, tileId);
    }

    public static void award(UUID player, UUID tileId) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot award advancement.");
            return;
        }
        AdvancementData data = (AdvancementData)manager.method_17924(AdvancementData::load, AdvancementData::new, ID);
        data.add(player, tileId);
        data.method_80();
    }

    public static boolean isScored(UUID player, UUID tileId) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine if chest has been scored.");
            return false;
        }
        AdvancementData data = (AdvancementData)manager.method_17924(AdvancementData::load, AdvancementData::new, SCORED);
        return data.contains(player, tileId);
    }

    public static void score(UUID player, UUID tileId) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot score chest.");
            return;
        }
        AdvancementData data = (AdvancementData)manager.method_17924(AdvancementData::load, AdvancementData::new, SCORED);
        data.add(player, tileId);
        data.method_80();
    }

    public static int getDecayValue(UUID id) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch decay value.");
            return -1;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, DECAY);
        return data.getValue(id);
    }

    public static boolean isDecayed(UUID id) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine if chest has decayed.");
            return false;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, DECAY);
        return data.isComplete(id);
    }

    public static void setDecaying(UUID id, int decay) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set decay value.");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, DECAY);
        data.setValue(id, decay);
        data.method_80();
    }

    public static void removeDecayed(UUID id) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot remove decay value.");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, DECAY);
        if (data.remove(id) != -1) {
            data.method_80();
        }
    }

    public static void doDecay() {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot decay chests.");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, DECAY);
        if (data.tick()) {
            data.method_80();
        }
    }

    public static int getRefreshValue(UUID id) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine refresh value.");
            return -1;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, REFRESH);
        return data.getValue(id);
    }

    public static boolean isRefreshed(UUID id) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine if chest has been refreshed.");
            return false;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, REFRESH);
        return data.isComplete(id);
    }

    public static void setRefreshing(UUID id, int decay) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set refresh value.");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, REFRESH);
        data.setValue(id, decay);
        data.method_80();
    }

    public static void removeRefreshed(UUID id) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot remove refresh value.");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, REFRESH);
        if (data.remove(id) != -1) {
            data.method_80();
        }
    }

    public static void doRefresh() {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot refresh chests.");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData::load, TickingData::new, REFRESH);
        if (data.tick()) {
            data.method_80();
        }
    }

    @Deprecated
    @Nullable
    public static ChestData getInstanceUuid(class_3218 world, class_2338 pos, UUID id) {
        return DataStorage.getContainerData(world, pos, id);
    }

    @Nullable
    public static ChestData getContainerData(class_3218 world, class_2338 pos, UUID id) {
        int size;
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch chest data for " + world.method_27983() + " at " + pos.toString() + " with ID " + id.toString() + " and cannot continue.");
            return null;
        }
        class_2586 be = world.method_8321(pos);
        if (be == null) {
            LootrAPI.LOG.error("The block entity with id '" + id.toString() + "' in '" + world.method_27983() + "' at '" + pos + "' is null.");
        }
        if (be instanceof class_1263) {
            class_1263 bce = (class_1263)be;
            size = bce.method_5439();
        } else {
            LootrAPI.LOG.error("We have no heuristic to determine the size of '" + id.toString() + "' in '" + world.method_27983() + "' at '" + pos + "'. Defaulting to 27.");
            size = 27;
        }
        return ChestData.unwrap((ChestData)manager.method_17924(ChestData.loadWrapper(id, (class_5321<class_1937>)world.method_27983(), pos), ChestData.id((class_5321<class_1937>)world.method_27983(), pos, id), ChestData.ID(id)), id, (class_5321<class_1937>)world.method_27983(), pos, size);
    }

    @Deprecated
    @Nullable
    public static ChestData getInstance(class_3218 world, class_2338 pos, UUID id) {
        return DataStorage.getEntityData(world, pos, id);
    }

    @Nullable
    public static ChestData getEntityData(class_3218 world, class_2338 pos, UUID id) {
        int size;
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch chest data for " + world.method_27983() + " at " + pos.toString() + " with ID " + id.toString() + " and cannot continue.");
            return null;
        }
        class_1297 entity = world.method_14190(id);
        if (entity == null) {
            LootrAPI.LOG.error("The entity with id '" + id + "' in '" + world.method_27983() + "' at '" + pos + "' is null.");
        }
        if (entity instanceof class_1263) {
            class_1263 container = (class_1263)entity;
            size = container.method_5439();
        } else {
            LootrAPI.LOG.error("We have no heuristic to determine the size of entity '" + id + "' in '" + world.method_27983() + "' at '" + pos + "'. Defaulting to 27.");
            size = 27;
        }
        return ChestData.unwrap((ChestData)manager.method_17924(ChestData.loadWrapper(id, (class_5321<class_1937>)world.method_27983(), pos), ChestData.entity((class_5321<class_1937>)world.method_27983(), pos, id), ChestData.ID(id)), id, (class_5321<class_1937>)world.method_27983(), pos, size);
    }

    @Deprecated
    @Nullable
    public static ChestData getInstanceInventory(class_3218 world, class_2338 pos, UUID id, class_2371<class_1799> base) {
        return DataStorage.getReferenceContainerData(world, pos, id, base);
    }

    @Nullable
    public static ChestData getReferenceContainerData(class_3218 world, class_2338 pos, UUID id, class_2371<class_1799> base) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch chest data for " + world.method_27983() + " at " + pos.toString() + " with ID " + id.toString() + " and cannot continue.");
            return null;
        }
        return ChestData.unwrap((ChestData)manager.method_17924(ChestData.loadWrapper(id, (class_5321<class_1937>)world.method_27983(), pos), ChestData.ref_id((class_5321<class_1937>)world.method_27983(), pos, id, base), ChestData.ID(id)), id, (class_5321<class_1937>)world.method_27983(), pos, base.size());
    }

    @Nullable
    public static SpecialChestInventory getInventory(class_1937 level, UUID uuid, class_2338 pos, class_3222 player, IntSupplier sizeSupplier, Supplier<class_2561> displaySupplier, LootFiller filler, Supplier<class_2960> tableSupplier, LongSupplier seedSupplier) {
        if (level.method_8608() || !(level instanceof class_3218)) {
            return null;
        }
        ChestData data = DataStorage.getContainerData((class_3218)level, pos, uuid);
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, sizeSupplier, displaySupplier, tableSupplier, seedSupplier);
        }
        return inventory;
    }

    @Nullable
    public static SpecialChestInventory getInventory(class_1937 level, UUID uuid, class_2338 pos, class_3222 player, class_2624 blockEntity, LootFiller filler, Supplier<class_2960> tableSupplier, LongSupplier seedSupplier) {
        if (level.method_8608() || !(level instanceof class_3218)) {
            return null;
        }
        ChestData data = DataStorage.getContainerData((class_3218)level, pos, uuid);
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, blockEntity, tableSupplier, seedSupplier);
        }
        return inventory;
    }

    @Nullable
    public static SpecialChestInventory getInventory(class_1937 world, UUID uuid, class_2338 pos, class_3222 player, class_2621 tile, LootFiller filler) {
        if (world.field_9236 || !(world instanceof class_3218)) {
            return null;
        }
        ChestData data = DataStorage.getContainerData((class_3218)world, pos, uuid);
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, tile);
        }
        return inventory;
    }

    @Nullable
    public static SpecialChestInventory getInventory(class_1937 world, UUID uuid, class_2371<class_1799> base, class_3222 player, class_2338 pos, class_2621 tile) {
        if (world.field_9236 || !(world instanceof class_3218)) {
            return null;
        }
        ChestData data = DataStorage.getReferenceContainerData((class_3218)world, pos, uuid, base);
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, data.customInventory(), tile);
        }
        return inventory;
    }

    public static boolean clearInventories(UUID uuid) {
        class_26 data = DataStorage.getDataStorage();
        if (data == null) {
            return false;
        }
        MinecraftServer server = ServerAccessImpl.getServer();
        if (server == null) {
            return false;
        }
        Path dataPath = server.method_27050(new class_5218("data")).resolve("lootr");
        ArrayList ids = new ArrayList();
        try (Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);){
            paths.forEach(o -> {
                if (Files.isRegularFile(o, new LinkOption[0])) {
                    String fileName = o.getFileName().toString();
                    if (fileName.startsWith("Lootr-")) {
                        return;
                    }
                    ids.add("lootr/" + fileName.charAt(0) + "/" + fileName.substring(0, 2) + "/" + fileName.replace(".dat", ""));
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        int cleared = 0;
        for (String id : ids) {
            ChestData chestData = (ChestData)data.method_20786(ChestData::load, id);
            if (chestData == null || !chestData.clearInventory(uuid)) continue;
            ++cleared;
            chestData.method_80();
        }
        LootrAPI.LOG.info("Cleared " + cleared + " inventories for play UUID " + uuid.toString());
        return cleared != 0;
    }

    @Nullable
    public static SpecialChestInventory getInventory(class_1937 world, LootrChestMinecartEntity cart, class_3222 player, LootFiller filler) {
        if (world.field_9236 || !(world instanceof class_3218)) {
            return null;
        }
        ChestData data = DataStorage.getEntityData((class_3218)world, cart.method_24515(), cart.method_5667());
        if (data == null) {
            return null;
        }
        SpecialChestInventory inventory = data.getInventory(player);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, null);
        }
        return inventory;
    }

    public static void refreshInventory(class_1937 level, class_2338 pos, UUID uuid, class_3222 player) {
        if (level.method_8608() || !(level instanceof class_3218)) {
            return;
        }
        ChestData data = DataStorage.getContainerData((class_3218)level, pos, uuid);
        if (data == null) {
            return;
        }
        data.clear();
        data.method_80();
    }

    public static void refreshInventory(class_1937 world, class_2338 pos, UUID uuid, class_2371<class_1799> base, class_3222 player) {
        if (world.method_8608() || !(world instanceof class_3218)) {
            return;
        }
        ChestData data = DataStorage.getReferenceContainerData((class_3218)world, pos, uuid, base);
        if (data == null) {
            return;
        }
        data.clear();
        data.method_80();
    }

    public static void refreshInventory(class_1937 world, LootrChestMinecartEntity cart, class_3222 player) {
        if (world.method_8608() || !(world instanceof class_3218)) {
            return;
        }
        ChestData data = DataStorage.getEntityData((class_3218)world, cart.method_24515(), cart.method_5667());
        if (data == null) {
            return;
        }
        data.clear();
        data.method_80();
    }
}

