/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import chronosacaria.mcdw.api.interfaces.IDualWielding;
import chronosacaria.mcdw.api.interfaces.IOffhandAttack;
import chronosacaria.mcdw.api.util.AOEHelper;
import chronosacaria.mcdw.api.util.AbilityHelper;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.configs.CompatibilityFlags;
import chronosacaria.mcdw.enums.DaggersID;
import chronosacaria.mcdw.enums.SicklesID;
import chronosacaria.mcdw.registries.EntityAttributesRegistry;
import chronosacaria.mcdw.registries.ParticlesRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1324;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1903;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class PlayerAttackHelper {
    public static boolean mcdw$isLikelyNotMeleeDamage(class_1282 damageSource) {
        return damageSource.method_49708(class_8111.field_42337) || damageSource.method_49708(class_8111.field_42331) || damageSource.method_49708(class_8111.field_42349) || damageSource.method_49708(class_8111.field_42321) || !PlayerAttackHelper.mcdw$isDirectDamage(damageSource);
    }

    private static boolean mcdw$isDirectDamage(class_1282 damageSource) {
        return damageSource.method_49708(class_8111.field_42360) || damageSource.method_49708(class_8111.field_42320);
    }

    public static void mcdw$switchModifiers(class_1657 player, class_1799 switchFrom, class_1799 switchTo) {
        player.method_6127().method_26847(switchFrom.method_7926(class_1304.field_6173));
        player.method_6127().method_26854(switchTo.method_7926(class_1304.field_6173));
    }

    public static void mcdw$offhandAttack(class_1657 playerEntity, class_1297 target) {
        if (CompatibilityFlags.noOffhandConflicts) {
            class_1310 class_13102;
            if (!target.method_5732() && target.method_5698((class_1297)playerEntity)) {
                return;
            }
            class_1799 offhandStack = playerEntity.method_6079();
            PlayerAttackHelper.mcdw$switchModifiers(playerEntity, playerEntity.method_6047(), offhandStack);
            float cooldownProgress = ((IDualWielding)playerEntity).mcdw$getOffhandAttackCooldownProgress(0.5f);
            float attackDamage = (float)playerEntity.method_26825(class_5134.field_23721);
            attackDamage *= (float)((double)0.2f + Math.pow(cooldownProgress, 2.0) * (double)0.8f);
            PlayerAttackHelper.mcdw$switchModifiers(playerEntity, offhandStack, playerEntity.method_6047());
            if (target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                class_13102 = livingTarget.method_6046();
            } else {
                class_13102 = class_1310.field_6290;
            }
            float enchantBonusDamage = class_1890.method_8218((class_1799)offhandStack, (class_1310)class_13102) * cooldownProgress;
            ((IDualWielding)playerEntity).mcdw$resetLastAttackedOffhandTicks();
            if (attackDamage > 0.0f || enchantBonusDamage > 0.0f) {
                boolean playerShouldCrit;
                boolean isMostlyCharged = cooldownProgress > 0.9f;
                int knockbackLevel = class_1890.method_8225((class_1887)class_1893.field_9121, (class_1799)offhandStack);
                if (playerEntity.method_5624() && isMostlyCharged) {
                    CleanlinessHelper.playCenteredSound((class_1309)playerEntity, class_3417.field_14999, 1.0f, 1.0f);
                    ++knockbackLevel;
                }
                boolean bl = playerShouldCrit = isMostlyCharged && AbilityHelper.entityCanCrit((class_1309)playerEntity) && target instanceof class_1309;
                if (playerShouldCrit && !playerEntity.method_5624()) {
                    attackDamage *= 1.5f;
                }
                attackDamage += enchantBonusDamage;
                boolean playerShouldSweep = isMostlyCharged && !playerShouldCrit && !playerEntity.method_5624() && playerEntity.method_24828() && (double)(playerEntity.field_5973 - playerEntity.field_6039) < (double)playerEntity.method_6029() && offhandStack.method_7909() instanceof IOffhandAttack;
                float targetHealth = 0.0f;
                boolean bl5 = false;
                int fireAspectLevel = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)offhandStack);
                if (target instanceof class_1309) {
                    class_1309 livingTarget = (class_1309)target;
                    targetHealth = livingTarget.method_6032();
                    if (fireAspectLevel > 0 && !livingTarget.method_5809()) {
                        bl5 = true;
                        livingTarget.method_5639(1);
                    }
                }
                class_243 targetVelocity = target.method_18798();
                if (target.method_5643(target.method_37908().method_48963().method_48802(playerEntity), attackDamage)) {
                    class_1309 livingTarget;
                    class_1309 livingTarget2;
                    double positionOne = -class_3532.method_15374((float)(playerEntity.method_36454() * ((float)Math.PI / 180)));
                    double positionTwo = class_3532.method_15362((float)(playerEntity.method_36454() * ((float)Math.PI / 180)));
                    if (knockbackLevel > 0) {
                        if (target instanceof class_1309) {
                            livingTarget2 = (class_1309)target;
                            livingTarget2.method_6005((double)((float)knockbackLevel * 0.5f), -positionOne, -positionTwo);
                        } else {
                            target.method_5762(positionOne * (double)knockbackLevel * 0.5, 0.1, positionTwo * (double)knockbackLevel * 0.5);
                        }
                        playerEntity.method_18799(playerEntity.method_18798().method_18805(0.6, 1.0, 0.6));
                        playerEntity.method_5728(false);
                    }
                    if (playerShouldSweep) {
                        float sweepingEdgeMultiplierTimesDamage = 1.0f + class_1903.method_8241((int)class_1890.method_8225((class_1887)class_1893.field_9115, (class_1799)offhandStack)) * attackDamage;
                        playerEntity.method_37908().method_18467(class_1309.class, target.method_5829().method_1009(1.0, 0.25, 1.0)).forEach(sweptEntity -> {
                            if (AOEHelper.satisfySweepConditions((class_1309)playerEntity, target, sweptEntity, 3.0f)) {
                                sweptEntity.method_6005((double)0.4f, -positionOne, -positionTwo);
                                sweptEntity.method_5643(sweptEntity.method_37908().method_48963().method_48802(playerEntity), sweepingEdgeMultiplierTimesDamage);
                            }
                        });
                        CleanlinessHelper.playCenteredSound((class_1309)playerEntity, class_3417.field_14706, 1.0f, 1.0f);
                        class_1937 class_19372 = playerEntity.method_37908();
                        if (class_19372 instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)class_19372;
                            serverWorld.method_14199((class_2394)ParticlesRegistry.OFFHAND_SWEEP_PARTICLE, playerEntity.method_23317() + positionOne, playerEntity.method_23323(0.5), playerEntity.method_23321() + positionTwo, 0, positionOne, 0.0, positionTwo, 0.0);
                        }
                    }
                    if (target instanceof class_3222 && target.field_6037) {
                        ((class_3222)target).field_13987.method_14364((class_2596)new class_2743(target));
                        target.field_6037 = false;
                        target.method_18799(targetVelocity);
                    }
                    if (playerShouldCrit) {
                        CleanlinessHelper.playCenteredSound((class_1309)playerEntity, class_3417.field_15016, 1.0f, 1.0f);
                        playerEntity.method_7277(target);
                    } else if (!playerShouldSweep) {
                        CleanlinessHelper.playCenteredSound((class_1309)playerEntity, isMostlyCharged ? class_3417.field_14840 : class_3417.field_14625, 1.0f, 1.0f);
                    }
                    if (enchantBonusDamage > 0.0f) {
                        playerEntity.method_7304(target);
                    }
                    playerEntity.method_6114(target);
                    if (target instanceof class_1309) {
                        livingTarget2 = (class_1309)target;
                        class_1890.method_8210((class_1309)livingTarget2, (class_1297)playerEntity);
                    }
                    class_1890.method_8213((class_1309)playerEntity, (class_1297)target);
                    class_1297 targetedEntity = target;
                    if (target instanceof class_1508) {
                        class_1508 enderDragonPartTarget = (class_1508)target;
                        targetedEntity = enderDragonPartTarget.field_7007;
                    }
                    if (!playerEntity.method_37908().field_9236 && !offhandStack.method_7960() && targetedEntity instanceof class_1309) {
                        livingTarget = (class_1309)targetedEntity;
                        offhandStack.method_7979(livingTarget, playerEntity);
                        if (offhandStack.method_7960()) {
                            playerEntity.method_6122(class_1268.field_5810, class_1799.field_8037);
                        }
                    }
                    if (target instanceof class_1309) {
                        class_1937 class_19373;
                        livingTarget = (class_1309)target;
                        float targetCurrentHealth = targetHealth - livingTarget.method_6032();
                        playerEntity.method_7339(class_3468.field_15399, Math.round(targetCurrentHealth * 10.0f));
                        if (fireAspectLevel > 0) {
                            target.method_5639(fireAspectLevel * 4);
                        }
                        if ((class_19373 = playerEntity.method_37908()) instanceof class_3218) {
                            class_3218 playerServerWorld = (class_3218)class_19373;
                            if (targetCurrentHealth > 2.0f) {
                                int particleCount = (int)((double)targetCurrentHealth * 0.5);
                                playerServerWorld.method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.5), target.method_23321(), particleCount, 0.1, 0.0, 0.1, 0.2);
                            }
                        }
                    }
                    playerEntity.method_7322(0.1f);
                } else {
                    CleanlinessHelper.playCenteredSound((class_1309)playerEntity, class_3417.field_14914, 1.0f, 1.0f);
                    if (bl5) {
                        target.method_5646();
                    }
                }
            }
        }
    }

    public static boolean mixAndMatchWeapons(class_1657 playerEntity) {
        return playerEntity.method_6079().method_31574(playerEntity.method_6047().method_7909()) || playerEntity.method_6047().method_31574((class_1792)DaggersID.DAGGER_THE_BEGINNING.getItem()) && playerEntity.method_6079().method_31574((class_1792)DaggersID.DAGGER_THE_END.getItem()) || playerEntity.method_6047().method_31574((class_1792)DaggersID.DAGGER_THE_END.getItem()) && playerEntity.method_6079().method_31574((class_1792)DaggersID.DAGGER_THE_BEGINNING.getItem()) || playerEntity.method_6047().method_31574((class_1792)SicklesID.SICKLE_LAST_LAUGH_GOLD.getItem()) && playerEntity.method_6079().method_31574((class_1792)SicklesID.SICKLE_LAST_LAUGH_SILVER.getItem()) || playerEntity.method_6047().method_31574((class_1792)SicklesID.SICKLE_LAST_LAUGH_SILVER.getItem()) && playerEntity.method_6079().method_31574((class_1792)SicklesID.SICKLE_LAST_LAUGH_GOLD.getItem());
    }

    public static double mcdw$getReachDistance(class_1309 livingEntity, double defaultReachDistance) {
        @Nullable class_1324 reachDistance = livingEntity.method_5996(EntityAttributesRegistry.REACH);
        return reachDistance != null ? defaultReachDistance + reachDistance.method_6194() : defaultReachDistance;
    }

    public static double mcdw$getSquaredReachDistance(class_1309 livingEntity, double squareDefaultReachDistance) {
        double reachDistance = PlayerAttackHelper.mcdw$getReachDistance(livingEntity, Math.sqrt(squareDefaultReachDistance));
        return reachDistance * reachDistance;
    }

    public static double mcdw$getAttackRange(class_1309 livingEntity, double defaultAttackRange) {
        @Nullable class_1324 attackRange = livingEntity.method_5996(EntityAttributesRegistry.ATTACK_RANGE);
        return attackRange != null ? defaultAttackRange + attackRange.method_6194() : defaultAttackRange;
    }

    public static double mcdw$getSquaredAttackRange(class_1309 livingEntity, double squareDefaultAttackRange) {
        double attackRange = PlayerAttackHelper.mcdw$getAttackRange(livingEntity, Math.sqrt(squareDefaultAttackRange));
        return attackRange * attackRange;
    }

    public static List<class_1657> mcdw$getPlayerEntitiesWithinReach(class_1937 world, int x, int y, int z, double defaultReachDistance) {
        return PlayerAttackHelper.mcdw$getPlayerEntitiesWithinReach(player -> true, world, x, y, z, defaultReachDistance);
    }

    public static List<class_1657> mcdw$getPlayerEntitiesWithinReach(Predicate<class_1657> viewerPredicate, class_1937 world, int x, int y, int z, double defaultReachDistance) {
        ArrayList<class_1657> playerEntitiesWithinReach = new ArrayList<class_1657>();
        for (class_1657 playerEntity : world.method_18456()) {
            double dz;
            double dy;
            if (!viewerPredicate.test(playerEntity)) continue;
            double reach = PlayerAttackHelper.mcdw$getReachDistance((class_1309)playerEntity, defaultReachDistance);
            double dx = (double)x + 0.5 - playerEntity.method_23317();
            if (!(dx * dx + (dy = (double)y + 0.5 - playerEntity.method_23320()) * dy + (dz = (double)z + 0.5 - playerEntity.method_23321()) * dz <= reach * reach)) continue;
            playerEntitiesWithinReach.add(playerEntity);
        }
        return playerEntitiesWithinReach;
    }

    public static boolean mcdw$isEntityWithinAttackRange(class_1657 playerEntity, class_1297 entity) {
        return playerEntity.method_5858(entity) <= PlayerAttackHelper.mcdw$getSquaredAttackRange((class_1309)playerEntity, 64.0);
    }
}

