/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.mixin.mcdw;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.util.AOEHelper;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.damagesources.OffHandDamageSource;
import chronosacaria.mcdw.effects.EnchantmentEffects;
import chronosacaria.mcdw.enchants.summons.IBeeSummoning;
import chronosacaria.mcdw.enchants.summons.entity.SummonedBeeEntity;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.ItemsID;
import chronosacaria.mcdw.enums.SettingsID;
import chronosacaria.mcdw.enums.SwordsID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.EntityAttributesRegistry;
import chronosacaria.mcdw.registries.ItemsRegistry;
import chronosacaria.mcdw.registries.SummonedEntityRegistry;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    public final class_1299<SummonedBeeEntity> mcdw$summoned_bee = SummonedEntityRegistry.SUMMONED_BEE_ENTITY;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    public float mcdw$damageModifiers(float amount, class_1282 source) {
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return amount;
        }
        class_1309 attackingEntity = (class_1309)class_12972;
        if (amount > 0.0f) {
            class_1321 petSource;
            class_1937 class_19372;
            float storedAmount = amount * Mcdw.CONFIG.mcdwEnchantmentsConfig.directDamageEnchantmentMultiplier;
            if (attackingEntity instanceof class_1321 && (class_19372 = (petSource = (class_1321)attackingEntity).method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_19372 = petSource.method_35057();
                if (class_19372 instanceof class_1657) {
                    class_1657 owner = (class_1657)class_19372;
                    amount += storedAmount * EnchantmentEffects.huntersPromiseDamage(owner, serverWorld);
                }
            }
        }
        return amount;
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void mcdw$onDeath(class_1282 source, CallbackInfo ci) {
        class_1309 victim = (class_1309)this;
        boolean isOffHandAttack = source instanceof OffHandDamageSource;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 attackingEntity = (class_1309)class_12972;
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.PROSPECTOR).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyProspector(attackingEntity, victim, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.RUSHDOWN).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyRushdown(attackingEntity, isOffHandAttack);
            }
        }
        if ((class_12972 = source.method_5529()) instanceof class_1657) {
            class_1657 attackingPlayer = (class_1657)class_12972;
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SOUL_SIPHON).mcdw$getIsEnabled()) {
                EnchantmentEffects.applySoulSiphon(attackingPlayer, isOffHandAttack);
            }
        }
    }

    @Inject(method={"applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at={@At(value="HEAD")})
    public void mcdw$applySmitingEnchantmentDamage(class_1282 source, float amount, CallbackInfo info) {
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 user = (class_1309)class_12972;
        class_1309 target = (class_1309)this;
        if (target instanceof class_1657) {
            return;
        }
        if (source.method_5526() instanceof class_1309 && amount > 0.0f) {
            class_1799 mainHandStack = user.method_6047();
            class_1799 offHandStack = user.method_6079();
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SMITING).mcdw$getIsEnabled()) {
                this.mcdw$applySmite(amount, user, target, mainHandStack);
                this.mcdw$applySmite(amount, user, target, offHandStack);
            }
        }
    }

    @Unique
    private void mcdw$applySmite(float amount, class_1309 user, class_1309 target, class_1799 itemStack) {
        if (itemStack != null && class_1890.method_8225((class_1887)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SMITING), (class_1799)itemStack) > 0 && class_1890.method_8225((class_1887)class_1893.field_9123, (class_1799)itemStack) <= 0) {
            int smitingLevel = class_1890.method_8225((class_1887)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SMITING), (class_1799)itemStack);
            if (target.method_5999()) {
                EnchantmentEffects.causeSmitingAttack(user, target, 3.0f * (float)smitingLevel, amount);
            }
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="HEAD")})
    private void mcdw$onAttack(class_1282 source, float amount, CallbackInfo ci) {
        class_1297 attacker = source.method_5529();
        class_1309 target = (class_1309)this;
        if (target.method_5679(source)) {
            return;
        }
        if (!(attacker instanceof class_1657)) {
            return;
        }
        class_1657 attackingPlayer = (class_1657)attacker;
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.BUSY_BEE).mcdw$getIsEnabled() && ((IBeeSummoning)attackingPlayer).isReadyForBeeSummon(attackingPlayer.field_6012)) {
            class_1799 mainHandStack = attackingPlayer.method_6047();
            class_1799 offHandStack = attackingPlayer.method_6079();
            if (mainHandStack.method_7909() == ItemsRegistry.SWORD_ITEMS.get(SwordsID.SWORD_BEESTINGER) && offHandStack.method_7909() == ItemsRegistry.MCDW_ITEMS.get((Object)ItemsID.ITEM_BEE_STINGER)) {
                offHandStack.method_7934(1);
                SummonedBeeEntity summonedBeeEntity_1 = (SummonedBeeEntity)this.mcdw$summoned_bee.method_5883(attackingPlayer.method_37908());
                if (summonedBeeEntity_1 != null) {
                    summonedBeeEntity_1.setSummoner((class_1297)attackingPlayer);
                    summonedBeeEntity_1.method_5808(attackingPlayer.method_23317(), attackingPlayer.method_23318() + 1.0, attackingPlayer.method_23321(), 0.0f, 0.0f);
                    attackingPlayer.method_37908().method_8649((class_1297)summonedBeeEntity_1);
                }
            }
        }
    }

    @Inject(method={"consumeItem"}, at={@At(value="HEAD")})
    public void mcdw$applyDippingPoisonPotionConsumption(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_1657)) {
            return;
        }
        class_1657 user = (class_1657)livingEntityMixin;
        class_1799 poisonTippedArrow = class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8087, 8), (class_1842)class_1847.field_8982);
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.DIPPING_POISON).mcdw$getIsEnabled()) {
            int dippingPoisonLevel;
            if (!(user.method_6047().method_7909() instanceof class_1812)) {
                return;
            }
            if (user.method_6079() != null && class_1890.method_8225((class_1887)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.DIPPING_POISON), (class_1799)user.method_6079()) > 0 && (dippingPoisonLevel = class_1890.method_8225((class_1887)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.DIPPING_POISON), (class_1799)user.method_6079())) > 0) {
                List potionEffects = class_1844.method_8067((class_1799)user.method_6047());
                if (((class_1293)potionEffects.get(0)).method_5579() != class_1294.field_5915) {
                    return;
                }
                if (((class_1293)potionEffects.get(0)).method_5579() == class_1294.field_5915) {
                    CleanlinessHelper.mcdw$dropItem((class_1309)user, poisonTippedArrow);
                }
            }
        }
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")})
    public void mcdw$onJumpEffects(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof class_3222)) {
            return;
        }
        class_3222 playerEntity = (class_3222)livingEntityMixin;
        if (playerEntity != null) {
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.BURST_BOWSTRING).mcdw$getIsEnabled()) {
                EnchantmentEffects.activateBurstBowstringOnJump((class_1309)playerEntity);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.DYNAMO).mcdw$getIsEnabled()) {
                EnchantmentEffects.handleAddDynamoEffect((class_1657)playerEntity);
            }
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setHealth(F)V")})
    public void mcdw$applySharedPainDamage(class_1282 source, float amount, CallbackInfo ci) {
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1657) {
            class_1309 target;
            float targetHealth;
            LivingEntityMixin livingEntityMixin;
            class_1657 player = (class_1657)class_12972;
            int sharedPainLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SHARED_PAIN), (class_1309)player, false);
            if (sharedPainLevel <= 0) {
                return;
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SHARED_PAIN).mcdw$getIsEnabled() && (livingEntityMixin = this) instanceof class_1309 && (targetHealth = (target = (class_1309)livingEntityMixin).method_6032() - amount) < 0.0f) {
                float overkillDamage = Math.abs(targetHealth);
                List<class_1309> nearbyEntities = AOEHelper.getEntitiesByConfig(target, 6.0f);
                if (nearbyEntities.isEmpty()) {
                    if (Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.ENABLE_ENCHANTMENT_SETTINGS.get((Object)SettingsID.SHARED_PAIN_CAN_DAMAGE_USER).booleanValue()) {
                        player.method_5643(player.method_37908().method_48963().method_48831(), overkillDamage);
                    }
                } else {
                    nearbyEntities.sort(Comparator.comparingDouble(livingEntity -> livingEntity.method_5858((class_1297)target)));
                    nearbyEntities.get(0).method_5643(nearbyEntities.get(0).method_37908().method_48963().method_48831(), overkillDamage);
                }
            }
        }
    }

    @Inject(method={"createLivingAttributes"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void mcdw$addAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(EntityAttributesRegistry.REACH).method_26867(EntityAttributesRegistry.ATTACK_RANGE);
    }
}

