/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.misc.CompressionService;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class DecompressionPattern
implements IPatternDetails {
    static final String NBT_BASE = "base";
    static final String NBT_VARIANT = "variant";
    static final String NBT_FACTOR = "factor";
    private final AEItemKey definition;
    private final AEItemKey base;
    private final AEItemKey variant;
    private final byte factor;

    public DecompressionPattern(AEItemKey definition) {
        this.definition = definition;
        class_2487 tag = Objects.requireNonNull(definition.getTag());
        this.base = AEItemKey.fromTag((class_2487)tag.method_10562(NBT_BASE));
        this.variant = AEItemKey.fromTag((class_2487)tag.method_10562(NBT_VARIANT));
        this.factor = tag.method_10571(NBT_FACTOR);
    }

    public DecompressionPattern(AEItemKey base, CompressionService.Variant variant) {
        this.base = base;
        this.variant = variant.item();
        this.factor = variant.factor();
        class_2487 tag = new class_2487();
        tag.method_10566(NBT_BASE, (class_2520)this.base.toTag());
        tag.method_10566(NBT_VARIANT, (class_2520)this.variant.toTag());
        tag.method_10567(NBT_FACTOR, this.factor);
        this.definition = AEItemKey.of(MEGAItems.DECOMPRESSION_PATTERN, (class_2487)tag);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return new IPatternDetails.IInput[]{new Input(this.variant)};
    }

    public GenericStack[] getOutputs() {
        return new GenericStack[]{new GenericStack((AEKey)this.base, (long)this.factor)};
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((DecompressionPattern)obj).definition.equals((Object)this.definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    private record Input(AEItemKey input) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)this.input, 1L)};
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, class_1937 level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

