/*
 * Decompiled with CFR 0.152.
 */
package com.memorysettings;

import com.cupboard.config.CupboardConfig;
import com.cupboard.config.ICommonConfig;
import com.memorysettings.Memory;
import com.memorysettings.config.CommonConfiguration;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemorysettingsMod
implements ModInitializer {
    public static final String MODID = "memorysettings";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String DISABLE_WARNING_BUTTON = "Stop showing";
    public static CupboardConfig<CommonConfiguration> config = new CupboardConfig("memorysettings", (ICommonConfig)new CommonConfiguration());
    public static Random rand = new Random();
    public static class_5250 memorycheckresult = class_2561.method_43473();

    public MemorysettingsMod() {
        if (!((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).disableWarnings) {
            MemorysettingsMod.doWarning();
        }
    }

    public void onInitialize() {
    }

    public static void doWarning() {
        if (System.getProperties().getProperty("sun.arch.data.model").equals("32") && Memory.systemMemory > 4096) {
            memorycheckresult.method_10852((class_2561)class_2561.method_43471((String)"warning.32bit"));
            LOGGER.warn("You're using 32bit java on a 64bit system, please install 64bit java.");
            MemorysettingsMod.message("You're using 32bit java on a 64bit system, please install 64bit java.");
            return;
        }
        int configMax = FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER ? ((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).maximumClient : ((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).maximumServer;
        int configMin = FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER ? ((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).minimumClient : ((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).minimumServer;
        int recommendMemory = Math.min(MemorysettingsMod.getRecommendedMemoryForSystemMemory(Memory.systemMemory), configMax);
        Object message = "";
        if (Memory.heapSetting > configMax + 250) {
            message = (String)message + "You have more memory allocated(" + Memory.heapSetting + "mb) than recommended for this pack, the maximum is: " + configMax + "mb.\nThe recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.method_10852((class_2561)class_2561.method_43469((String)"warning.toomuch", (Object[])new Object[]{class_2561.method_43470((String)("" + Memory.heapSetting)).method_27692(class_124.field_1054), class_2561.method_43470((String)("" + configMax)).method_27692(class_124.field_1078), class_2561.method_43470((String)("" + recommendMemory)).method_27692(class_124.field_1060)}));
        }
        if (Memory.heapSetting < configMin - 250) {
            message = (String)message + "You have less memory allocated(" + Memory.heapSetting + "mb) than recommended for this pack, the minimum is: " + configMin + "mb.\nThe recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.method_10852((class_2561)class_2561.method_43469((String)"warning.toolow", (Object[])new Object[]{class_2561.method_43470((String)("" + Memory.heapSetting)).method_27692(class_124.field_1054), class_2561.method_43470((String)("" + configMin)).method_27692(class_124.field_1078), class_2561.method_43470((String)("" + recommendMemory)).method_27692(class_124.field_1060)}));
        }
        if ((double)Math.abs(Memory.heapSetting - recommendMemory) / (double)recommendMemory * 100.0 > (double)((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).warningTolerance && Memory.heapSetting <= configMax && Memory.heapSetting >= configMin) {
            message = (String)message + "You have " + (Memory.heapSetting > recommendMemory ? "more" : "less") + " more memory allocated than recommended for your system, the recommended amount for your system is: " + recommendMemory + " mb.\n";
            memorycheckresult.method_10852((class_2561)class_2561.method_43469((String)(Memory.heapSetting > recommendMemory ? "warning.overrecommended" : "warning.underrecommended"), (Object[])new Object[]{class_2561.method_43470((String)("" + Memory.heapSetting)).method_27692(class_124.field_1054), class_2561.method_43470((String)("" + recommendMemory)).method_27692(class_124.field_1060)}));
        }
        if (recommendMemory < configMin - 250) {
            message = (String)message + "The recommended for your system is lower than the required minimum of " + configMin + "mb for this pack, things may not work out so well.\nMost common sign of insufficient ram is frequent stutters.\n";
            memorycheckresult.method_10852((class_2561)class_2561.method_43469((String)"warning.recommendedbelowmin", (Object[])new Object[]{class_2561.method_43470((String)("" + recommendMemory)).method_27692(class_124.field_1060), class_2561.method_43470((String)("" + configMin)).method_27692(class_124.field_1061)}));
        }
        if (((String)message).equals("")) {
            return;
        }
        LOGGER.warn((String)message);
        if (Memory.heapSetting < 1525) {
            MemorysettingsMod.message((String)message);
        }
    }

    private static void message(String s) {
        try {
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) {
                String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
                if (OS.contains("mac") || OS.contains("darwin")) {
                    MemorysettingsMod.openMessageUI(s);
                } else {
                    SwingUtilities.invokeLater(() -> MemorysettingsMod.openMessageUI(s));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error during showing memory warning GUI:", (Throwable)e);
        }
        LOGGER.error(s);
    }

    private static void openMessageUI(String s) {
        Object[] options = new String[]{"Ok", DISABLE_WARNING_BUTTON};
        final JFrame jf = new JFrame("Memory Settings");
        jf.setResizable(false);
        jf.setAlwaysOnTop(true);
        JPanel panel = new JPanel();
        jf.setContentPane(panel);
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(s);
        optionPane.setOptions(options);
        optionPane.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(MemorysettingsMod.DISABLE_WARNING_BUTTON)) {
                    ((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).disableWarnings = true;
                    config.save();
                }
                jf.dispose();
            }
        });
        JEditorPane ep = new JEditorPane("text/html", "");
        panel.add((Component)optionPane, "Center");
        optionPane.add((Component)ep, "Center");
        ep.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        ep.setEditable(false);
        ep.setText("<html><body style=\"" + style + "\">" + ((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).howtolink + "</body></html>");
        ep.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(event.getURL().toURI());
                }
                catch (Exception ex) {
                    LOGGER.warn("error:", (Throwable)ex);
                }
            }
        });
        jf.setSize(new Dimension(Math.max(jf.getPreferredSize().width, ep.getPreferredSize().width), jf.getPreferredSize().height + ep.getPreferredSize().height));
        jf.setLocationRelativeTo(null);
        jf.setVisible(true);
        Object selectedValue = optionPane.getValue();
        jf.setDefaultCloseOperation(2);
        jf.pack();
        if (selectedValue instanceof String && selectedValue.equals(DISABLE_WARNING_BUTTON)) {
            ((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).disableWarnings = true;
            config.save();
        }
    }

    public static int getRecommendedMemoryForSystemMemory(int systemMemory) {
        Map.Entry<Integer, Integer> lastEntry = null;
        int recommendedMemory = 0;
        for (Map.Entry<Integer, Integer> dataEntry : ((CommonConfiguration)MemorysettingsMod.config.getCommonConfig()).recommendedMemory.entrySet()) {
            if (systemMemory > dataEntry.getKey()) {
                lastEntry = dataEntry;
                continue;
            }
            if (lastEntry == null) {
                lastEntry = dataEntry;
                break;
            }
            double percent = (double)(systemMemory - lastEntry.getKey()) / Math.max(1.0, (double)(dataEntry.getKey() - lastEntry.getKey()));
            return (int)((double)lastEntry.getValue().intValue() + percent * (double)(dataEntry.getValue() - lastEntry.getValue()));
        }
        if (lastEntry != null) {
            return (Integer)lastEntry.getValue();
        }
        return recommendedMemory;
    }
}

