/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.blockentity.portal;

import com.github.mim1q.minecells.block.portal.DoorwayPortalBlock;
import com.github.mim1q.minecells.block.portal.DoorwayPortalBlockEntity;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.RenderUtils;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_827;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class DoorwayPortalBlockEntityRenderer
implements class_827<DoorwayPortalBlockEntity> {
    private final class_327 textRenderer;

    public DoorwayPortalBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
    }

    public void render(DoorwayPortalBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_22904(0.5, 0.25, 0.5);
        matrices.method_22907(new Quaternionf().rotationY(MathUtils.radians(180.0f - entity.getRotation())));
        class_4588 backgroundVertices = vertexConsumers.getBuffer(class_1921.method_23578((class_2960)entity.getBackgroundTexture()));
        matrices.method_22904(0.0, 0.0, 0.49);
        this.renderBackground(matrices, backgroundVertices, entity);
        class_4588 foregroundVertices = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)entity.getTexture()));
        matrices.method_22904(0.0, 0.0, -0.01);
        RenderUtils.drawBillboard(foregroundVertices, matrices, 0xF000F0, 1.5f, 2.5f, 0.8125f, 1.0f, 0.0f, 0.3125f, -1);
        float barsProgress = entity.canPlayerEnter((class_1657)class_310.method_1551().field_1724) ? 0.25f : 1.0f;
        float minY = 1.25f - barsProgress * 2.5f;
        float minV = (40.0f - 40.0f * barsProgress) / 128.0f;
        class_4588 barsVertices = vertexConsumers.getBuffer(class_1921.method_23576((class_2960)entity.getTexture()));
        matrices.method_22904(0.0, 0.01, -0.25);
        RenderUtils.drawBillboard(barsVertices, matrices, light, -0.75f, 0.75f, minY, 1.25f, 0.625f, 0.8125f, minV, 0.3125f, -1, class_4608.field_21444);
        List<class_5250> text = entity.getLabel();
        this.renderLabel(text, matrices, vertexConsumers, this.shouldShowPosition(entity.method_10997(), entity.method_11016(), entity.method_11010().method_26204()));
        matrices.method_22909();
    }

    private void renderBackground(class_4587 matrices, class_4588 vertexConsumers, DoorwayPortalBlockEntity entity) {
        class_746 player = class_310.method_1551().field_1724;
        float bgCenterV = 0.5f;
        float bgCenterU = 0.5f;
        if (player != null) {
            class_243 pos = class_243.method_24953((class_2382)entity.method_11016());
            class_243 direction = new class_243(0.0, 0.0, 1.0).method_1024(MathUtils.radians(90.0f - entity.getRotation()));
            class_243 playerPos = player.method_30950(class_310.method_1551().method_1488());
            class_243 playerVector = playerPos.method_1020(pos);
            double playerVectorLength = playerVector.method_1033();
            playerVector = playerVector.method_1029().method_1021(java.lang.Math.min(playerVectorLength * (double)0.33f, 1.0));
            float dot = (float)direction.method_1026(playerVector) * 1.0f / 8.0f;
            float bgCenterUOffset = MathUtils.easeInOutQuad(-1.0f, 1.0f, (float)(java.lang.Math.sin(dot) + 1.0) / 2.0f);
            bgCenterU += Math.clamp((float)-0.3125f, (float)0.3125f, (float)bgCenterUOffset);
            float playerHeightDiff = (float)(playerPos.field_1351 - pos.field_1351) + 1.5f;
            playerVectorLength = java.lang.Math.max(playerVectorLength, 0.9);
            bgCenterV += Math.clamp((float)-0.1875f, (float)0.1875f, (float)(playerHeightDiff * 0.1f * 1.0f / (float)playerVectorLength));
        }
        RenderUtils.drawBillboard(vertexConsumers, matrices, 0xF000F0, 1.5f, 2.5f, bgCenterU - 0.1875f, bgCenterU + 0.1875f, bgCenterV - 0.3125f, bgCenterV + 0.3125f, -1);
    }

    private boolean shouldShowPosition(class_1937 world, class_2338 doorwayPos, class_2248 block) {
        class_3965 blockHit;
        if (world == null) {
            return false;
        }
        if (block == MineCellsBlocks.OVERWORLD_DOORWAY) {
            return false;
        }
        class_239 class_2392 = class_310.method_1551().field_1765;
        if (class_2392 instanceof class_3965 && (blockHit = (class_3965)class_2392).method_17783() != class_239.class_240.field_1333) {
            class_2338 blockHitPos = blockHit.method_17777();
            class_2680 state = world.method_8320(blockHit.method_17777());
            if (!(state.method_26204() instanceof DoorwayPortalBlock.Frame) && !state.method_27852(block)) {
                return false;
            }
            return java.lang.Math.abs(blockHitPos.method_10263() - doorwayPos.method_10263()) <= 1 && java.lang.Math.abs(blockHitPos.method_10264() - doorwayPos.method_10264()) <= 1 && java.lang.Math.abs(blockHitPos.method_10260() - doorwayPos.method_10260()) <= 1;
        }
        return false;
    }

    protected void renderLabel(List<class_5250> text, class_4587 matrices, class_4597 vertexConsumers, boolean showPosition) {
        matrices.method_22903();
        matrices.method_22904(0.0, 2.5, 0.0);
        matrices.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        int y = 15;
        int length = text.size();
        for (int i = length - 1; i >= 0; --i) {
            if (i < length - 1 || showPosition) {
                class_5250 line = text.get(i);
                float h = (float)(-this.textRenderer.method_27525((class_5348)line)) / 2.0f;
                int color = -1;
                int background = Integer.MIN_VALUE;
                this.textRenderer.method_30882((class_2561)line, h, (float)y, color, false, matrix4f, vertexConsumers, class_327.class_6415.field_33993, background, 0xF000F0);
            }
            y -= 10;
        }
        matrices.method_22909();
    }
}

