/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.blockentity.portal;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.block.blockentity.RiftBlockEntity;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.RenderUtils;
import net.minecraft.class_1921;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_827;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RiftBlockEntityRenderer
implements class_827<RiftBlockEntity> {
    private static final class_2960 BASE_TEXTURE = MineCells.createId("textures/blockentity/rift/base.png");
    private static final class_2960 BACKGROUND_TEXTURE = MineCells.createId("textures/blockentity/rift/background.png");
    private static final String DESCRIPTION_KEY = "block.minecells.rift.description";
    private final class_327 textRenderer;

    public RiftBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.textRenderer = ctx.method_32143();
    }

    public void render(RiftBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(new Quaternionf().rotationY(MathUtils.radians(entity.getRotation(tickDelta))));
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 0.001f);
        class_4588 frameConsumer = vertexConsumers.getBuffer(class_1921.method_42600((class_2960)BASE_TEXTURE));
        RenderUtils.drawBillboard(frameConsumer, matrices, 0xF000F0, 1.0f, 2.0f, 0.0f, 0.5f, 0.0f, 1.0f, -2130706433);
        matrices.method_46416(0.0f, 0.0f, -0.002f);
        RenderUtils.drawBillboard(frameConsumer, matrices, 0xF000F0, 1.0f, 2.0f, 0.0f, 0.5f, 0.0f, 1.0f, -1);
        matrices.method_22909();
        Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f).rotateY(1.5707964f + MathUtils.radians(entity.getRotation(tickDelta)));
        class_243 blockPos = class_243.method_24953((class_2382)entity.method_11016());
        class_243 playerVector = player.method_30950(tickDelta).method_1020(blockPos).method_1029();
        float dot = direction.dot((Vector3fc)playerVector.method_46409());
        class_4588 backgroundConsumer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)BACKGROUND_TEXTURE));
        float uOffset = Math.sin((float)dot) * -8.0f;
        float yOffset = Math.clamp((float)-5.0f, (float)5.0f, (float)(1.0f + player.method_30950((float)tickDelta).method_46409().y - (float)blockPos.field_1351)) * 2.0f;
        float scale = 0.33f;
        this.drawPartialPortal(backgroundConsumer, matrices, 2, 22, 5, uOffset, yOffset, scale);
        this.drawPartialPortal(backgroundConsumer, matrices, 3, 28, 2, uOffset, yOffset, scale);
        this.drawPartialPortal(backgroundConsumer, matrices, 4, 30, -2, uOffset, yOffset, scale);
        this.drawPartialPortal(backgroundConsumer, matrices, 3, 28, -5, uOffset, yOffset, scale);
        this.drawPartialPortal(backgroundConsumer, matrices, 2, 22, -7, uOffset, yOffset, scale);
        matrices.method_22909();
        matrices.method_22903();
        class_5250 text = class_2561.method_43471((String)DESCRIPTION_KEY);
        matrices.method_22904(0.5, 2.0, 0.5);
        matrices.method_22907(class_310.method_1551().method_1561().method_24197());
        matrices.method_22905(-0.025f, -0.025f, 0.025f);
        this.textRenderer.method_30882((class_2561)text, (float)(-this.textRenderer.method_27525((class_5348)text)) / 2.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, Integer.MIN_VALUE, 0xF000F0);
        matrices.method_22909();
    }

    private void drawPartialPortal(class_4588 consumer, class_4587 matrices, int width, int height, int x, float uOffset, float vOffset, float scale) {
        int y = -height / 2;
        float startU = 0.5f + ((float)x + uOffset) * scale / 16.0f;
        float startV = 0.5f + ((float)y + vOffset) * scale / 16.0f;
        RenderUtils.drawBillboard(consumer, matrices, 0xF000F0, (float)x / 16.0f, (float)(x + width) / 16.0f, (float)(-height) / 32.0f, (float)height / 32.0f, startU, startU + (float)width * scale / 16.0f, startV, startV + (float)height * scale / 16.0f, -1, class_4608.field_21444);
    }
}

