/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.command;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.accessor.PlayerEntityAccessor;
import com.github.mim1q.minecells.world.state.MineCellsData;
import com.github.mim1q.minecells.world.state.PlayerSpecificMineCellsData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class MineCellsDataCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minecells:print_data").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"serverplayer").executes(MineCellsDataCommand::printServerPlayerData))).then(class_2170.method_9247((String)"serverworld").executes(MineCellsDataCommand::printServerWorldData))).then(class_2170.method_9247((String)"clientplayer").executes(MineCellsDataCommand::printClientPlayerData))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minecells:sync_data").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(MineCellsDataCommand::syncPlayerData)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minecells:clear_data").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(MineCellsDataCommand::clearPlayerData)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minecells:wipe_data").requires(source -> source.method_9259(2) || source.method_9211().method_3724())).executes(MineCellsDataCommand::wipeData));
    }

    private static int syncPlayerData(CommandContext<class_2168> ctx) {
        class_3222 player;
        try {
            player = class_2186.method_9315(ctx, (String)"player");
        }
        catch (CommandSyntaxException e) {
            return 1;
        }
        MineCellsData.syncCurrentPlayerData(player, ((class_2168)ctx.getSource()).method_9225());
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Mine Cells data synchronized for player " + player.method_5477().getString())), false);
        return 0;
    }

    private static int clearPlayerData(CommandContext<class_2168> ctx) {
        class_3222 player;
        try {
            player = class_2186.method_9315(ctx, (String)"player");
        }
        catch (CommandSyntaxException e) {
            return 1;
        }
        MineCellsData data = MineCellsData.get(((class_2168)ctx.getSource()).method_9225());
        data.runs.forEach((k, v) -> {
            v.players.remove(player.method_5667());
            data.method_80();
            MineCellsData.syncCurrentPlayerData(player, ((class_2168)ctx.getSource()).method_9225());
        });
        MineCellsData.syncCurrentPlayerData(player, ((class_2168)ctx.getSource()).method_9225());
        MineCells.DIMENSION_GRAPH.saveStuckPlayer(player);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Mine Cells data cleared for player " + player.method_5477().getString())), false);
        return 0;
    }

    private static int printServerPlayerData(CommandContext<class_2168> ctx) {
        try {
            class_3222 player = class_2186.method_9315(ctx, (String)"player");
            PlayerSpecificMineCellsData data = ((PlayerEntityAccessor)player).getMineCellsData();
            MineCellsDataCommand.sendData((class_2168)ctx.getSource(), player.method_5477().getString(), data);
        }
        catch (CommandSyntaxException e) {
            return 1;
        }
        return 0;
    }

    private static int printClientPlayerData(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Not implemented"), false);
        return 0;
    }

    private static int printServerWorldData(CommandContext<class_2168> ctx) {
        try {
            class_3222 player = class_2186.method_9315(ctx, (String)"player");
            PlayerSpecificMineCellsData data = new PlayerSpecificMineCellsData(MineCellsData.get(((class_2168)ctx.getSource()).method_9225()), player);
            MineCellsDataCommand.sendData((class_2168)ctx.getSource(), player.method_5477().getString(), data);
        }
        catch (CommandSyntaxException e) {
            return 1;
        }
        return 0;
    }

    private static int wipeData(CommandContext<class_2168> ctx) {
        class_3218 world = ((class_2168)ctx.getSource()).method_9225();
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (world == null || player == null) {
            return 1;
        }
        MineCellsData.get(world).wipe(world, player);
        return 0;
    }

    private static void sendData(class_2168 source, String playerName, PlayerSpecificMineCellsData data) {
        source.method_45068(class_2561.method_30163((String)("=== Mine Cells Data for " + playerName + " ===")));
        data.map.forEach((key, value) -> {
            source.method_45068(class_2561.method_30163((String)key));
            source.method_45068(class_2561.method_30163((String)" Portals:"));
            value.portals.forEach(it -> source.method_45068(class_2561.method_30163((String)("  " + String.valueOf((Object)it.fromDimension()) + " [" + it.fromPos().method_23854() + "] -> " + String.valueOf((Object)it.toDimension()) + " [" + it.toPos().method_23854() + "]"))));
            source.method_45068(class_2561.method_30163((String)" Activated Spawner Runes:"));
            value.activatedSpawnerRunes.forEach((k, v) -> {
                StringBuilder runesString = new StringBuilder();
                v.forEach(it -> runesString.append("[").append(it.method_23854()).append("] "));
                source.method_45068(class_2561.method_30163((String)("  " + String.valueOf(k) + ": " + String.valueOf(runesString))));
            });
        });
    }
}

