/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.ai.goal;

import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.nonliving.ShockwavePlacer;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.util.MathUtils;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class ShockwaveGoal<E extends class_1588>
extends TimedActionGoal<E> {
    private final class_2680 shockwaveBlock;
    private final float shockwaveDamage;
    private final int shockwaveRadius;
    private final ShockwaveType shockwaveType;
    private final float shockwaveInterval;

    private ShockwaveGoal(E entity, ShockwaveGoalSettings settings, Predicate<E> predicate) {
        super(entity, settings, predicate);
        this.shockwaveBlock = settings.shockwaveBlock.method_9564();
        this.shockwaveDamage = settings.shockwaveDamage;
        this.shockwaveRadius = settings.shockwaveRadius;
        this.shockwaveType = settings.shockwaveType;
        this.shockwaveInterval = settings.shockwaveInterval;
    }

    public ShockwaveGoal(E entity, Consumer<ShockwaveGoalSettings> settingsConsumer, Predicate<E> predicate) {
        this(entity, ShockwaveGoalSettings.edit(new ShockwaveGoalSettings(), settingsConsumer), predicate);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
    }

    @Override
    protected void runAction() {
        if (((class_1588)this.entity).method_5968() == null) {
            return;
        }
        class_243 offset = MathUtils.vectorRotateY(new class_243(-0.75, 0.2, -0.9), MathUtils.radians(((class_1588)this.entity).field_6283));
        ShockwavePlacer placer = this.shockwaveType == ShockwaveType.LINE ? ShockwavePlacer.createLine(((class_1588)this.entity).method_37908(), ((class_1588)this.entity).method_19538().method_1019(offset), ((class_1588)this.entity).method_5968().method_19538().method_38499(class_2350.class_2351.field_11052, ((class_1588)this.entity).method_19538().field_1351), this.shockwaveInterval, this.shockwaveBlock, ((class_1588)this.entity).method_5667(), this.shockwaveDamage) : ShockwavePlacer.createCircle(((class_1588)this.entity).method_37908(), ((class_1588)this.entity).method_19538().method_1019(offset), this.shockwaveRadius, this.shockwaveInterval, this.shockwaveBlock, ((class_1588)this.entity).method_5667(), this.shockwaveDamage);
        ((class_1588)this.entity).method_37908().method_8649((class_1297)placer);
    }

    @Override
    public boolean method_6264() {
        class_1309 target = ((class_1588)this.entity).method_5968();
        return super.method_6264() && target != null;
    }

    @Override
    public void method_6269() {
        super.method_6269();
        class_1309 target = ((class_1588)this.entity).method_5968();
        if (target == null) {
            return;
        }
        ((class_1588)this.entity).method_5951((class_1297)target, 180.0f, 180.0f);
        ((class_1588)this.entity).method_5942().method_6340();
        ((class_1588)this.entity).method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
    }

    public static class ShockwaveGoalSettings
    extends TimedActionGoal.TimedActionSettings {
        public class_2248 shockwaveBlock = MineCellsBlocks.SHOCKWAVE_FLAME;
        public int shockwaveRadius = 12;
        public ShockwaveType shockwaveType = ShockwaveType.LINE;
        public float shockwaveDamage = 6.0f;
        public float shockwaveInterval = 1.0f;
    }

    public static enum ShockwaveType {
        LINE,
        CIRCLE;

    }
}

