/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.ai.goal;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3414;

public abstract class TimedActionGoal<E extends class_1309>
extends class_1352 {
    protected final E entity;
    protected final Supplier<Integer> cooldownGetter;
    protected final Consumer<Integer> cooldownSetter;
    protected final BiConsumer<State, Boolean> stateSetter;
    protected final int defaultCooldown;
    protected final int actionTick;
    protected final int length;
    protected final float chance;
    protected final class_3414 chargeSound;
    protected final class_3414 releaseSound;
    protected final float soundVolume;
    protected final Predicate<E> startPredicate;
    private int ticks = 0;

    protected <S extends TimedActionSettings> TimedActionGoal(E entity, S settings, Predicate<E> predicate) {
        this.entity = entity;
        this.cooldownGetter = settings.cooldownGetter;
        this.cooldownSetter = settings.cooldownSetter;
        this.stateSetter = settings.stateSetter;
        this.defaultCooldown = settings.defaultCooldown;
        this.actionTick = settings.actionTick;
        this.length = settings.length;
        this.chance = settings.chance;
        this.chargeSound = settings.chargeSound;
        this.releaseSound = settings.releaseSound;
        this.soundVolume = settings.soundVolume;
        this.startPredicate = predicate == null ? Objects::nonNull : predicate;
    }

    public TimedActionGoal(E entity, Consumer<TimedActionSettings> settingsConsumer, Predicate<E> predicate) {
        this(entity, TimedActionSettings.edit(new TimedActionSettings(), settingsConsumer), predicate);
    }

    public boolean method_6264() {
        int cooldown = this.cooldownGetter.get();
        return cooldown <= 0 && (this.chance == 1.0f || this.entity.method_6051().method_43057() < this.chance) && this.startPredicate.test(this.entity);
    }

    public boolean method_6266() {
        return this.ticks <= this.length;
    }

    public void method_6269() {
        this.ticks = 0;
        this.stateSetter.accept(State.CHARGE, true);
        this.playChargeSound();
    }

    public void method_6268() {
        if (this.ticks == this.actionTick) {
            this.runAction();
            this.stateSetter.accept(State.CHARGE, false);
            this.stateSetter.accept(State.RELEASE, true);
            this.playReleaseSound();
        } else if (this.ticks < this.actionTick) {
            this.charge();
        } else {
            this.release();
        }
        ++this.ticks;
    }

    protected int ticks() {
        return this.ticks;
    }

    protected void runAction() {
    }

    protected void charge() {
    }

    protected void release() {
    }

    protected void playSound(class_3414 soundEvent) {
        if (soundEvent != null) {
            this.entity.method_5783(soundEvent, this.soundVolume, 1.0f);
        }
    }

    protected void playChargeSound() {
        this.playSound(this.chargeSound);
    }

    protected void playReleaseSound() {
        this.playSound(this.releaseSound);
    }

    public void method_6270() {
        this.cooldownSetter.accept(this.defaultCooldown);
        this.stateSetter.accept(State.CHARGE, false);
        this.stateSetter.accept(State.RELEASE, false);
    }

    public boolean method_38846() {
        return true;
    }

    public static class TimedActionSettings {
        public Supplier<Integer> cooldownGetter = () -> 0;
        public Consumer<Integer> cooldownSetter = cooldown -> {};
        public BiConsumer<State, Boolean> stateSetter = (state, value) -> {};
        public int defaultCooldown = 100;
        public int actionTick = 10;
        public int length = 20;
        public float chance = 1.0f;
        public class_3414 chargeSound;
        public class_3414 releaseSound;
        public float soundVolume = 1.0f;

        public static <S extends TimedActionSettings> S edit(S settings, Consumer<S> consumer) {
            consumer.accept(settings);
            return settings;
        }
    }

    public static enum State {
        IDLE,
        CHARGE,
        RELEASE;

    }
}

