/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.util.animation;

import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import java.util.function.Consumer;
import net.minecraft.class_3532;
import net.minecraft.class_630;

public class AnimationUtils {
    public static void bipedWalk(float limbAngle, float limbDistance, class_630 root, class_630 rightLeg, class_630 leftLeg, class_630 rightArm, class_630 leftArm, class_630 lowerTorso, class_630 upperTorso) {
        float rightLegPitch;
        rightLeg.field_3654 = rightLegPitch = class_3532.method_15374((float)(limbAngle * 0.5f)) * limbDistance;
        leftLeg.field_3654 = -rightLegPitch;
        leftArm.field_3654 = -rightLegPitch;
        rightArm.field_3654 = rightLegPitch;
        root.field_3656 = 24.0f - class_3532.method_15379((float)class_3532.method_15374((float)((limbAngle + (float)Math.PI) * 0.5f))) * limbDistance;
        float torso = class_3532.method_15374((float)(limbAngle + (float)Math.PI)) * limbDistance * ((float)Math.PI / 180);
        if (upperTorso != null) {
            upperTorso.field_3654 = torso;
        }
        if (lowerTorso != null) {
            lowerTorso.field_3654 = torso;
        }
    }

    public static void rotateHead(float headYaw, float headPitch, class_630 head) {
        head.field_3675 = headYaw * ((float)Math.PI / 180);
        head.field_3654 = headPitch * ((float)Math.PI / 180);
    }

    public static void lerpModelPartRotation(class_630 part, float pitch, float yaw, float roll, float delta) {
        part.field_3654 = class_3532.method_16439((float)delta, (float)part.field_3654, (float)(pitch * ((float)Math.PI / 180)));
        part.field_3675 = class_3532.method_16439((float)delta, (float)part.field_3675, (float)(yaw * ((float)Math.PI / 180)));
        part.field_3674 = class_3532.method_16439((float)delta, (float)part.field_3674, (float)(roll * ((float)Math.PI / 180)));
    }

    public static float wobble(float progress, float speed, float scale, float offset) {
        return org.joml.Math.sin((float)(MathUtils.radians(offset) + progress * speed)) * MathUtils.radians(scale);
    }

    public static float wobble(float progress, float speed, float scale) {
        return AnimationUtils.wobble(progress, speed, scale, 0.0f);
    }

    public static float wobble(float progress, float speed) {
        return AnimationUtils.wobble(progress, speed, 1.0f);
    }

    public static void lerpAngles(class_630 bone, Float pitchDeg, Float yawDeg, Float rollDeg, float delta) {
        if (pitchDeg != null) {
            bone.field_3654 = class_3532.method_16439((float)delta, (float)bone.field_3654, (float)MathUtils.radians(pitchDeg.floatValue()));
        }
        if (yawDeg != null) {
            bone.field_3675 = class_3532.method_16439((float)delta, (float)bone.field_3675, (float)MathUtils.radians(yawDeg.floatValue()));
        }
        if (rollDeg != null) {
            bone.field_3674 = class_3532.method_16439((float)delta, (float)bone.field_3674, (float)MathUtils.radians(rollDeg.floatValue()));
        }
    }

    public static void lerpAngles(class_630 bone, float pitchDeg, float yawDeg, float rollDeg, float delta) {
        bone.field_3654 = class_3532.method_16439((float)delta, (float)bone.field_3654, (float)MathUtils.radians(pitchDeg));
        bone.field_3675 = class_3532.method_16439((float)delta, (float)bone.field_3675, (float)MathUtils.radians(yawDeg));
        bone.field_3674 = class_3532.method_16439((float)delta, (float)bone.field_3674, (float)MathUtils.radians(rollDeg));
    }

    public static void animate(AnimationProperty animation, Consumer<Float> animationPlayer, float animationProgress) {
        float delta = animation.update(animationProgress);
        if (delta > 1.0E-5f) {
            animationPlayer.accept(Float.valueOf(delta));
        }
    }
}

