/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.world.feature.tree;

import com.github.mim1q.minecells.block.CageBlock;
import com.github.mim1q.minecells.block.FlagBlock;
import com.github.mim1q.minecells.block.FlagPoleBlock;
import com.github.mim1q.minecells.block.MineCellsBlockTags;
import com.github.mim1q.minecells.block.SkeletonDecorationBlock;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_5172;
import net.minecraft.class_5819;

public interface PromenadeTreeHelper {
    public static final class_2680 TRUNK_BLOCK = MineCellsBlocks.PUTRID_WOOD.log.method_9564();

    default public void placeBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 origin, class_2350 direction, boolean decorations) {
        if (decorations && random.method_43057() < 0.025f) {
            this.placeFlag(replacer, origin, direction, random);
            return;
        }
        boolean big = random.method_43057() < 0.75f;
        class_2382 offset = direction.method_10163();
        origin = origin.method_10081(offset);
        replacer.accept(origin, TRUNK_BLOCK);
        if (big) {
            origin = origin.method_10081(offset).method_10084();
            replacer.accept(origin, TRUNK_BLOCK);
            replacer.accept(origin.method_10084(), TRUNK_BLOCK);
        }
        if (random.method_43057() < 0.5f) {
            int length = 3 + random.method_43048(8);
            if (decorations && this.canPlaceChain(world, origin.method_10074(), length + 2)) {
                class_2248 chain = random.method_43057() < 0.33f ? MineCellsBlocks.BIG_CHAIN : class_2246.field_23985;
                this.placeChain(replacer, random, origin.method_10074(), length, chain.method_9564());
                if (big) {
                    class_2338 pos = origin.method_10081(direction.method_10153().method_10163());
                    class_2680 state = (class_2680)chain.method_9564().method_11657((class_2769)class_5172.field_11459, (Comparable)direction.method_10166());
                    replacer.accept(pos, state);
                }
            }
        }
    }

    default public void placeRoot(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_2338 origin, int height) {
        origin = origin.method_10086(height);
        for (int i = height; i > -3; --i) {
            if (!world.method_16358(origin, state -> state.method_26164(MineCellsBlockTags.TREE_ROOT_REPLACEABLE))) continue;
            class_2338[] positions = new class_2338[]{origin.method_10095(), origin.method_10072(), origin.method_10078(), origin.method_10067()};
            boolean shouldPlace = false;
            for (class_2338 pos : positions) {
                if (!world.method_16358(pos, state -> state.method_26220((class_1922)world, pos).method_1110())) continue;
                shouldPlace = true;
            }
            if (!shouldPlace) {
                return;
            }
            replacer.accept(origin, TRUNK_BLOCK);
            origin = origin.method_10074();
        }
    }

    default public void placeFlag(BiConsumer<class_2338, class_2680> replacer, class_2338 origin, class_2350 direction, class_5819 random) {
        FlagBlock flagBlock = random.method_43056() ? MineCellsBlocks.PROMENADE_OF_THE_CONDEMNED_FLAG : MineCellsBlocks.RIBBON_FLAGS.get(class_1767.field_7964);
        class_2680 pole = (class_2680)MineCellsBlocks.FLAG_POLE.method_9564().method_11657((class_2769)FlagPoleBlock.FACING, (Comparable)direction);
        class_2382 offset = direction.method_10163();
        origin = origin.method_10081(offset);
        replacer.accept(origin, (class_2680)pole.method_11657((class_2769)FlagPoleBlock.CONNECTING, (Comparable)Boolean.valueOf(true)));
        origin = origin.method_10081(offset);
        replacer.accept(origin, (class_2680)pole.method_11657((class_2769)FlagPoleBlock.CONNECTING, (Comparable)Boolean.valueOf(false)));
        replacer.accept(origin.method_10074(), (class_2680)((class_2680)flagBlock.method_9564().method_11657((class_2769)FlagBlock.FACING, (Comparable)direction.method_10170())).method_11657(FlagBlock.PLACEMENT, (Comparable)((Object)FlagBlock.Placement.CENTERED)));
    }

    default public boolean canPlaceChain(class_3746 world, class_2338 origin, int length) {
        for (int i = 0; i < length; ++i) {
            boolean obstructed = world.method_16358(origin.method_10087(i), state -> !state.method_26215());
            if (!obstructed) continue;
            return false;
        }
        return true;
    }

    default public void placeChain(BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 origin, int length, class_2680 chain) {
        for (int i = 0; i < length; ++i) {
            replacer.accept(origin.method_10087(i), chain);
        }
        if (random.method_43057() < 0.5f) {
            this.placeChainDecoration(replacer, random, origin.method_10087(length));
        }
    }

    default public void placeChainDecoration(BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 origin) {
        if (random.method_43057() < 0.25f) {
            List<class_2248> corpses = List.of(MineCellsBlocks.HANGED_CORPSE, MineCellsBlocks.HANGED_SKELETON, MineCellsBlocks.HANGED_ROTTING_CORPSE);
            class_2248 corpse = corpses.get(random.method_43048(3));
            class_2350 direction = (class_2350)class_2741.field_12481.method_11898().stream().toList().get(random.method_43048(4));
            replacer.accept(origin, (class_2680)corpse.method_9564().method_11657((class_2769)SkeletonDecorationBlock.FACING, (Comparable)direction));
            return;
        }
        boolean broken = random.method_43056();
        if (broken) {
            replacer.accept(origin, (class_2680)MineCellsBlocks.BROKEN_CAGE.method_9564().method_11657((class_2769)CageBlock.FLIPPED, (Comparable)Boolean.valueOf(true)));
            return;
        }
        replacer.accept(origin, (class_2680)MineCellsBlocks.CAGE.method_9564().method_11657((class_2769)CageBlock.FLIPPED, (Comparable)Boolean.valueOf(true)));
        replacer.accept(origin.method_10074(), MineCellsBlocks.CAGE.method_9564());
    }
}

