/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.widgets;

import com.jab125.mpuc.client.gui.widget.flow.CoordWrapper;
import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.ParentWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.Widget;
import com.jab125.mpuc.client.util.Context;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class FlowWidget
extends AbstractWidget
implements ParentWidget {
    protected final ArrayList<Widget> children = new ArrayList();
    protected final ArrayList<CoordWrapper> bakedWidgets = new ArrayList();
    private final int width;
    private final int height;
    private final Direction direction;
    protected boolean baked;

    public FlowWidget(class_310 client, int width, int height, Direction direction) {
        super(client);
        this.width = width;
        this.height = height;
        this.direction = direction;
    }

    @Override
    public void addChild(Widget widget) {
        widget.setParent(this);
        this.children.add(widget);
        this.markDirty();
    }

    @Override
    public void addChild(int index, Widget widget) {
        widget.setParent(this);
        this.children.add(index, widget);
        this.markDirty();
    }

    @Override
    public void markDirty() {
        this.baked = false;
    }

    public void bake(int width, int height) {
        this.bakedWidgets.clear();
        int i = 0;
        for (Widget child : this.children) {
            int cWidth = child.getRequestedWidth();
            int cHeight = child.getRequestedHeight();
            double scale = 1.0;
            if (width != 0 && cWidth != 0 && cWidth > width) {
                scale = (double)width / (double)child.getRequestedWidth();
            }
            child.setWidth((int)((double)cWidth * scale));
            if (child.keepAspectRatio()) {
                child.setHeight((int)((double)cHeight * scale));
            } else {
                child.setHeight(cHeight);
            }
            child.markDirty();
            CoordWrapper e = new CoordWrapper(child, this.direction == Direction.VERTICAL ? 0 : i, this.direction == Direction.VERTICAL ? i : 0);
            this.bakedWidgets.add(e);
            i = this.direction == Direction.VERTICAL ? e.getBottomY() : e.getRightX();
        }
        this.baked = true;
    }

    @Override
    public void render(Context context, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.passThrough();
        if (!this.baked) {
            this.bake(width, height);
        }
        for (CoordWrapper bakedWidget : this.bakedWidgets) {
            Widget widget = bakedWidget.widget;
            int xTransform = bakedWidget.x;
            int yTransform = bakedWidget.y;
            class_4587 matrixStack = context.getMatrices();
            matrixStack.method_22903();
            matrixStack.method_46416((float)xTransform, (float)yTransform, 0.0f);
            widget.render(context, widget.getWidth(), widget.getHeight(), mouseX - xTransform, mouseY - yTransform, hovered && widget.isMouseOver(mouseX - xTransform, mouseY - yTransform), tickDelta);
            matrixStack.method_22909();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional<CoordWrapper> first;
        this.passThrough();
        if (!this.baked) {
            this.bake(this.width, this.height);
        }
        if ((first = this.bakedWidgets.stream().filter(a -> a.widget.isMouseOver((int)(mouseX - (double)a.x), (int)(mouseY - (double)a.y))).findFirst()).isEmpty()) {
            return false;
        }
        return first.get().widget.mouseClicked(mouseX - (double)first.get().x, mouseY - (double)first.get().y, button);
    }

    @Override
    public int getRequestedWidth() {
        return this.width;
    }

    @Override
    public int getRequestedHeight() {
        return this.height;
    }

    @Override
    public void passThrough() {
        for (Widget child : this.children) {
            child.passThrough();
        }
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

