/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.server;

import com.jab125.mpuc.api.MpucApi;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.server.command.MpucCommands;
import com.jab125.mpuc.util.ChangelogUtils;
import com.jab125.mpuc.util.OnlineInfo;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.Map;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class MpucServer
implements DedicatedServerModInitializer {
    public void onInitializeServer() {
        MpucCommands.register((registryAccess, environment) -> {
            LiteralArgumentBuilder modpack = class_2170.method_9247((String)"modpack");
            LiteralArgumentBuilder show = class_2170.method_9247((String)"show");
            LiteralArgumentBuilder version = class_2170.method_9247((String)"version");
            LiteralArgumentBuilder latest = class_2170.method_9247((String)"latest");
            LiteralArgumentBuilder current = class_2170.method_9247((String)"current");
            Command currentExecutes = context -> {
                MpucServer.sendMessage((class_2168)context.getSource(), (class_2561)class_2561.method_43470((String)MpucApi.getInstance().getCurrentModpackVersion()));
                return 0;
            };
            Command latestExecutes = context -> {
                MpucServer.sendMessage((class_2168)context.getSource(), (class_2561)class_2561.method_43470((String)MpucApi.getInstance().getLatestModpackVersion()));
                return 0;
            };
            version.executes(currentExecutes);
            latest.executes(latestExecutes);
            current.executes(currentExecutes);
            version.then((ArgumentBuilder)latest);
            version.then((ArgumentBuilder)current);
            modpack.then((ArgumentBuilder)version);
            RequiredArgumentBuilder changelog = class_2170.method_9244((String)"changelog", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
                for (Map.Entry<String, OnlineInfo.Version> stringVersionEntry : ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions.entrySet()) {
                    builder.suggest(stringVersionEntry.getKey());
                }
                return builder.buildFuture();
            });
            LiteralArgumentBuilder changelog2 = class_2170.method_9247((String)"changelog");
            changelog.executes(context -> {
                Map<String, OnlineInfo.Version> versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
                String changelogArgument = (String)context.getArgument("changelog", String.class);
                if (versions.containsKey(changelogArgument)) {
                    MpucServer.sendMessage((class_2168)context.getSource(), ChangelogUtils.fromString(versions.get(changelogArgument).changelog()));
                }
                return 0;
            });
            changelog2.then((ArgumentBuilder)changelog);
            show.then((ArgumentBuilder)changelog2);
            modpack.then((ArgumentBuilder)show);
            return modpack;
        });
        MpucCommands.bootstrap();
    }

    private static void sendMessage(class_2168 source, class_2561 text) {
        source.method_45068(text);
    }
}

