/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.server.util.text;

import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_3902;
import net.minecraft.class_5224;
import net.minecraft.class_5348;

public class ServerTextVisitFactory {
    private static final char REPLACEMENT_CHARACTER = '\ufffd';
    private static final Optional<Object> VISIT_TERMINATED = Optional.of(class_3902.field_17274);

    private static boolean visitRegularCharacter(class_2583 style, class_5224 visitor, int index, char c) {
        if (Character.isSurrogate(c)) {
            return visitor.accept(index, style, 65533);
        }
        return visitor.accept(index, style, (int)c);
    }

    public static boolean visitForwards(String text, class_2583 style, class_5224 visitor) {
        int i = text.length();
        for (int j = 0; j < i; ++j) {
            char c = text.charAt(j);
            if (Character.isHighSurrogate(c)) {
                if (j + 1 >= i) {
                    if (visitor.accept(j, style, 65533)) break;
                    return false;
                }
                char d = text.charAt(j + 1);
                if (Character.isLowSurrogate(d)) {
                    if (!visitor.accept(j, style, Character.toCodePoint(c, d))) {
                        return false;
                    }
                    ++j;
                    continue;
                }
                if (visitor.accept(j, style, 65533)) continue;
                return false;
            }
            if (ServerTextVisitFactory.visitRegularCharacter(style, visitor, j, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean visitBackwards(String text, class_2583 style, class_5224 visitor) {
        int i = text.length();
        for (int j = i - 1; j >= 0; --j) {
            char c = text.charAt(j);
            if (Character.isLowSurrogate(c)) {
                if (j - 1 < 0) {
                    if (visitor.accept(0, style, 65533)) break;
                    return false;
                }
                char d = text.charAt(j - 1);
                if (Character.isHighSurrogate(d)) {
                    if (visitor.accept(--j, style, Character.toCodePoint(d, c))) continue;
                } else if (visitor.accept(j, style, 65533)) continue;
                return false;
            }
            if (ServerTextVisitFactory.visitRegularCharacter(style, visitor, j, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean visitFormatted(String text, class_2583 style, class_5224 visitor) {
        return ServerTextVisitFactory.visitFormatted(text, 0, style, visitor);
    }

    public static boolean visitFormatted(String text, int startIndex, class_2583 style, class_5224 visitor) {
        return ServerTextVisitFactory.visitFormatted(text, startIndex, style, style, visitor);
    }

    public static boolean visitFormatted(String text, int startIndex, class_2583 startingStyle, class_2583 resetStyle, class_5224 visitor) {
        int i = text.length();
        class_2583 style = startingStyle;
        for (int j = startIndex; j < i; ++j) {
            char d;
            char c = text.charAt(j);
            if (c == '\u00a7') {
                if (j + 1 >= i) break;
                d = text.charAt(j + 1);
                class_124 formatting = class_124.method_544((char)d);
                if (formatting != null) {
                    style = formatting == class_124.field_1070 ? resetStyle : style.method_27707(formatting);
                }
                ++j;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                if (j + 1 >= i) {
                    if (visitor.accept(j, style, 65533)) break;
                    return false;
                }
                d = text.charAt(j + 1);
                if (Character.isLowSurrogate(d)) {
                    if (!visitor.accept(j, style, Character.toCodePoint(c, d))) {
                        return false;
                    }
                    ++j;
                    continue;
                }
                if (visitor.accept(j, style, 65533)) continue;
                return false;
            }
            if (ServerTextVisitFactory.visitRegularCharacter(style, visitor, j, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean visitFormatted(class_5348 text, class_2583 style2, class_5224 visitor) {
        return !text.method_27658((style, string) -> ServerTextVisitFactory.visitFormatted(string, 0, style, visitor) ? Optional.empty() : VISIT_TERMINATED, style2).isPresent();
    }

    public static String validateSurrogates(String text) {
        StringBuilder stringBuilder = new StringBuilder();
        ServerTextVisitFactory.visitForwards(text, class_2583.field_24360, (index, style, codePoint) -> {
            stringBuilder.appendCodePoint(codePoint);
            return true;
        });
        return stringBuilder.toString();
    }

    public static String removeFormattingCodes(class_5348 text) {
        StringBuilder stringBuilder = new StringBuilder();
        ServerTextVisitFactory.visitFormatted(text, class_2583.field_24360, (index, style, codePoint) -> {
            stringBuilder.appendCodePoint(codePoint);
            return true;
        });
        return stringBuilder.toString();
    }
}

