/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidImpl;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SoftFluid {
    private final class_2561 name;
    private final LazyFluidSet equivalentFluids;
    private final FluidContainerList containerList;
    private final FoodProvider food;
    private final List<String> NBTFromItem;
    public final boolean isGenerated;
    private final class_2960 stillTexture;
    private final class_2960 flowingTexture;
    @Nullable
    private final class_2960 useTexturesFrom;
    private final int luminosity;
    private final int emissivity;
    private final int tintColor;
    private final TintMethod tintMethod;
    protected int averageTextureTint = -1;
    public static final int BOTTLE_COUNT = Capacity.BOTTLE.getValue();
    public static final int BOWL_COUNT = Capacity.BOWL.getValue();
    public static final int BUCKET_COUNT = Capacity.BUCKET.getValue();
    public static final int WATER_BUCKET_COUNT = 3;
    public static final Codec<class_6880<SoftFluid>> HOLDER_CODEC = class_5381.method_29749(SoftFluidRegistry.KEY, CODEC);
    public static final Codec<class_2561> COMPONENT_CODEC = Codec.either((Codec)class_5699.field_40722, (Codec)Codec.STRING).xmap(either -> (class_2561)either.map(c -> c, class_2561::method_43471), Either::left);
    public static final Codec<SoftFluid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("still_texture").forGetter(SoftFluid::getStillTexture), (App)class_2960.field_25139.fieldOf("flowing_texture").forGetter(SoftFluid::getFlowingTexture), (App)StrOpt.of(COMPONENT_CODEC, "translation_key").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTranslatedName)), (App)StrOpt.of(Codec.intRange((int)0, (int)15), "luminosity").forGetter(SoftFluid.getHackyOptional(SoftFluid::getLuminosity)), (App)StrOpt.of(Codec.intRange((int)0, (int)15), "emissivity").forGetter(SoftFluid.getHackyOptional(SoftFluid::getEmissivity)), (App)StrOpt.of(ColorUtils.CODEC, "color").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTintColor)), (App)StrOpt.of(TintMethod.CODEC, "tint_method").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTintMethod)), (App)FoodProvider.CODEC.optionalFieldOf("food").forGetter(SoftFluid.getHackyOptional(SoftFluid::getFoodProvider)), (App)StrOpt.of(Codec.STRING.listOf(), "preserved_tags_from_item").forGetter(SoftFluid.getHackyOptional(SoftFluid::getNbtKeyFromItem)), (App)StrOpt.of(FluidContainerList.Category.CODEC.listOf(), "containers").forGetter(f -> f.getContainerList().encodeList()), (App)StrOpt.of(Codec.STRING.listOf(), "equivalent_fluids", new ArrayList()).forGetter(s -> s.equivalentFluids.keys), (App)StrOpt.of(class_2960.field_25139, "use_texture_from").forGetter(s -> Optional.ofNullable(s.getTextureOverride()))).apply((Applicative)instance, SoftFluid::create));
    private static final SoftFluid DEFAULT_DUMMY = new SoftFluid(new Builder(new class_2960(""), new class_2960("")));

    private SoftFluid(Builder builder) {
        Triplet<class_2960, class_2960, Integer> data;
        this.tintMethod = builder.tintMethod;
        this.equivalentFluids = new LazyFluidSet(builder.equivalentFluids);
        this.luminosity = builder.luminosity;
        this.emissivity = builder.emissivity;
        this.containerList = builder.containerList;
        this.food = builder.food;
        this.name = builder.name;
        this.NBTFromItem = builder.NBTFromItem;
        this.useTexturesFrom = builder.useTexturesFrom;
        class_2960 still = builder.stillTexture;
        class_2960 flowing = builder.flowingTexture;
        int tint = builder.tintColor;
        if (this.useTexturesFrom != null && PlatHelper.getPhysicalSide().isClient() && (data = SoftFluid.getRenderingData(this.useTexturesFrom)) != null) {
            still = data.left();
            flowing = data.middle();
            tint = data.right();
        }
        this.stillTexture = still;
        this.flowingTexture = flowing;
        this.tintColor = tint;
        this.isGenerated = builder.isFromData;
    }

    @Nullable
    public class_2960 getTextureOverride() {
        return this.useTexturesFrom;
    }

    public FoodProvider getFoodProvider() {
        return this.food;
    }

    public class_2561 getTranslatedName() {
        return this.name;
    }

    @Deprecated(forRemoval=true)
    public String getTranslationKey() {
        return "fluid";
    }

    public boolean isEnabled() {
        return !this.equivalentFluids.isEmpty() || !this.containerList.getPossibleFilled().isEmpty();
    }

    @Deprecated(forRemoval=true)
    public String getFromMod() {
        return "minecraft";
    }

    public class_3611 getVanillaFluid() {
        Iterator<class_3611> iterator = this.getEquivalentFluids().iterator();
        if (iterator.hasNext()) {
            class_3611 fluid = iterator.next();
            return fluid;
        }
        return class_3612.field_15906;
    }

    @Deprecated(forRemoval=true)
    public class_3611 getForgeFluid() {
        return this.getVanillaFluid();
    }

    public List<String> getNbtKeyFromItem() {
        return this.NBTFromItem;
    }

    public List<class_3611> getEquivalentFluids() {
        return this.equivalentFluids.getFluids();
    }

    public boolean isEquivalent(class_3611 fluid) {
        return this.equivalentFluids.getFluids().contains(fluid);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public boolean isEmpty() {
        return this == SoftFluidRegistry.empty();
    }

    public boolean isEmptyFluid() {
        return this == SoftFluidRegistry.empty();
    }

    public Optional<class_1792> getFilledContainer(class_1792 emptyContainer) {
        return this.containerList.getFilled(emptyContainer);
    }

    public Optional<class_1792> getEmptyContainer(class_1792 filledContainer) {
        return this.containerList.getEmpty(filledContainer);
    }

    public FluidContainerList getContainerList() {
        return this.containerList;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public int getEmissivity() {
        return this.emissivity;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public int getAverageTextureTintColor() {
        return this.averageTextureTint;
    }

    public TintMethod getTintMethod() {
        return this.tintMethod;
    }

    public boolean isColored() {
        return this.tintColor != -1;
    }

    public class_2960 getFlowingTexture() {
        return this.flowingTexture;
    }

    public class_2960 getStillTexture() {
        return this.stillTexture;
    }

    public boolean isFood() {
        return !this.food.isEmpty();
    }

    protected static SoftFluid create(class_2960 still, class_2960 flowing, Optional<class_2561> translation, Optional<Integer> luminosity, Optional<Integer> emissivity, Optional<Integer> color, Optional<TintMethod> tint, Optional<FoodProvider> food, Optional<List<String>> nbtKeys, Optional<List<FluidContainerList.Category>> containers, List<String> equivalent, Optional<class_2960> textureFrom) {
        Builder builder = new Builder(still, flowing);
        translation.ifPresent(builder::translation);
        luminosity.ifPresent(builder::luminosity);
        emissivity.ifPresent(builder::emissivity);
        color.ifPresent(builder::color);
        tint.ifPresent(builder::tintMethod);
        food.ifPresent(builder::food);
        nbtKeys.ifPresent(k -> k.forEach(xva$0 -> builder.keepNBTFromItem((String)xva$0)));
        containers.ifPresent(b -> builder.containers(new FluidContainerList((List<FluidContainerList.Category>)b)));
        builder.equivalentFluids.addAll(equivalent);
        textureFrom.ifPresent(builder::copyTexturesFrom);
        return builder.build();
    }

    private static <T> Function<SoftFluid, Optional<T>> getHackyOptional(Function<SoftFluid, T> getter) {
        return f -> {
            Object value = getter.apply((SoftFluid)f);
            Object def = getter.apply(DEFAULT_DUMMY);
            return value == null || value.equals(def) ? Optional.empty() : Optional.of(value);
        };
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addFluidSpecificAttributes(Builder builder, class_3611 fluid) {
        void var1_1;
        SoftFluidImpl.addFluidSpecificAttributes(builder, (class_3611)var1_1);
    }

    @ApiStatus.Internal
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Triplet<class_2960, class_2960, Integer> getRenderingData(class_2960 useTexturesFrom) {
        return SoftFluidImpl.getRenderingData(useTexturesFrom);
    }

    public static class Builder {
        private class_2960 stillTexture;
        private class_2960 flowingTexture;
        private class_2561 name = class_2561.method_43471((String)"fluid.moonlight.generic_fluid");
        private int luminosity = 0;
        private int emissivity = 0;
        private int tintColor = -1;
        private TintMethod tintMethod = TintMethod.STILL_AND_FLOWING;
        private FoodProvider food = FoodProvider.EMPTY;
        private FluidContainerList containerList = new FluidContainerList();
        private final List<String> NBTFromItem = new ArrayList<String>();
        private final List<String> equivalentFluids = new ArrayList<String>();
        private boolean isFromData = true;
        private class_2960 useTexturesFrom;

        public Builder(class_2960 stillTexture, class_2960 flowingTexture) {
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public Builder(class_3611 fluid) {
            this(new class_2960("block/water_still"), new class_2960("minecraft:block/water_flowing"));
            this.copyTexturesFrom(Utils.getID(fluid));
            this.addEqFluid(fluid);
            this.isFromData = false;
            SoftFluid.addFluidSpecificAttributes(this, fluid);
        }

        public final Builder textures(class_2960 still, class_2960 flow) {
            this.stillTexture = still;
            this.flowingTexture = flow;
            return this;
        }

        @Deprecated(forRemoval=true)
        public final Builder translationKey(String translationKey) {
            if (translationKey != null) {
                this.name = class_2561.method_43471((String)translationKey);
            }
            return this;
        }

        public final Builder translation(class_2561 component) {
            if (component != null) {
                this.name = component;
            }
            return this;
        }

        public final Builder keepNBTFromItem(String ... NBTkey) {
            this.NBTFromItem.addAll(Arrays.asList(NBTkey));
            return this;
        }

        public final Builder color(int tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public final Builder noTint() {
            this.tintMethod = TintMethod.NO_TINT;
            return this;
        }

        public final Builder tinted() {
            this.tintMethod = TintMethod.STILL_AND_FLOWING;
            return this;
        }

        public final Builder onlyFlowingTinted() {
            this.tintMethod = TintMethod.FLOWING;
            return this;
        }

        public final Builder tintMethod(TintMethod tint) {
            this.tintMethod = tint;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            this.emissivity = luminosity;
            return this;
        }

        public final Builder emissivity(int emissivity) {
            this.emissivity = emissivity;
            return this;
        }

        public final Builder addEqFluid(class_3611 fluid) {
            if (fluid != null && fluid != class_3612.field_15906) {
                this.equivalentFluids.add(class_7923.field_41173.method_10221((Object)fluid).toString());
                class_1792 i = fluid.method_15774();
                if (i != class_1802.field_8162 && i != class_1802.field_8550) {
                    this.bucket(i);
                }
            }
            return this;
        }

        public final Builder copyTexturesFrom(class_2960 fluidRes) {
            this.useTexturesFrom = fluidRes;
            return this;
        }

        public final Builder copyTexturesFrom(String fluidRes) {
            return this.copyTexturesFrom(new class_2960(fluidRes));
        }

        public final Builder containerItem(class_1792 filledItem, class_1792 emptyItem, int itemCapacity) {
            if (filledItem != class_1802.field_8162) {
                this.containerList.add(emptyItem, filledItem, itemCapacity);
            }
            return this;
        }

        public final Builder containerItem(class_1792 filledItem, class_1792 emptyItem, int itemCapacity, class_3414 fillSound, class_3414 emptySound) {
            if (filledItem != class_1802.field_8162) {
                this.containerList.add(emptyItem, filledItem, itemCapacity, fillSound, emptySound);
            }
            return this;
        }

        public final Builder containers(FluidContainerList containerList) {
            this.containerList = containerList;
            return this;
        }

        public final Builder emptyHandContainerItem(class_1792 filledItem, int itemCapacity) {
            if (filledItem != class_1802.field_8162) {
                return this.containerItem(filledItem, class_1802.field_8162, itemCapacity);
            }
            return this;
        }

        public final Builder bottle(class_1792 item) {
            this.containerItem(item, class_1802.field_8469, BOTTLE_COUNT);
            return this;
        }

        public final Builder drink(class_1792 item) {
            return this.bottle(item).food(item, BOTTLE_COUNT);
        }

        public final Builder bucket(class_1792 item) {
            this.containerItem(item, class_1802.field_8550, BUCKET_COUNT, class_3417.field_15126, class_3417.field_14834);
            return this;
        }

        public final Builder bowl(class_1792 item) {
            this.containerItem(item, class_1802.field_8428, BOWL_COUNT);
            return this;
        }

        public final Builder stew(class_1792 item) {
            return this.bowl(item).food(item, BOWL_COUNT);
        }

        public final Builder food(class_1792 item) {
            return this.food(item, 1);
        }

        public final Builder food(class_1792 item, int foodDivider) {
            if (item != null) {
                this.food(FoodProvider.create(item, foodDivider));
            }
            return this;
        }

        public final Builder food(FoodProvider foodProvider) {
            this.food = foodProvider;
            return this;
        }

        public SoftFluid build() {
            return new SoftFluid(this);
        }

        @Deprecated(forRemoval=true)
        public final Builder fromMod(String s) {
            return this;
        }
    }

    public static enum TintMethod implements class_3542
    {
        NO_TINT,
        FLOWING,
        STILL_AND_FLOWING;

        public static final Codec<TintMethod> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean appliesToFlowing() {
            return this == FLOWING || this == STILL_AND_FLOWING;
        }

        public boolean appliesToStill() {
            return this == STILL_AND_FLOWING;
        }

        static {
            CODEC = class_3542.method_28140(TintMethod::values);
        }
    }

    private static class LazyFluidSet {
        protected static final LazyFluidSet EMPTY = new LazyFluidSet(Collections.emptyList());
        private final List<String> keys;
        private final List<class_3611> fluids;
        private final List<class_6862<class_3611>> tags = new ArrayList<class_6862<class_3611>>();

        private LazyFluidSet(List<String> keys) {
            this.keys = keys;
            LinkedHashSet set = new LinkedHashSet();
            for (String key : keys) {
                if (key.startsWith("#")) {
                    this.tags.add((class_6862<class_3611>)class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)new class_2960(key.substring(1))));
                    continue;
                }
                class_7923.field_41173.method_17966(new class_2960(key)).ifPresent(set::add);
            }
            this.fluids = List.of(set.toArray(new class_3611[0]));
        }

        public static LazyFluidSet merge(LazyFluidSet first, LazyFluidSet second) {
            if (first.isEmpty()) {
                return second;
            }
            if (second.isEmpty()) {
                return first;
            }
            ArrayList<String> keys = new ArrayList<String>(first.keys);
            keys.addAll(second.keys);
            return new LazyFluidSet(keys);
        }

        public List<class_3611> getFluids() {
            if (this.tags.isEmpty()) {
                return this.fluids;
            }
            ArrayList<class_3611> list = new ArrayList<class_3611>(this.fluids);
            for (class_6862<class_3611> tag : this.tags) {
                class_7923.field_41173.method_40286(tag).forEach(e -> list.add((class_3611)e.comp_349()));
            }
            return list;
        }

        public boolean isEmpty() {
            return this.getFluids().isEmpty();
        }
    }

    public static enum Capacity implements class_3542
    {
        BOTTLE(1, 1),
        BOWL(2, 1),
        BUCKET(4, 3),
        BLOCK(4, 4);

        public final int value;
        public static final Codec<Capacity> CODEC;
        public static final Codec<Integer> INT_CODEC;

        private Capacity(int forge, int fabric) {
            this.value = PlatHelper.getPlatform().isForge() ? forge : fabric;
        }

        public String method_15434() {
            return this.name().toUpperCase(Locale.ROOT);
        }

        public int getValue() {
            return this.value;
        }

        static {
            CODEC = class_3542.method_28140(Capacity::values);
            INT_CODEC = Codec.either((Codec)Codec.INT, CODEC).xmap(either -> (Integer)either.map(i -> i, Capacity::getValue), Either::left);
        }
    }
}

