/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7876;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DynamicHolder<T>
implements Supplier<T>,
class_6880<T> {
    private static final WeakHashSet<DynamicHolder<?>> REFERENCES = new WeakHashSet();
    private final class_5321<class_2378<T>> registryKey;
    private final class_5321<T> key;
    private final ThreadLocal<class_6880<T>> instance = new ThreadLocal();

    @ApiStatus.Internal
    public static void onDataReload() {
        REFERENCES.forEach(DynamicHolder::invalidateInstance);
    }

    protected DynamicHolder(class_5321<class_2378<T>> registryKey, class_5321<T> key) {
        this.registryKey = registryKey;
        this.key = key;
        REFERENCES.add(this);
    }

    public static <A> DynamicHolder<A> of(String id, class_5321<class_2378<A>> registry) {
        return DynamicHolder.of(new class_2960(id), registry);
    }

    public static <A> DynamicHolder<A> of(class_2960 location, class_5321<class_2378<A>> registry) {
        return new DynamicHolder<A>(registry, class_5321.method_29179(registry, (class_2960)location));
    }

    public static <A> DynamicHolder<A> of(class_5321<A> key) {
        return new DynamicHolder<A>(class_5321.method_29180((class_2960)key.method_41185()), key);
    }

    private void invalidateInstance() {
        this.instance.remove();
    }

    @NotNull
    protected class_6880<T> getInstance() {
        class_6880.class_6883 value = this.instance.get();
        if (value == null) {
            class_5455 r = Utils.hackyGetRegistryAccess();
            class_2378 reg = r.method_30530(this.registryKey);
            try {
                value = reg.method_40290(this.key);
                this.instance.set((class_6880<class_6880.class_6883>)value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get object from registry: " + String.valueOf(this.key) + ".\nCalled from " + String.valueOf(Thread.currentThread()) + ".\nRegistry content was: " + String.valueOf(reg.method_29722().stream().map(b -> ((class_5321)b.getKey()).method_29177()).toList()), e);
            }
        }
        return value;
    }

    public String getRegisteredName() {
        return this.key.method_29177().toString();
    }

    public class_2960 getID() {
        return this.key.method_29177();
    }

    public class_5321<T> getKey() {
        return this.key;
    }

    @Override
    @Deprecated(forRemoval=true)
    @NotNull
    public T get() {
        return (T)this.getInstance().comp_349();
    }

    public T comp_349() {
        return (T)this.getInstance().comp_349();
    }

    public boolean method_40227() {
        return this.getInstance().method_40227();
    }

    public boolean method_40226(class_2960 location) {
        return this.registryKey.method_29177().equals((Object)location);
    }

    public boolean method_40225(class_5321<T> resourceKey) {
        return resourceKey == this.key;
    }

    public boolean method_40224(Predicate<class_5321<T>> predicate) {
        return predicate.test(this.key);
    }

    public boolean is(class_6880<T> other) {
        return other == this || other.method_40230().get() == this.key;
    }

    public boolean method_40220(class_6862<T> tagKey) {
        return this.getInstance().method_40220(tagKey);
    }

    public Stream<class_6862<T>> method_40228() {
        return this.getInstance().method_40228();
    }

    public Either<class_5321<T>, T> method_40229() {
        return Either.left(this.key);
    }

    public Optional<class_5321<T>> method_40230() {
        return Optional.of(this.key);
    }

    public class_6880.class_6882 method_40231() {
        return this.getInstance().method_40231();
    }

    public boolean method_46745(class_7876<T> owner) {
        return this.getInstance().method_46745(owner);
    }
}

