/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.fabric;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class BlockSetInternalImpl {
    private static boolean hasFilledBlockSets = false;
    public static final Map<class_2378<?>, Map<Class<? extends BlockType>, LateRegQueue<?, ?>>> QUEUES = new HashMap();

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }

    public static <T extends BlockType, E> void addDynamicRegistration(BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType, class_2378<E> registry) {
        LateRegQueue r = QUEUES.computeIfAbsent(registry, b -> new LinkedHashMap()).computeIfAbsent(blockType, b -> new LateRegQueue(blockType, registry));
        r.add(registrationFunction);
    }

    public static void initializeBlockSets() {
        BlockSetInternal.initializeBlockSets();
        BlockSetInternal.getRegistries().forEach(BlockTypeRegistry::onItemInit);
        hasFilledBlockSets = true;
    }

    public static <T extends class_2378<?>> void registerDynamicEntries(class_5321<? extends T> id) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_29107(id);
        Map<Class<BlockType>, LateRegQueue<?, ?>> q = QUEUES.get(registry);
        if (q != null) {
            for (Map.Entry<Class<BlockType>, LateRegQueue<?, ?>> e : q.entrySet()) {
                e.getValue().registerEntries();
            }
            QUEUES.remove(registry);
        }
    }

    public static void finish() {
        for (Map<Class<BlockType>, LateRegQueue<?, ?>> q : QUEUES.values()) {
            for (Map.Entry<Class<BlockType>, LateRegQueue<?, ?>> e : q.entrySet()) {
                e.getValue().registerEntries();
            }
        }
        QUEUES.clear();
    }

    private static class LateRegQueue<T extends BlockType, E> {
        final Class<T> blockType;
        final Queue<BlockSetAPI.BlockTypeRegistryCallback<E, T>> queue = new ArrayDeque<BlockSetAPI.BlockTypeRegistryCallback<E, T>>();
        final class_2378<E> registry;

        public LateRegQueue(Class<T> blockType, class_2378<E> registry) {
            this.blockType = blockType;
            this.registry = registry;
        }

        public void add(BlockSetAPI.BlockTypeRegistryCallback<E, T> callback) {
            this.queue.add(callback);
        }

        public void registerEntries() {
            this.queue.forEach(a -> a.accept((n, i) -> class_2378.method_10230(this.registry, (class_2960)n, (Object)i), BlockSetAPI.getBlockSet(this.blockType).getValues()));
        }
    }
}

