/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.config;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.VariantBlacklist;
import com.github.nyuppo.config.VariantSettings;
import com.github.nyuppo.config.VariantWeights;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class ConfigDataLoader
implements SimpleSynchronousResourceReloadListener {
    private final class_2960 SETTINGS_ID = new class_2960("moremobvariants", "settings/settings.json");

    public class_2960 getFabricId() {
        return new class_2960("moremobvariants", "moremobvariants");
    }

    public void method_14491(class_3300 manager) {
        InputStream stream;
        String target;
        MoreMobVariants.LOGGER.info("Reloading config...");
        VariantWeights.clearWeights();
        VariantBlacklist.resetBlacklists();
        for (class_2960 id : manager.method_14488("weights", path -> path.method_12832().endsWith(".json")).keySet()) {
            target = id.method_12832().substring(8, id.method_12832().length() - 5);
            try {
                stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    this.applyWeight(id, new InputStreamReader(stream, StandardCharsets.UTF_8));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                MoreMobVariants.LOGGER.error("Error occured while loading weight config " + id.method_43903(), (Throwable)e);
                VariantWeights.resetWeight(target);
            }
        }
        for (class_2960 id : manager.method_14488("blacklist", path -> path.method_12832().endsWith(".json")).keySet()) {
            target = id.method_12832().substring(10, id.method_12832().length() - 5);
            try {
                stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    this.applyBlacklist(id, new InputStreamReader(stream, StandardCharsets.UTF_8));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                MoreMobVariants.LOGGER.error("Error occured while loading blacklist config " + id.method_43903(), (Throwable)e);
                VariantBlacklist.resetBlacklist(target);
            }
        }
        Optional settings = manager.method_14486(this.SETTINGS_ID);
        if (settings.isPresent()) {
            try (InputStream stream2 = ((class_3298)manager.method_14486(this.SETTINGS_ID).get()).method_14482();){
                this.applySettings(new InputStreamReader(stream2, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                MoreMobVariants.LOGGER.error("Error occured while loading settings config " + this.SETTINGS_ID.method_43903(), (Throwable)e);
                VariantSettings.resetSettings();
            }
        }
        VariantWeights.applyBlacklists();
    }

    private void applyWeight(class_2960 identifier, Reader reader) {
        String target = identifier.method_12832().substring(8, identifier.method_12832().length() - 5);
        JsonElement element = JsonParser.parseReader((Reader)reader);
        if (element.getAsJsonObject().size() != 0 && element.getAsJsonObject().has("weights")) {
            Map weights = element.getAsJsonObject().get("weights").getAsJsonObject().asMap();
            HashMap<String, Integer> weightsConverted = new HashMap<String, Integer>();
            for (Map.Entry entry : weights.entrySet()) {
                weightsConverted.put(entry.getKey().toString(), ((JsonElement)entry.getValue()).getAsInt());
            }
            VariantWeights.setWeight(target, weightsConverted);
        }
    }

    private void applyBlacklist(class_2960 identifier, Reader reader) {
        String target = identifier.method_12832().substring(10, identifier.method_12832().length() - 5);
        JsonElement element = JsonParser.parseReader((Reader)reader);
        if (element.getAsJsonObject().size() != 0 && element.getAsJsonObject().has("blacklist")) {
            JsonArray blacklist = element.getAsJsonObject().get("blacklist").getAsJsonArray();
            for (JsonElement entry : blacklist) {
                VariantBlacklist.blacklistVariant(target, entry.getAsString());
            }
        }
    }

    private void applySettings(Reader reader) {
        JsonElement element = JsonParser.parseReader((Reader)reader);
        if (element.getAsJsonObject().size() != 0) {
            if (element.getAsJsonObject().has("enable_muddy_pigs")) {
                VariantSettings.setEnableMuddyPigs(element.getAsJsonObject().get("enable_muddy_pigs").getAsBoolean());
            }
            if (element.getAsJsonObject().has("wolf_breeding_chance")) {
                VariantSettings.setWolfBreedingChance(element.getAsJsonObject().get("wolf_breeding_chance").getAsInt());
            }
        }
    }
}

