/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_5819;

public class WeightedRandomBag<T> {
    private List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;
    private final class_5819 rand;

    public WeightedRandomBag(class_5819 random) {
        this.rand = random;
    }

    public WeightedRandomBag(class_5819 random, HashMap<T, Integer> weights) {
        this.rand = random;
        for (Map.Entry<T, Integer> entry : weights.entrySet()) {
            this.addEntry(entry.getKey(), entry.getValue().intValue());
        }
    }

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e = new Entry();
        e.object = object;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public T getRandom() {
        double r = this.rand.method_43058() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r)) continue;
            return entry.object;
        }
        return null;
    }

    private class Entry {
        double accumulatedWeight;
        T object;

        private Entry() {
        }
    }
}

