/*
 * Decompiled with CFR 0.152.
 */
package net.trique.mythicupgrades.mixin;

import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.trique.mythicupgrades.item.BaseMythicItem;
import net.trique.mythicupgrades.item.MythicEffectsArmorItem;
import net.trique.mythicupgrades.util.CommonFunctions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    private BaseMythicItem lastUsed;
    @Unique
    private MythicEffectsArmorItem lastWorn;

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void checkItemInHand(CallbackInfo ci) {
        class_1792 class_17922;
        if (!this.method_6118(class_1304.field_6173).method_7960() && (class_17922 = this.method_6118(class_1304.field_6173).method_7909()) instanceof BaseMythicItem) {
            BaseMythicItem item = (BaseMythicItem)class_17922;
            if (!Objects.equals(this.lastUsed, item) || CommonFunctions.checkStatusEffects((class_1309)this, item.getMainHandEffects())) {
                CommonFunctions.addStatusEffects((class_1309)this, item.getMainHandEffects());
            }
            this.lastUsed = item;
        } else if (this.lastUsed != null) {
            CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastUsed.getMainHandEffects());
            this.lastUsed = null;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void applyArmorBuffs(CallbackInfo ci) {
        MythicEffectsArmorItem item;
        class_1792 class_17922;
        class_1799 head = this.method_6118(class_1304.field_6169);
        if (!head.method_7960() && (class_17922 = head.method_7909()) instanceof MythicEffectsArmorItem && CommonFunctions.hasCorrectArmorOn((class_1309)this, (item = (MythicEffectsArmorItem)class_17922).method_7686())) {
            if (!Objects.equals(this.lastWorn, item) || CommonFunctions.checkStatusEffects((class_1309)this, item.getEquipmentBuffs())) {
                CommonFunctions.addStatusEffects((class_1309)this, item.getEquipmentBuffs());
            }
            this.lastWorn = item;
        } else if (this.lastWorn != null) {
            CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastWorn.getEquipmentBuffs());
            this.lastWorn = null;
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    public void applyArmorDebuffs(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 attacker;
        boolean was_damaged = (Boolean)cir.getReturnValue();
        if (was_damaged && (attacker = source.method_5529()) instanceof class_1309) {
            MythicEffectsArmorItem item;
            class_1792 class_17922;
            class_1309 entity = (class_1309)attacker;
            class_1799 head = this.method_6118(class_1304.field_6169);
            if (!head.method_7960() && (class_17922 = head.method_7909()) instanceof MythicEffectsArmorItem && CommonFunctions.hasCorrectArmorOn((class_1309)this, (item = (MythicEffectsArmorItem)class_17922).method_7686())) {
                CommonFunctions.addStatusEffects(entity, item.getEquipmentDebuffs(), (class_1309)this);
            }
        }
    }
}

