/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.ClimbingAnimal;
import com.starfish_studios.naturalist.common.entity.core.EggLayingAnimal;
import com.starfish_studios.naturalist.common.entity.core.HidingAnimal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.EggLayingBreedGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.LayEggGoal;
import com.starfish_studios.naturalist.core.registry.NaturalistBlocks;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistItems;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5761;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Snail
extends ClimbingAnimal
implements GeoEntity,
class_5761,
HidingAnimal,
EggLayingAnimal {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_1856 FOOD_ITEMS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8186});
    private static class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_COLOR;
    private static final class_2940<Boolean> HAS_EGG;
    private static final class_2940<Boolean> LAYING_EGG;
    int layEggCounter;

    public Snail(class_1299<? extends class_1429> type, class_1937 level) {
        super(type, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 2.0).method_26868(class_5134.field_23719, (double)0.1f);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, new EggLayingBreedGoal<Snail>(this, 1.0));
        this.field_6201.method_6277(1, new LayEggGoal<Snail>(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new SnailStrollGoal((class_1314)this, 0.9, 0.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(this.canHide() ? strength / 4.0 : strength, x, z);
    }

    public boolean method_5643(class_1282 source, float amount) {
        return super.method_5643(source, this.canHide() ? amount * 0.8f : amount);
    }

    public boolean method_6094() {
        return true;
    }

    @Override
    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    @Override
    public void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    @Override
    public class_2248 getEggBlock() {
        return NaturalistBlocks.SNAIL_EGGS.get();
    }

    @Override
    public class_6862<class_2248> getEggLayableBlockTag() {
        return NaturalistTags.BlockTags.ALLIGATOR_EGG_LAYABLE_ON;
    }

    @Override
    public boolean isLayingEgg() {
        return (Boolean)this.field_6011.method_12789(LAYING_EGG);
    }

    @Override
    public void setLayingEgg(boolean isLayingEgg) {
        this.layEggCounter = isLayingEgg ? 1 : 0;
        this.field_6011.method_12778(LAYING_EGG, (Object)isLayingEgg);
    }

    @Override
    public int getLayEggCounter() {
        return this.layEggCounter;
    }

    @Override
    public void setLayEggCounter(int layEggCounter) {
        this.layEggCounter = layEggCounter;
    }

    public boolean method_6482() {
        return super.method_6482() && !this.hasEgg();
    }

    public float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.3f;
    }

    @Override
    protected float getClimbSpeedMultiplier() {
        return 0.5f;
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return (class_1296)NaturalistEntityTypes.SNAIL.get().method_5883((class_1937)level);
    }

    public boolean method_6481(@NotNull class_1799 stack) {
        return FOOD_ITEMS.method_8093(stack);
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_6453();
    }

    public void method_6091(class_243 vec3) {
        if (this.canHide()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            vec3 = vec3.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(vec3);
    }

    public void method_6007() {
        if (this.canHide() || this.method_6062()) {
            this.field_6282 = false;
            this.field_6212 = 0.0f;
            this.field_6250 = 0.0f;
        }
        super.method_6007();
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FROM_BUCKET, (Object)false);
        this.field_6011.method_12784(DATA_COLOR, (Object)Color.BROWN.getId());
        this.field_6011.method_12784(HAS_EGG, (Object)false);
        this.field_6011.method_12784(LAYING_EGG, (Object)false);
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10556("FromBucket", this.method_6453());
        pCompound.method_10567("Color", (byte)this.getSnailColor().getId());
        pCompound.method_10556("HasEgg", this.hasEgg());
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.method_6454(pCompound.method_10577("FromBucket"));
        this.setSnailColor(Color.BY_ID[pCompound.method_10550("Color")]);
        this.setHasEgg(pCompound.method_10577("HasEgg"));
    }

    public Color getSnailColor() {
        return Color.BY_ID[(Integer)this.field_6011.method_12789(DATA_COLOR)];
    }

    public void setSnailColor(Color color) {
        this.field_6011.method_12778(DATA_COLOR, (Object)color.getId());
    }

    public class_1767 getColor() {
        return class_1767.method_7791((int)((Integer)this.field_6011.method_12789(DATA_COLOR)));
    }

    public void setColor(class_1767 color) {
        this.field_6011.method_12778(DATA_COLOR, (Object)color.method_7789());
    }

    public class_1269 method_5992(class_1657 pPlayer, class_1268 pHand) {
        class_1769 dyeItem;
        class_1767 dyeColor;
        class_1799 itemStack = pPlayer.method_5998(pHand);
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1769 && (dyeColor = (dyeItem = (class_1769)item).method_7802()) != this.getColor()) {
            this.setColor(dyeColor);
            if (!pPlayer.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return Snail.bucketMobPickup(pPlayer, pHand, this).orElse(super.method_5992(pPlayer, pHand));
    }

    static <T extends class_1309> Optional<class_1269> bucketMobPickup(class_1657 player, class_1268 hand, T entity) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == class_1802.field_8550 && entity.method_5805()) {
            entity.method_5783(((class_5761)entity).method_35171(), 1.0f, 1.0f);
            class_1799 bucketStack = ((class_5761)entity).method_6452();
            ((class_5761)entity).method_6455(bucketStack);
            class_1799 resultStack = class_5328.method_30270((class_1799)stack, (class_1657)player, (class_1799)bucketStack, (boolean)false);
            player.method_6122(hand, resultStack);
            class_1937 level = entity.method_37908();
            if (!level.field_9236) {
                class_174.field_1208.method_8932((class_3222)player, bucketStack);
            }
            entity.method_31472();
            return Optional.of(class_1269.method_29236((boolean)level.field_9236));
        }
        return Optional.empty();
    }

    public void method_6455(class_1799 stack) {
        class_2487 compoundTag = stack.method_7948();
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        compoundTag.method_10569("Color", this.getSnailColor().getId());
    }

    public void method_35170(class_2487 tag) {
        class_5761.method_35168((class_1308)this, (class_2487)tag);
        int i = tag.method_10550("Color");
        if (i >= 0 && i < Color.BY_ID.length) {
            this.setSnailColor(Color.BY_ID[i]);
        }
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)NaturalistItems.SNAIL_BUCKET.get());
    }

    public class_3414 method_35171() {
        return NaturalistSoundEvents.BUCKET_FILL_SNAIL.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return NaturalistSoundEvents.SNAIL_CRUSH.get();
    }

    @Override
    public boolean canHide() {
        List players = this.method_37908().method_18464(class_4051.method_36626().method_18418(5.0).method_18420(class_1301.field_6156::test), (class_1309)this, this.method_5829().method_1009(5.0, 3.0, 5.0));
        return !players.isEmpty();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Snail> PlayState predicate(AnimationState<E> event) {
        if (this.canHide()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("retreat"));
        } else if (this.method_18798().method_37268() > 1.0E-6) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("crawl"));
            event.getController().setAnimationSpeed((double)0.6f);
        } else if (this.isClimbing()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("climb"));
            event.getController().setAnimationSpeed((double)0.6f);
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            event.getController().setAnimationSpeed((double)0.4f);
        }
        return PlayState.CONTINUE;
    }

    private void soundListener(SoundKeyframeEvent<Snail> event) {
        Snail snail = (Snail)event.getAnimatable();
        if (snail.method_37908().field_9236) {
            if (event.getKeyframeData().getSound().equals("forward")) {
                snail.method_37908().method_8486(snail.method_23317(), snail.method_23318(), snail.method_23321(), NaturalistSoundEvents.SNAIL_FORWARD.get(), snail.method_5634(), 0.5f, 1.0f, false);
            }
            if (event.getKeyframeData().getSound().equals("back")) {
                snail.method_37908().method_8486(snail.method_23317(), snail.method_23318(), snail.method_23321(), NaturalistSoundEvents.SNAIL_BACK.get(), snail.method_5634(), 0.5f, 1.0f, false);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{controller});
    }

    static {
        HAS_EGG = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13323);
        LAYING_EGG = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13323);
        DATA_COLOR = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13327);
        FROM_BUCKET = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13323);
    }

    static class SnailStrollGoal
    extends class_1394 {
        public SnailStrollGoal(class_1314 pMob, double pSpeedModifier, float pProbability) {
            super(pMob, pSpeedModifier, pProbability);
            this.field_6565 = true;
            this.field_6564 = 1;
        }
    }

    public static enum Color {
        WHITE(0, "white", true),
        ORANGE(1, "orange", true),
        MAGENTA(2, "magenta", true),
        LIGHT_BLUE(3, "light_blue", true),
        YELLOW(4, "yellow", true),
        LIME(5, "lime", true),
        PINK(6, "pink", true),
        GRAY(7, "gray", true),
        LIGHT_GRAY(8, "light_gray", true),
        CYAN(9, "cyan", true),
        PURPLE(10, "purple", true),
        BLUE(11, "blue", true),
        BROWN(12, "brown", true),
        GREEN(13, "green", true),
        RED(14, "red", true),
        BLACK(15, "black", true);

        public static final Color[] BY_ID;
        private final int id;
        private final String name;

        private Color(int j, String string2, boolean bl) {
            this.id = j;
            this.name = string2;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Color getTypeById(int id) {
            for (Color type : Color.values()) {
                if (type.id != id) continue;
                return type;
            }
            return BROWN;
        }

        static {
            BY_ID = (Color[])Arrays.stream(Color.values()).sorted(Comparator.comparingInt(Color::getId)).toArray(Color[]::new);
        }
    }
}

