/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.fabric;

import com.google.common.base.Preconditions;
import com.starfish_studios.naturalist.Naturalist;
import com.starfish_studios.naturalist.common.entity.Alligator;
import com.starfish_studios.naturalist.common.entity.Bear;
import com.starfish_studios.naturalist.common.entity.Bird;
import com.starfish_studios.naturalist.common.entity.Boar;
import com.starfish_studios.naturalist.common.entity.Butterfly;
import com.starfish_studios.naturalist.common.entity.Caterpillar;
import com.starfish_studios.naturalist.common.entity.Catfish;
import com.starfish_studios.naturalist.common.entity.Deer;
import com.starfish_studios.naturalist.common.entity.Dragonfly;
import com.starfish_studios.naturalist.common.entity.Duck;
import com.starfish_studios.naturalist.common.entity.Elephant;
import com.starfish_studios.naturalist.common.entity.Firefly;
import com.starfish_studios.naturalist.common.entity.Giraffe;
import com.starfish_studios.naturalist.common.entity.Hippo;
import com.starfish_studios.naturalist.common.entity.Lion;
import com.starfish_studios.naturalist.common.entity.Lizard;
import com.starfish_studios.naturalist.common.entity.LizardTail;
import com.starfish_studios.naturalist.common.entity.Rhino;
import com.starfish_studios.naturalist.common.entity.Snail;
import com.starfish_studios.naturalist.common.entity.Snake;
import com.starfish_studios.naturalist.common.entity.Tortoise;
import com.starfish_studios.naturalist.common.entity.Vulture;
import com.starfish_studios.naturalist.core.registry.NaturalistBlocks;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistItems;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import com.starfish_studios.naturalist.core.registry.fabric.NaturalistConfigFabric;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1422;
import net.minecraft.class_1496;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class NaturalistFabric
implements ModInitializer {
    public void onInitialize() {
        AutoConfig.register(NaturalistConfigFabric.class, GsonConfigSerializer::new);
        Naturalist.init();
        this.addSpawns();
        this.addFeatures();
        this.registerEntityAttributes();
        Naturalist.registerBrewingRecipes();
        Naturalist.registerCompostables();
        Naturalist.registerSpawnPlacements();
        Naturalist.registerDispenserBehaviors();
        NaturalistBlocks.addAllToCreativeTab();
        NaturalistItems.addAllToCreativeTab();
    }

    public void addFeatures() {
        BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9471), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeatureKey("patch_cattail"));
        BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9471), (class_2893.class_2895)class_2893.class_2895.field_13174, this.getPlacedFeatureKey("swamp_mud"));
        BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9471), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeatureKey("patch_duckweed"));
        BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9449), (class_2893.class_2895)class_2893.class_2895.field_25186, this.getPlacedFeatureKey("savanna_lake"));
    }

    private class_5321<class_6796> getPlacedFeatureKey(String key) {
        return class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("naturalist", key));
    }

    void registerEntityAttributes() {
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.SNAIL.get(), (class_5132.class_5133)Snail.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BEAR.get(), (class_5132.class_5133)Bear.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BUTTERFLY.get(), (class_5132.class_5133)Butterfly.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.FIREFLY.get(), (class_5132.class_5133)Firefly.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.SNAKE.get(), (class_5132.class_5133)Snake.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CORAL_SNAKE.get(), (class_5132.class_5133)Snake.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.RATTLESNAKE.get(), (class_5132.class_5133)Snake.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.DEER.get(), (class_5132.class_5133)Deer.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BLUEJAY.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CANARY.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CARDINAL.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.ROBIN.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.FINCH.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.SPARROW.get(), (class_5132.class_5133)Bird.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CATERPILLAR.get(), (class_5132.class_5133)Caterpillar.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.RHINO.get(), (class_5132.class_5133)Rhino.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.LION.get(), (class_5132.class_5133)Lion.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.ELEPHANT.get(), (class_5132.class_5133)Elephant.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.ZEBRA.get(), (class_5132.class_5133)class_1496.method_26899());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.GIRAFFE.get(), (class_5132.class_5133)Giraffe.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.HIPPO.get(), (class_5132.class_5133)Hippo.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.VULTURE.get(), (class_5132.class_5133)Vulture.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BOAR.get(), (class_5132.class_5133)Boar.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.DRAGONFLY.get(), (class_5132.class_5133)Dragonfly.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.CATFISH.get(), (class_5132.class_5133)Catfish.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.ALLIGATOR.get(), (class_5132.class_5133)Alligator.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.BASS.get(), (class_5132.class_5133)class_1422.method_26879());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.LIZARD.get(), (class_5132.class_5133)Lizard.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.LIZARD_TAIL.get(), (class_5132.class_5133)LizardTail.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.TORTOISE.get(), (class_5132.class_5133)Tortoise.createAttributes());
        FabricDefaultAttributeRegistry.register(NaturalistEntityTypes.DUCK.get(), (class_5132.class_5133)Duck.createAttributes());
    }

    void addSpawns() {
        NaturalistConfigFabric config = (NaturalistConfigFabric)AutoConfig.getConfigHolder(NaturalistConfigFabric.class).getConfig();
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BEAR, class_1311.field_6294, NaturalistEntityTypes.BEAR.get(), config.bearSpawnWeight, 1, 2);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_DEER, class_1311.field_6294, NaturalistEntityTypes.DEER.get(), config.deerSpawnWeight, 1, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_SNAIL, class_1311.field_6294, NaturalistEntityTypes.SNAIL.get(), config.snailSpawnWeight, 1, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_FIREFLY, class_1311.field_6303, NaturalistEntityTypes.FIREFLY.get(), config.fireflySpawnWeight, 2, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BUTTERFLY, class_1311.field_6294, NaturalistEntityTypes.BUTTERFLY.get(), config.butterflySpawnWeight, 3, 5);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_SNAKE, class_1311.field_6294, NaturalistEntityTypes.SNAKE.get(), config.snakeSpawnWeight, 1, 1);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_RATTLESNAKE, class_1311.field_6294, NaturalistEntityTypes.RATTLESNAKE.get(), config.rattlesnakeSpawnWeight, 1, 1);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_CORAL_SNAKE, class_1311.field_6294, NaturalistEntityTypes.CORAL_SNAKE.get(), config.coralSnakeSpawnWeight, 1, 1);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BLUEJAY, class_1311.field_6294, NaturalistEntityTypes.BLUEJAY.get(), config.bluejaySpawnWeight, 1, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_CANARY, class_1311.field_6294, NaturalistEntityTypes.CANARY.get(), config.canarySpawnWeight, 1, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_CARDINAL, class_1311.field_6294, NaturalistEntityTypes.CARDINAL.get(), config.cardinalSpawnWeight, 1, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_ROBIN, class_1311.field_6294, NaturalistEntityTypes.ROBIN.get(), config.robinSpawnWeight, 1, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_FINCH, class_1311.field_6294, NaturalistEntityTypes.FINCH.get(), config.finchSpawnWeight, 1, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_SPARROW, class_1311.field_6294, NaturalistEntityTypes.SPARROW.get(), config.sparrowSpawnWeight, 1, 4);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36517, class_1311.field_6294, class_1299.field_6140, config.forestRabbitSpawnWeight, 2, 3);
        this.addMobSpawn((class_6862<class_1959>)class_6908.field_36517, class_1311.field_6294, class_1299.field_17943, config.forestFoxSpawnWeight, 2, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_RHINO, class_1311.field_6294, NaturalistEntityTypes.RHINO.get(), config.rhinoSpawnWeight, 1, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_LION, class_1311.field_6294, NaturalistEntityTypes.LION.get(), config.lionSpawnWeight, 3, 5);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_ELEPHANT, class_1311.field_6294, NaturalistEntityTypes.ELEPHANT.get(), config.elephantSpawnWeight, 2, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_ZEBRA, class_1311.field_6294, NaturalistEntityTypes.ZEBRA.get(), config.zebraSpawnWeight, 2, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_GIRAFFE, class_1311.field_6294, NaturalistEntityTypes.GIRAFFE.get(), config.giraffeSpawnWeight, 2, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_HIPPO, class_1311.field_6294, NaturalistEntityTypes.HIPPO.get(), config.hippoSpawnWeight, 3, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_VULTURE, class_1311.field_6294, NaturalistEntityTypes.VULTURE.get(), config.vultureSpawnWeight, 2, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BOAR, class_1311.field_6294, NaturalistEntityTypes.BOAR.get(), config.boarSpawnWeight, 4, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_DRAGONFLY, class_1311.field_6294, NaturalistEntityTypes.DRAGONFLY.get(), config.dragonflySpawnWeight, 2, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_CATFISH, class_1311.field_24460, NaturalistEntityTypes.CATFISH.get(), config.catfishSpawnWeight, 1, 1);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_ALLIGATOR, class_1311.field_6294, NaturalistEntityTypes.ALLIGATOR.get(), config.alligatorSpawnWeight, 1, 2);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_BASS, class_1311.field_24460, NaturalistEntityTypes.BASS.get(), config.bassSpawnWeight, 4, 4);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_LIZARD, class_1311.field_6294, NaturalistEntityTypes.LIZARD.get(), config.lizardSpawnWeight, 1, 2);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_TORTOISE, class_1311.field_6294, NaturalistEntityTypes.TORTOISE.get(), config.tortoiseSpawnWeight, 1, 3);
        this.addMobSpawn(NaturalistTags.Biomes.HAS_DUCK, class_1311.field_6294, NaturalistEntityTypes.DUCK.get(), config.duckSpawnWeight, 1, 3);
        if (config.removeSavannaFarmAnimals) {
            this.removeSpawn((class_6862<class_1959>)class_6908.field_37392, List.of(class_1299.field_6115, class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        }
        if (config.removeSwampFarmAnimals) {
            this.removeSpawn((class_6862<class_1959>)ConventionalBiomeTags.SWAMP, List.of(class_1299.field_6115, class_1299.field_6093, class_1299.field_6132, class_1299.field_6085));
        }
        if (config.removeForestPigs) {
            this.removeSpawn((class_6862<class_1959>)ConventionalBiomeTags.FOREST, List.of(class_1299.field_6093));
        }
    }

    void addMobSpawn(class_6862<class_1959> tag, class_1311 mobCategory, class_1299<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        BiomeModifications.addSpawn(biomeSelector -> biomeSelector.hasTag(tag), (class_1311)mobCategory, entityType, (int)weight, (int)minGroupSize, (int)maxGroupSize);
    }

    void removeSpawn(class_6862<class_1959> tag, List<class_1299<?>> entityTypes) {
        entityTypes.forEach(entityType -> {
            class_2960 id = class_7923.field_41177.method_10221(entityType);
            Preconditions.checkState((boolean)class_7923.field_41177.method_10250(id), (String)"Unregistered entity type: %s", (Object)entityType);
            BiomeModifications.create((class_2960)id).add(ModificationPhase.REMOVALS, biomeSelector -> biomeSelector.hasTag(tag), context -> context.getSpawnSettings().removeSpawnsOfEntityType(entityType));
        });
    }
}

