/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.Platform;
import com.bawnorton.neruina.annotation.ConditionalMixin;
import com.bawnorton.neruina.annotation.VersionedMixin;
import com.bawnorton.neruina.version.VersionString;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class NeruinaMixinPlugin
implements IMixinConfigPlugin {
    public static boolean testClass(String className) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)className).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            boolean shouldApply = true;
            for (AnnotationNode node : annotationNodes) {
                String mcVersion;
                if (node.desc.equals(Type.getDescriptor(ConditionalMixin.class))) {
                    List modids = (List)Annotations.getValue((AnnotationNode)node, (String)"modids");
                    boolean applyIfPresent = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"applyIfPresent", (Object)Boolean.TRUE);
                    if (NeruinaMixinPlugin.anyModsLoaded(modids)) {
                        Neruina.LOGGER.debug("NeruinaMixinPlugin: " + className + " is" + (applyIfPresent ? " " : " not ") + "being applied because " + modids + " are loaded");
                        shouldApply = applyIfPresent;
                    } else {
                        Neruina.LOGGER.debug("NeruinaMixinPlugin: " + className + " is" + (!applyIfPresent ? " " : " not ") + "being applied because " + modids + " are not loaded");
                        boolean bl = shouldApply = !applyIfPresent;
                    }
                }
                if (!shouldApply) {
                    return false;
                }
                if (!node.desc.equals(Type.getDescriptor(VersionedMixin.class))) continue;
                String versionString = (String)Annotations.getValue((AnnotationNode)node, (String)"value");
                VersionString version = new VersionString(versionString);
                if (version.isVersionValid(mcVersion = Platform.getMinecraftVersion())) {
                    Neruina.LOGGER.debug("NeruinaMixinPlugin: " + className + " is being applied because " + mcVersion + " is " + versionString);
                    continue;
                }
                Neruina.LOGGER.debug("NeruinaMixinPlugin: " + className + " is not being applied because " + mcVersion + " is not " + versionString);
                shouldApply = false;
            }
            return shouldApply;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean anyModsLoaded(List<String> modids) {
        for (String modid : modids) {
            if (!Platform.isModLoaded(modid)) continue;
            return true;
        }
        return false;
    }

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetName, String className) {
        return NeruinaMixinPlugin.testClass(className);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

