/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims.player;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.class_1923;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.PlayerChunkClaim;

public final class PlayerClaimPosList
implements IPlayerClaimPosList {
    private final PlayerChunkClaim claimState;
    private final LongSet positions;

    private PlayerClaimPosList(PlayerChunkClaim claimState, LongSet positions) {
        this.claimState = claimState;
        this.positions = positions;
    }

    @Override
    @Nonnull
    public PlayerChunkClaim getClaimState() {
        return this.claimState;
    }

    @Override
    @Nonnull
    public Stream<class_1923> getStream() {
        return this.positions.longStream().mapToObj(key -> new class_1923(PlayerChunkClaim.getXFromLongCoordinates(key), PlayerChunkClaim.getZFromLongCoordinates(key)));
    }

    @Override
    public int getCount() {
        return this.positions.size();
    }

    public boolean remove(int x, int z) {
        long key = PlayerChunkClaim.getLongCoordinatesFor(x, z);
        return this.positions.remove(key);
    }

    public void add(int x, int z) {
        long key = PlayerChunkClaim.getLongCoordinatesFor(x, z);
        this.positions.add(key);
    }

    public static final class Builder {
        private PlayerChunkClaim claim;

        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public Builder setClaim(PlayerChunkClaim claim) {
            this.claim = claim;
            return this;
        }

        public PlayerClaimPosList build() {
            if (this.claim == null) {
                throw new IllegalStateException();
            }
            return new PlayerClaimPosList(this.claim, (LongSet)new LongOpenHashSet());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

