/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimLimitsPacket
extends LazyPacket<ClientboundClaimLimitsPacket> {
    public static final LazyPacket.Encoder<ClientboundClaimLimitsPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final int loadingClaimCount;
    private final int loadingForceloadCount;
    private final int claimLimit;
    private final int forceloadLimit;
    private final int maxClaimDistance;
    private final boolean alwaysUseLoadingValues;

    public ClientboundClaimLimitsPacket(int loadingClaimCount, int loadingForceloadCount, int claimLimit, int forceloadLimit, int maxClaimDistance, boolean alwaysUseLoadingValues) {
        this.loadingClaimCount = loadingClaimCount;
        this.loadingForceloadCount = loadingForceloadCount;
        this.claimLimit = claimLimit;
        this.forceloadLimit = forceloadLimit;
        this.maxClaimDistance = maxClaimDistance;
        this.alwaysUseLoadingValues = alwaysUseLoadingValues;
    }

    @Override
    protected void writeOnPrepare(class_2540 u) {
        class_2487 tag = new class_2487();
        tag.method_10569("cc", this.loadingClaimCount);
        tag.method_10569("fc", this.loadingForceloadCount);
        tag.method_10569("cl", this.claimLimit);
        tag.method_10569("fl", this.forceloadLimit);
        tag.method_10569("d", this.maxClaimDistance);
        tag.method_10556("a", this.alwaysUseLoadingValues);
        u.method_10794(tag);
    }

    @Override
    protected Function<class_2540, ClientboundClaimLimitsPacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<class_2540, ClientboundClaimLimitsPacket> {
        @Override
        public ClientboundClaimLimitsPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 2048) {
                    return null;
                }
                class_2487 tag = input.method_30617();
                if (tag == null) {
                    return null;
                }
                int loadingClaimCount = tag.method_10550("cc");
                int loadingForceloadCount = tag.method_10550("fc");
                int claimLimit = tag.method_10550("cl");
                int forceloadLimit = tag.method_10550("fl");
                int maxClaimDistance = tag.method_10550("d");
                boolean alwaysUseLoadingValues = tag.method_10577("a");
                return new ClientboundClaimLimitsPacket(loadingClaimCount, loadingForceloadCount, claimLimit, forceloadLimit, maxClaimDistance, alwaysUseLoadingValues);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundClaimLimitsPacket> {
        @Override
        public void handle(ClientboundClaimLimitsPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimLimits(t.loadingClaimCount, t.loadingForceloadCount, t.claimLimit, t.forceloadLimit, t.maxClaimDistance, t.alwaysUseLoadingValues);
        }
    }
}

