/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.data.ServerPlayerData;

public class ServerboundOtherPlayerConfigPacket
extends PlayerConfigPacket {
    private final String ownerName;

    public ServerboundOtherPlayerConfigPacket(String ownerName) {
        this.ownerName = ownerName;
    }

    public static class ServerHandler
    implements BiConsumer<ServerboundOtherPlayerConfigPacket, class_3222> {
        @Override
        public void accept(ServerboundOtherPlayerConfigPacket t, class_3222 serverPlayer) {
            if (!serverPlayer.method_5687(2)) {
                OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to requesting another player's config! Name: " + serverPlayer.method_7334().getName());
                return;
            }
            serverPlayer.method_5682().method_3793().method_14515(t.ownerName).ifPresent(gp -> {
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverPlayer.method_5682());
                IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
                IPlayerConfig config = playerConfigs.getLoadedConfig(gp.getId());
                ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(serverPlayer);
                playerData.getConfigSyncSpreadoutTask().addConfigToSync(config);
            });
        }
    }

    public static class Codec
    implements BiConsumer<ServerboundOtherPlayerConfigPacket, class_2540>,
    Function<class_2540, ServerboundOtherPlayerConfigPacket> {
        @Override
        public ServerboundOtherPlayerConfigPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                class_2487 nbt = input.method_30617();
                if (nbt == null) {
                    return null;
                }
                String ownerName = nbt.method_10558("ownerName");
                if (ownerName.isEmpty() || !ownerName.matches("^[a-zA-Z0-9_]+$")) {
                    return null;
                }
                return new ServerboundOtherPlayerConfigPacket(ownerName);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(ServerboundOtherPlayerConfigPacket t, class_2540 u) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("ownerName", t.ownerName);
            u.method_10794(nbt);
        }
    }
}

