/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.parties.party;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import xaero.pac.common.parties.party.IParty;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.util.linked.LinkedChain;

public abstract class Party
implements IParty<PartyMember, PartyInvite, PartyAlly> {
    protected PartyMember owner;
    private final UUID id;
    private final List<PartyMember> sortedStaffInfo;
    private final Map<UUID, PartyMember> memberInfo;
    private final LinkedChain<PartyMember> linkedMemberInfo;
    private final Map<UUID, PartyInvite> invitedPlayers;
    private final LinkedChain<PartyInvite> linkedInvitedPlayers;
    private final Map<UUID, PartyAlly> allyParties;
    private final LinkedChain<PartyAlly> linkedAllyParties;

    protected Party(PartyMember owner, UUID id, List<PartyMember> staffInfo, Map<UUID, PartyMember> memberInfo, LinkedChain<PartyMember> linkedMemberInfo, Map<UUID, PartyInvite> invitedPlayers, LinkedChain<PartyInvite> linkedInvitedPlayers, Map<UUID, PartyAlly> allyParties, LinkedChain<PartyAlly> linkedAllyParties) {
        this.owner = owner;
        this.id = id;
        this.sortedStaffInfo = staffInfo;
        this.memberInfo = memberInfo;
        this.linkedMemberInfo = linkedMemberInfo;
        this.invitedPlayers = invitedPlayers;
        this.linkedInvitedPlayers = linkedInvitedPlayers;
        this.allyParties = allyParties;
        this.linkedAllyParties = linkedAllyParties;
    }

    @Override
    public boolean changeOwner(UUID newOwnerId, String newOwnerUsername) {
        PartyMember oldOwner = this.owner;
        if (oldOwner.getUUID().equals(newOwnerId)) {
            return false;
        }
        PartyMember newOwnerOldInfo = this.getMemberInfo(newOwnerId);
        if (newOwnerOldInfo == null) {
            return false;
        }
        this.memberInfo.remove(newOwnerId);
        this.linkedMemberInfo.remove(newOwnerOldInfo);
        this.owner = new PartyMember(newOwnerId, true);
        this.owner.setUsername(newOwnerUsername);
        this.owner.setRank(PartyMemberRank.ADMIN);
        PartyMember oldOwnerConverted = new PartyMember(oldOwner.getUUID(), false);
        oldOwnerConverted.setRank(PartyMemberRank.ADMIN);
        oldOwnerConverted.setUsername(oldOwner.getUsername());
        oldOwner.onDestroyed();
        this.removeStaff(oldOwner);
        this.removeStaff(newOwnerOldInfo);
        this.addStaff(oldOwnerConverted);
        this.addStaff(this.owner);
        this.memberInfo.put(oldOwnerConverted.getUUID(), oldOwnerConverted);
        this.linkedMemberInfo.add(oldOwnerConverted);
        return true;
    }

    @Override
    public PartyMember addMember(UUID memberUUID, PartyMemberRank rank, String playerUsername) {
        return this.addMemberClean(memberUUID, rank, playerUsername);
    }

    private boolean addStaff(PartyMember m) {
        int binarySearch = Collections.binarySearch(this.sortedStaffInfo, m);
        if (binarySearch < 0) {
            this.sortedStaffInfo.add(-binarySearch - 1, m);
            return true;
        }
        return false;
    }

    private boolean removeStaff(PartyMember m) {
        int binarySearch = Collections.binarySearch(this.sortedStaffInfo, m);
        if (binarySearch >= 0) {
            this.sortedStaffInfo.remove(binarySearch);
            return true;
        }
        return false;
    }

    public PartyMember addMemberClean(UUID memberUUID, PartyMemberRank rank, String playerUsername) {
        if (this.owner.getUUID().equals(memberUUID)) {
            return null;
        }
        if (this.memberInfo.containsKey(memberUUID)) {
            return null;
        }
        this.removeInvitedPlayer(memberUUID);
        PartyMember m = new PartyMember(memberUUID, false);
        if (rank == null) {
            rank = PartyMemberRank.MEMBER;
        }
        m.setRank(rank);
        m.setUsername(playerUsername);
        if (rank != PartyMemberRank.MEMBER && !this.addStaff(m)) {
            return null;
        }
        this.memberInfo.put(memberUUID, m);
        this.linkedMemberInfo.add(m);
        return m;
    }

    @Override
    public PartyMember removeMember(UUID memberUUID) {
        if (this.owner.getUUID().equals(memberUUID)) {
            return null;
        }
        if (!this.memberInfo.containsKey(memberUUID)) {
            return null;
        }
        PartyMember m = this.memberInfo.remove(memberUUID);
        this.linkedMemberInfo.remove(m);
        if (m.getRank() != PartyMemberRank.MEMBER) {
            this.removeStaff(m);
        }
        return m;
    }

    @Override
    public PartyMember getMemberInfo(@Nonnull UUID memberUUID) {
        if (this.owner.getUUID().equals(memberUUID)) {
            return this.owner;
        }
        return this.memberInfo.get(memberUUID);
    }

    @Override
    public void addAllyParty(UUID partyId) {
        this.addAllyPartyClean(partyId);
    }

    public void addAllyPartyClean(UUID partyId) {
        if (!this.allyParties.containsKey(partyId)) {
            PartyAlly ally = new PartyAlly(partyId);
            this.allyParties.put(partyId, ally);
            this.linkedAllyParties.add(ally);
        }
    }

    @Override
    public void removeAllyParty(UUID partyId) {
        PartyAlly ally = this.allyParties.remove(partyId);
        if (ally != null) {
            this.linkedAllyParties.remove(ally);
        }
    }

    @Override
    public boolean isAlly(@Nonnull UUID partyId) {
        return this.allyParties.containsKey(partyId);
    }

    public PartyAlly getAlly(@Nonnull UUID partyId) {
        return this.allyParties.get(partyId);
    }

    @Override
    public PartyInvite invitePlayer(UUID playerUUID, String playerUsername) {
        return this.invitePlayerClean(playerUUID, playerUsername);
    }

    public PartyInvite invitePlayerClean(UUID playerUUID, String playerUsername) {
        if (this.isInvited(playerUUID)) {
            return null;
        }
        PartyInvite playerInfo = new PartyInvite(playerUUID);
        playerInfo.setUsername(playerUsername);
        this.invitedPlayers.put(playerUUID, playerInfo);
        return playerInfo;
    }

    @Override
    public PartyInvite uninvitePlayer(UUID playerUUID) {
        if (!this.isInvited(playerUUID)) {
            return null;
        }
        return this.removeInvitedPlayer(playerUUID);
    }

    @Override
    public boolean isInvited(@Nonnull UUID playerId) {
        return this.invitedPlayers.containsKey(playerId);
    }

    protected PartyInvite removeInvitedPlayer(UUID playerId) {
        return this.invitedPlayers.remove(playerId);
    }

    @Override
    @Nonnull
    public Stream<PartyMember> getMemberInfoStream() {
        return Stream.concat(Stream.of(this.owner), this.memberInfo.values().stream());
    }

    @Override
    @Nonnull
    public Stream<PartyMember> getStaffInfoStream() {
        return this.sortedStaffInfo.stream();
    }

    @Override
    @Nonnull
    public Stream<PartyMember> getNonStaffInfoStream() {
        return this.memberInfo.values().stream().filter(mi -> mi.getRank() == PartyMemberRank.MEMBER);
    }

    @Override
    @Nonnull
    public Stream<PartyInvite> getInvitedPlayersStream() {
        return this.invitedPlayers.values().stream();
    }

    @Override
    @Nonnull
    public Stream<PartyAlly> getAllyPartiesStream() {
        return this.allyParties.values().stream();
    }

    public Iterator<PartyMember> getPartyMemberIterator() {
        return this.linkedMemberInfo.iterator();
    }

    public Iterator<PartyInvite> getPartyInviteIterator() {
        return this.linkedInvitedPlayers.iterator();
    }

    public Iterator<PartyAlly> getAllyPartiesIterator() {
        return this.linkedAllyParties.iterator();
    }

    @Override
    @Nonnull
    public PartyMember getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public String toString() {
        return String.format("party(owner: %s, id: %s)", this.owner.getUsername(), this.id.toString());
    }

    @Override
    @Nonnull
    public String getDefaultName() {
        return String.format("%s's Party", this.owner.getUsername());
    }

    @Override
    public int getMemberCount() {
        return this.memberInfo.size() + 1;
    }

    @Override
    public int getAllyCount() {
        return this.allyParties.size();
    }

    @Override
    public int getInviteCount() {
        return this.invitedPlayers.size();
    }

    @Override
    public boolean setRank(@Nonnull PartyMember member, @Nonnull PartyMemberRank rank) {
        if (member == null || this.memberInfo.get(member.getUUID()) != member) {
            return false;
        }
        if (member.getRank() != rank) {
            if (member.getRank() != PartyMemberRank.MEMBER) {
                this.removeStaff(member);
            }
            member.setRank(rank);
            if (rank != PartyMemberRank.MEMBER) {
                this.addStaff(member);
            }
        }
        return true;
    }

    public static abstract class Builder {
        protected PartyMember owner;
        protected UUID id;
        protected Map<UUID, PartyMember> memberInfo;
        protected Map<UUID, PartyInvite> invitedPlayers;
        protected Map<UUID, PartyAlly> allyParties;

        protected Builder() {
        }

        public Builder setDefault() {
            this.setOwner(null);
            this.setId(null);
            this.setMemberInfo(null);
            this.setInvitedPlayers(null);
            this.setAllyParties(null);
            return this;
        }

        public Builder setOwner(PartyMember owner) {
            if (!(owner == null || owner.isOwner() && owner.getRank() == PartyMemberRank.ADMIN)) {
                throw new IllegalArgumentException();
            }
            this.owner = owner;
            return this;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setMemberInfo(Map<UUID, PartyMember> memberInfo) {
            this.memberInfo = memberInfo;
            return this;
        }

        public Builder setInvitedPlayers(Map<UUID, PartyInvite> invitedPlayers) {
            this.invitedPlayers = invitedPlayers;
            return this;
        }

        public Builder setAllyParties(Map<UUID, PartyAlly> allyParties) {
            this.allyParties = allyParties;
            return this;
        }

        public Party build() {
            if (this.owner == null || this.id == null) {
                throw new IllegalStateException();
            }
            if (this.memberInfo == null) {
                this.memberInfo = new HashMap<UUID, PartyMember>();
            }
            if (this.invitedPlayers == null) {
                this.invitedPlayers = new HashMap<UUID, PartyInvite>();
            }
            if (this.allyParties == null) {
                this.allyParties = new HashMap<UUID, PartyAlly>();
            }
            this.owner.setRank(PartyMemberRank.ADMIN);
            LinkedChain<PartyMember> linkedMemberInfo = new LinkedChain<PartyMember>();
            LinkedChain<PartyInvite> linkedInvitedPlayers = new LinkedChain<PartyInvite>();
            LinkedChain<PartyAlly> linkedAllyParties = new LinkedChain<PartyAlly>();
            this.memberInfo.values().forEach(linkedMemberInfo::add);
            this.invitedPlayers.values().forEach(linkedInvitedPlayers::add);
            this.allyParties.values().forEach(linkedAllyParties::add);
            Party result = this.buildInternally(new ArrayList<PartyMember>(), linkedMemberInfo, linkedInvitedPlayers, linkedAllyParties);
            this.memberInfo.forEach((id, m) -> {
                if (m.getRank() != PartyMemberRank.MEMBER) {
                    result.addStaff((PartyMember)m);
                }
            });
            result.addStaff(this.owner);
            return result;
        }

        protected abstract Party buildInternally(List<PartyMember> var1, LinkedChain<PartyMember> var2, LinkedChain<PartyInvite> var3, LinkedChain<PartyAlly> var4);
    }
}

