/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.sync.player;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_3222;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.claims.ClientboundSubClaimPropertiesPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfo;
import xaero.pac.common.server.claims.sync.ClaimsManagerSynchronizer;
import xaero.pac.common.server.claims.sync.player.ClaimsManagerPlayerClaimOwnerPropertiesSync;
import xaero.pac.common.server.claims.sync.player.ClaimsManagerPlayerLazyPacketScheduler;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;

public final class ClaimsManagerPlayerSubClaimPropertiesSync
extends ClaimsManagerPlayerLazyPacketScheduler {
    private Iterator<ServerPlayerClaimInfo> toSync;
    private Iterator<IPlayerConfig> currentSubConfigIterator;
    private final ClaimsManagerPlayerClaimOwnerPropertiesSync claimOwnerPropertiesSync;

    private ClaimsManagerPlayerSubClaimPropertiesSync(Iterator<ServerPlayerClaimInfo> toSync, ClaimsManagerSynchronizer synchronizer, ClaimsManagerPlayerClaimOwnerPropertiesSync claimOwnerPropertiesSync) {
        super(synchronizer);
        this.toSync = toSync;
        this.claimOwnerPropertiesSync = claimOwnerPropertiesSync;
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player, int limit) {
        ArrayList<ClientboundSubClaimPropertiesPacket.SubClaimProperties> packetBuilder = new ArrayList<ClientboundSubClaimPropertiesPacket.SubClaimProperties>(32);
        int canSync = limit;
        while (canSync > 0 && (this.currentSubConfigIterator != null || this.toSync.hasNext())) {
            if (this.currentSubConfigIterator == null) {
                ServerPlayerClaimInfo playerClaimInfo = this.toSync.next();
                IPlayerConfig playerConfig = playerClaimInfo.getConfig();
                this.currentSubConfigIterator = playerConfig.getSubConfigIterator();
                this.buildClaimPropertiesPacket(packetBuilder, playerConfig, player);
                --canSync;
                continue;
            }
            while (canSync > 0 && this.currentSubConfigIterator.hasNext()) {
                IPlayerConfig subConfig = this.currentSubConfigIterator.next();
                this.buildClaimPropertiesPacket(packetBuilder, subConfig, player);
                --canSync;
            }
            if (this.currentSubConfigIterator.hasNext()) continue;
            this.currentSubConfigIterator = null;
        }
        if (!packetBuilder.isEmpty()) {
            this.synchronizer.syncSubClaimProperties(packetBuilder, player);
        }
    }

    private void buildClaimPropertiesPacket(List<ClientboundSubClaimPropertiesPacket.SubClaimProperties> packetBuilder, IPlayerConfig subConfig, class_3222 player) {
        ClientboundSubClaimPropertiesPacket.SubClaimProperties subClaimProperties = this.synchronizer.getSubClaimPropertiesForSync(subConfig, true);
        if (subClaimProperties != null) {
            packetBuilder.add(subClaimProperties);
            if (packetBuilder.size() == 32) {
                this.synchronizer.syncSubClaimProperties(packetBuilder, player);
                packetBuilder.clear();
            }
        }
    }

    @Override
    public void onLazyPacketsDropped() {
        this.toSync = null;
    }

    public boolean isFinished() {
        return this.claimOwnerPropertiesSync.isFinished() && (this.toSync == null || !this.toSync.hasNext());
    }

    @Override
    public boolean shouldWorkNotClogged(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_3222 player) {
        return this.started && this.claimOwnerPropertiesSync.isFinished() && !this.isFinished();
    }

    public static final class Builder {
        private ClaimsManagerSynchronizer synchronizer;
        private class_3222 player;
        private ClaimsManagerPlayerClaimOwnerPropertiesSync claimOwnerPropertiesSync;

        private Builder() {
        }

        public Builder setDefault() {
            this.setSynchronizer(null);
            this.setPlayer(null);
            this.setClaimOwnerPropertiesSync(null);
            return this;
        }

        public Builder setSynchronizer(ClaimsManagerSynchronizer synchronizer) {
            this.synchronizer = synchronizer;
            return this;
        }

        public Builder setPlayer(class_3222 player) {
            this.player = player;
            return this;
        }

        public Builder setClaimOwnerPropertiesSync(ClaimsManagerPlayerClaimOwnerPropertiesSync claimOwnerPropertiesSync) {
            this.claimOwnerPropertiesSync = claimOwnerPropertiesSync;
            return this;
        }

        public ClaimsManagerPlayerSubClaimPropertiesSync build() {
            if (this.synchronizer == null || this.player == null || this.claimOwnerPropertiesSync == null) {
                throw new IllegalStateException();
            }
            Iterator<ServerPlayerClaimInfo> toSync = this.synchronizer.getClaimPropertiesToSync(this.player);
            return new ClaimsManagerPlayerSubClaimPropertiesSync(toSync, this.synchronizer, this.claimOwnerPropertiesSync);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

