/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.config.ClientboundPlayerConfigHelpPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigGetOrHelpCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment) {
        SuggestionProvider<class_2168> optionSuggestor = ConfigGetOrHelpCommand.getOptionSuggestor();
        SuggestionProvider<class_2168> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<class_2168> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        this.registerGetCommands(false, optionSuggestor, playerSubConfigSuggestionProvider, serverSubConfigSuggestionProvider, dispatcher);
        this.registerGetCommands(true, optionSuggestor, playerSubConfigSuggestionProvider, serverSubConfigSuggestionProvider, dispatcher);
    }

    private void registerGetCommands(boolean help, SuggestionProvider<class_2168> optionSuggestor, SuggestionProvider<class_2168> playerSubConfigSuggestionProvider, SuggestionProvider<class_2168> serverSubConfigSuggestionProvider, CommandDispatcher<class_2168> dispatcher) {
        String literalPrefix = help ? "help" : "get";
        Command<class_2168> regularExecutor = ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.PLAYER, help);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)literalPrefix).requires(sourceStack -> true)).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(regularExecutor))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(class_2170.method_9247((String)"sub").then(((LiteralArgumentBuilder)class_2170.method_9247((String)literalPrefix).requires(sourceStack -> true)).then(class_2170.method_9244((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(playerSubConfigSuggestionProvider).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(regularExecutor))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"for").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(regularExecutor))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"for").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9247((String)"sub").then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(playerSubConfigSuggestionProvider).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(regularExecutor))))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"default").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.DEFAULT_PLAYER, help))))));
        dispatcher.register(command);
        Command<class_2168> serverExecutor = ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.SERVER, help);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server-claims-config").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(serverExecutor))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server-claims-config").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"sub").then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(serverSubConfigSuggestionProvider).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(serverExecutor))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"expired-claims-config").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.EXPIRED, help)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"wilderness-config").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor).executes(ConfigGetOrHelpCommand.getExecutor(PlayerConfigType.WILDERNESS, help)))));
        dispatcher.register(command);
    }

    static SuggestionProvider<class_2168> getOptionSuggestor() {
        return (context, builder) -> {
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(((class_2168)context.getSource()).method_9211());
            return class_2172.method_9264(serverData.getPlayerConfigs().getAllOptionsStream().map(IPlayerConfigOptionSpecAPI::getShortenedId), (SuggestionsBuilder)builder);
        };
    }

    private static Command<class_2168> getExecutor(PlayerConfigType type, boolean help) {
        return context -> {
            PlayerSubConfig subConfig;
            IPlayerConfig playerConfig;
            IPlayerConfig effectivePlayerConfig;
            UUID configPlayerUUID;
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
            String targetConfigOptionId = StringArgumentType.getString((CommandContext)context, (String)"key");
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)serverData.getPlayerConfigs().getOptionForId(targetConfigOptionId);
            if (option == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get_invalid_key", new Object[0]));
                return 0;
            }
            GameProfile inputPlayer = null;
            UUID uUID = configPlayerUUID = type == PlayerConfigType.SERVER ? PlayerConfig.SERVER_CLAIM_UUID : null;
            if (type == PlayerConfigType.PLAYER) {
                inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<class_2168>)context, sourcePlayer, "gui.xaero_pac_config_option_get_too_many_targets", "gui.xaero_pac_config_option_get_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.getId();
            }
            if ((effectivePlayerConfig = ConfigCommandUtil.getEffectiveConfig((CommandContext<class_2168>)context, playerConfig = type == PlayerConfigType.DEFAULT_PLAYER ? serverData.getPlayerConfigs().getDefaultConfig() : (type == PlayerConfigType.EXPIRED ? serverData.getPlayerConfigs().getExpiredClaimConfig() : serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID)))) == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get_invalid_sub", new Object[0]));
                return 0;
            }
            if (help) {
                ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(sourcePlayer);
                if (playerData.hasMod()) {
                    OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(sourcePlayer, new ClientboundPlayerConfigHelpPacket(option.getId()));
                } else {
                    String translatedComment = serverData.getAdaptiveLocalizer().getDefaultTranslation(option.getCommentTranslation(), option.getCommentTranslationArgs());
                    if (translatedComment.equals("default")) {
                        translatedComment = option.getComment();
                    }
                    sourcePlayer.method_43496((class_2561)class_2561.method_43470((String)""));
                    sourcePlayer.method_43496((class_2561)class_2561.method_43470((String)translatedComment));
                }
                return 1;
            }
            if (!effectivePlayerConfig.isOptionAllowed(option)) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get_not_allowed", new Object[0]));
                return 0;
            }
            Object optionValue = effectivePlayerConfig.getFromEffectiveConfig(option);
            if (effectivePlayerConfig instanceof PlayerSubConfig && (subConfig = (PlayerSubConfig)effectivePlayerConfig).isInherited(option)) {
                optionValue = null;
            }
            class_2561 optionValueName = option.getValueDisplayName(optionValue);
            if (type == PlayerConfigType.PLAYER) {
                sourcePlayer.method_43496((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get", inputPlayer.getName(), targetConfigOptionId, optionValueName));
            } else {
                sourcePlayer.method_43496((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_get", type.getName(), targetConfigOptionId, optionValueName));
            }
            return 1;
        };
    }
}

