/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.command.ConfigGetOrHelpCommand;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigSetCommand {
    private <T extends Comparable<T>> IPlayerConfigAPI.SetResult tryToSet(CommandContext<class_2168> context, class_3222 player, AdaptiveLocalizer adaptiveLocalizer, IPlayerConfig playerConfig, PlayerConfigOptionSpec<T> option, String valueInput, boolean reset) {
        IPlayerConfigAPI.SetResult result;
        if (reset) {
            result = playerConfig.tryToReset(option);
        } else {
            Comparable value;
            try {
                value = (Comparable)option.getCommandInputParser().apply(valueInput);
            }
            catch (Throwable t) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_pac_config_option_set_invalid_value_format", new Object[0]));
                return IPlayerConfigAPI.SetResult.INVALID;
            }
            result = playerConfig.tryToSet(option, value);
        }
        if (result == IPlayerConfigAPI.SetResult.INVALID) {
            ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_pac_config_option_set_invalid_value", new Object[0]));
        }
        return result;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment) {
        SuggestionProvider<class_2168> optionSuggestor = ConfigGetOrHelpCommand.getOptionSuggestor();
        SuggestionProvider<class_2168> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<class_2168> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        this.registerSetCommands("set", dispatcher, optionSuggestor, playerSubConfigSuggestionProvider, serverSubConfigSuggestionProvider, false);
        this.registerSetCommands("reset", dispatcher, optionSuggestor, playerSubConfigSuggestionProvider, serverSubConfigSuggestionProvider, true);
    }

    private void registerSetCommands(String literalPrefix, CommandDispatcher<class_2168> dispatcher, SuggestionProvider<class_2168> optionSuggestor, SuggestionProvider<class_2168> playerSubConfigSuggestionProvider, SuggestionProvider<class_2168> serverSubConfigSuggestionProvider, boolean reset) {
        Command<class_2168> regularExecutor = this.getExecutor(PlayerConfigType.PLAYER, reset);
        Command<class_2168> defaultExecutor = this.getExecutor(PlayerConfigType.DEFAULT_PLAYER, reset);
        Command<class_2168> serverExecutor = this.getExecutor(PlayerConfigType.SERVER, reset);
        Command<class_2168> expiredExecutor = this.getExecutor(PlayerConfigType.EXPIRED, reset);
        Command<class_2168> wildernessExecutor = this.getExecutor(PlayerConfigType.WILDERNESS, reset);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)literalPrefix).requires(sourceStack -> true)).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, regularExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(class_2170.method_9247((String)"sub").then(((LiteralArgumentBuilder)class_2170.method_9247((String)literalPrefix).requires(sourceStack -> true)).then(class_2170.method_9244((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(playerSubConfigSuggestionProvider).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, regularExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(class_2170.method_9247((String)"for").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, regularExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(class_2170.method_9247((String)"for").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"sub").then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(playerSubConfigSuggestionProvider).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, regularExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"default").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, defaultExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server-claims-config").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, serverExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server-claims-config").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"sub").then(class_2170.method_9247((String)literalPrefix).then(class_2170.method_9244((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(serverSubConfigSuggestionProvider).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, serverExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"expired-claims-config").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, expiredExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"wilderness-config").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)literalPrefix).then((ArgumentBuilder)this.addValueArgumentIfNeeded(reset, wildernessExecutor, class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(optionSuggestor)))));
        dispatcher.register(command);
    }

    private <T extends ArgumentBuilder<class_2168, T>> T addValueArgumentIfNeeded(boolean reset, Command<class_2168> executor, T builder) {
        if (reset) {
            return (T)builder.executes(executor);
        }
        return (T)builder.then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).executes(executor));
    }

    public Command<class_2168> getExecutor(PlayerConfigType type, boolean reset) {
        return context -> {
            PlayerSubConfig subConfig;
            String valueInput;
            UUID configPlayerUUID;
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
            String targetConfigOptionId = StringArgumentType.getString((CommandContext)context, (String)"key");
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)serverData.getPlayerConfigs().getOptionForId(targetConfigOptionId);
            if (option == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set_invalid_key", new Object[0]));
                return 0;
            }
            GameProfile inputPlayer = null;
            UUID uUID = configPlayerUUID = type == PlayerConfigType.SERVER ? PlayerConfig.SERVER_CLAIM_UUID : null;
            if (type == PlayerConfigType.PLAYER) {
                inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<class_2168>)context, sourcePlayer, "gui.xaero_pac_config_option_set_too_many_targets", "gui.xaero_pac_config_option_set_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.getId();
            }
            String string = valueInput = reset ? null : StringArgumentType.getString((CommandContext)context, (String)"value");
            IPlayerConfig playerConfig = type == PlayerConfigType.DEFAULT_PLAYER ? serverData.getPlayerConfigs().getDefaultConfig() : (type == PlayerConfigType.EXPIRED ? serverData.getPlayerConfigs().getExpiredClaimConfig() : serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID));
            IPlayerConfig effectivePlayerConfig = ConfigCommandUtil.getEffectiveConfig((CommandContext<class_2168>)context, playerConfig);
            if (effectivePlayerConfig == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set_invalid_sub", new Object[0]));
                return 0;
            }
            boolean isOP = ((class_2168)context.getSource()).method_9259(2);
            if (!isOP && PlayerConfig.isOptionOPConfigurable(option)) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_op_option", new Object[0]));
                return 0;
            }
            IPlayerConfigAPI.SetResult result = this.tryToSet((CommandContext<class_2168>)context, sourcePlayer, adaptiveLocalizer, effectivePlayerConfig, option, valueInput, reset);
            if (result == IPlayerConfigAPI.SetResult.INVALID) {
                return 0;
            }
            if (result == IPlayerConfigAPI.SetResult.ILLEGAL_OPTION) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set_illegal_option", new Object[0]));
                return 0;
            }
            Object wantedValue = reset ? effectivePlayerConfig.getDefaultRawValue(option) : option.getCommandInputParser().apply(valueInput);
            Object actualValue = effectivePlayerConfig.getFromEffectiveConfig(option);
            if (effectivePlayerConfig instanceof PlayerSubConfig && (subConfig = (PlayerSubConfig)effectivePlayerConfig).isInherited(option)) {
                actualValue = null;
            }
            class_2561 wantedValueName = option.getValueDisplayName(wantedValue);
            if (type == PlayerConfigType.PLAYER) {
                sourcePlayer.method_43496((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set", inputPlayer.getName(), targetConfigOptionId, wantedValueName));
            } else {
                sourcePlayer.method_43496((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set", type.getName(), targetConfigOptionId, wantedValueName));
            }
            if (result == IPlayerConfigAPI.SetResult.DEFAULTED && wantedValue != null && wantedValue != actualValue) {
                class_2561 actualValueName = option.getValueDisplayName(actualValue);
                sourcePlayer.method_43496((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_option_set_server_force", actualValueName));
            }
            return 1;
        };
    }
}

