/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyCommands;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class KickPartyCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<class_2168> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> mi.getRank().ordinal() >= PartyMemberRank.MODERATOR.ordinal());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"member").requires(requirement)).then(class_2170.method_9247((String)"kick").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PartyCommands.getPartyMemberOrInviteSuggestor()).executes(context -> {
            boolean casterIsOwner;
            String targetUsername;
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID playerId = player.method_5667();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(playerId);
            IPartyPlayerInfo targetPlayerInfo = (IPartyPlayerInfo)playerParty.getMemberInfo(targetUsername = StringArgumentType.getString((CommandContext)context, (String)"name"));
            if (targetPlayerInfo == null) {
                targetPlayerInfo = playerParty.getInvite(targetUsername);
            }
            if (targetPlayerInfo == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_kick_not_member", targetUsername));
                return 0;
            }
            IPartyMember casterInfo = (IPartyMember)playerParty.getMemberInfo(playerId);
            boolean targetIsMember = targetPlayerInfo instanceof IPartyMember;
            boolean bl = casterIsOwner = playerParty.getOwner() == casterInfo;
            if (targetIsMember) {
                IPartyMember targetMember = (IPartyMember)targetPlayerInfo;
                if (targetMember == playerParty.getOwner()) {
                    ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_kick_owner", new Object[0]));
                    return 0;
                }
                if (!casterIsOwner && targetMember.getRank().ordinal() > casterInfo.getRank().ordinal()) {
                    ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_kick_higher_rank", new Object[0]));
                    return 0;
                }
            }
            playerParty.uninvitePlayer(targetPlayerInfo.getUUID());
            if (targetIsMember) {
                playerParty.removeMember(targetPlayerInfo.getUUID());
                UUID targetPlayerId = targetPlayerInfo.getUUID();
                class_3222 kickedPlayer = server.method_3760().method_14602(targetPlayerId);
                if (kickedPlayer != null) {
                    server.method_3734().method_9241(kickedPlayer);
                    class_5250 acceptComponent = adaptiveLocalizer.getFor(kickedPlayer, "gui.xaero_parties_kick_target_message", playerParty.getDefaultName()).method_27694(s -> s.method_10977(class_124.field_1061));
                    kickedPlayer.method_43496((class_2561)acceptComponent);
                }
            }
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (class_2561)class_2561.method_43469((String)"gui.xaero_parties_kick_party_message", (Object[])new Object[]{class_2561.method_43470((String)casterInfo.getUsername()).method_27694(s -> s.method_10977(class_124.field_1077)), class_2561.method_43470((String)targetPlayerInfo.getUsername()).method_27694(s -> s.method_10977(class_124.field_1061))}));
            return 1;
        }))));
        dispatcher.register(command);
    }
}

